/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.service.ToaBillService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bill/diagram/rest"})
public class ProcessContentRestController {
    private static final Logger log = LoggerFactory.getLogger(ProcessContentRestController.class);
    private final HistoryService historyService;
    private final RepositoryService repositoryService;
    private final ProcessEngine processEngine;
    private final ToaBillService billService;

    @GetMapping(value={"/run/{billId}"})
    public void diagramRun(@PathVariable(value="billId") long billId, HttpServletResponse response) {
        InputStream activitiProccessImage;
        if (billId <= 0L) {
            return;
        }
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            return;
        }
        String processInstanceId = bill.getProcessInstanceId();
        if (!StringUtils.isEmpty((CharSequence)processInstanceId) && (activitiProccessImage = this.getActivitiProccessImage(processInstanceId)) != null) {
            try {
                IOUtils.copy((InputStream)activitiProccessImage, (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                log.error("the resopne stream has error!", (Throwable)e);
            }
        }
    }

    private InputStream getActivitiProccessImage(String pProcessInstanceId) {
        try {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pProcessInstanceId).singleResult();
            if (historicProcessInstance != null) {
                List historicActivityInstanceList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pProcessInstanceId).orderByHistoricActivityInstanceId().asc()).list();
                ArrayList executedActivityIdList = Lists.newArrayList();
                for (HistoricActivityInstance activityInstance : historicActivityInstanceList) {
                    executedActivityIdList.add(activityInstance.getActivityId());
                }
                String processDefinitionId = historicProcessInstance.getProcessDefinitionId();
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
                List<String> flowIds = this.getHighLightedFlows(bpmnModel, historicActivityInstanceList);
                return this.processEngine.getProcessEngineConfiguration().getProcessDiagramGenerator().generateDiagram(bpmnModel, "jpg", (List)executedActivityIdList, flowIds, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 2.0);
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5f02\u5e38\u3011-\u83b7\u53d6\u6d41\u7a0b\u56fe\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private List<String> getHighLightedFlows(BpmnModel bpmnModel, List<HistoricActivityInstance> historicActivityInstances) {
        ArrayList highFlows = Lists.newArrayList();
        int historicActivityInstanceSize = historicActivityInstances.size();
        for (int i = 0; i < historicActivityInstanceSize - 1; ++i) {
            HistoricActivityInstance historicActivity = historicActivityInstances.get(i);
            String activityId1 = historicActivity.getActivityId();
            FlowNode activityImpl = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId1);
            ArrayList sameStartTimeNodes = Lists.newArrayList();
            FlowNode sameActivityImpl1 = null;
            for (int k = i + 1; k <= historicActivityInstanceSize - 1; ++k) {
                HistoricActivityInstance activityImp2_ = historicActivityInstances.get(k);
                Date startTime = historicActivity.getEndTime();
                Date startTime2 = activityImp2_.getStartTime();
                String activityType = historicActivity.getActivityType();
                String activityType2 = activityImp2_.getActivityType();
                if (StringUtils.equals((CharSequence)activityType, (CharSequence)"userTask") && StringUtils.equals((CharSequence)"userTask", (CharSequence)activityType2) && !StringUtils.equals((CharSequence)DateUtil.formatDateTime((Date)startTime), (CharSequence)DateUtil.formatDateTime((Date)startTime2))) continue;
                String activityId = historicActivityInstances.get(k).getActivityId();
                sameActivityImpl1 = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
                break;
            }
            sameStartTimeNodes.add(sameActivityImpl1);
            for (int j = i + 1; j < historicActivityInstanceSize - 1; ++j) {
                HistoricActivityInstance activityImpl1 = historicActivityInstances.get(j);
                HistoricActivityInstance activityImpl2 = historicActivityInstances.get(j + 1);
                Date startTime = activityImpl1.getStartTime();
                Date startTime2 = activityImpl2.getStartTime();
                if (!StringUtils.equals((CharSequence)DateUtil.formatDateTime((Date)startTime), (CharSequence)DateUtil.formatDateTime((Date)startTime2))) break;
                FlowNode sameActivityImpl2 = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityImpl2.getActivityId());
                sameStartTimeNodes.add(sameActivityImpl2);
            }
            List sequenceFlows = activityImpl.getOutgoingFlows();
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                FlowNode pvmActivityImpl = (FlowNode)bpmnModel.getMainProcess().getFlowElement(sequenceFlow.getTargetRef());
                if (!sameStartTimeNodes.contains(pvmActivityImpl)) continue;
                highFlows.add(sequenceFlow.getId());
            }
        }
        return highFlows;
    }

    public ProcessContentRestController(HistoryService historyService, RepositoryService repositoryService, ProcessEngine processEngine, ToaBillService billService) {
        this.historyService = historyService;
        this.repositoryService = repositoryService;
        this.processEngine = processEngine;
        this.billService = billService;
    }
}

