/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Pair;
import com.jingtong.bpm.facde.dto.BaseProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessGridDTO;
import com.jingtong.bpm.logic.service.FormSettingLogic;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.service.ProcessDesingerLogic;
import com.jingtong.bpm.logic.service.ProcessFlowLogic;
import com.jingtong.config.BpmConfig;
import com.jingtong.data.rest.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/flow/process/rest"})
@Api(tags={"\u6d41\u7a0b\u7ba1\u7406"})
public class ProcessFlowRestController {
    private final DataSourceProperties dataSourceProperties;
    private final ProcessFlowLogic processFlowLogic;
    private final ProcessDesingerLogic processDesingerLogic;
    private final LoginUserHolder loginUserHolder;
    private final FormSettingLogic formSettingLogic;
    private final BpmConfig bpmConfig;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d41\u7a0b", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10")})
    @GetMapping(value={"/list"})
    public R<List<ProcessGridDTO>> grid(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String bloc = this.loginUserHolder.getBloc();
        Pair<List<ProcessGridDTO>, Long> pair = this.processFlowLogic.getProcessFlowByPage(pageNo, pageSize, params, bloc);
        return R.ok((Object)pair.getKey(), (Long)((Long)pair.getValue()));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u57fa\u672c\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"save"})
    public R save(@RequestBody BaseProcessDTO process) {
        String bloc = this.loginUserHolder.getBloc();
        return R.state((boolean)this.processFlowLogic.saveProcess(process, bloc));
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", httpMethod="DELETE")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @DeleteMapping(value={"/{id}"})
    public R remove(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        return R.state((boolean)this.processFlowLogic.removeProcess(processId));
    }

    @ApiOperation(value="\u64a4\u56de\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"/cancel/{id}"})
    public R cancel(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        return R.state((boolean)this.processFlowLogic.cancelProcess(processId));
    }

    @ApiOperation(value="\u542f\u7528\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"/enable/{id}"})
    public R enable(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        System.out.printf("a:" + this.dataSourceProperties.getUrl(), new Object[0]);
        return R.state((boolean)this.processFlowLogic.enableProcess(processId));
    }

    @ApiOperation(value="\u7981\u7528\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"/disable/{id}"})
    public R disable(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        return R.state((boolean)this.processFlowLogic.disableProcess(processId));
    }

    @ApiOperation(value="\u53d1\u5e03\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"release/{id}"})
    public R release(@PathVariable(value="id") long processId) {
        return R.state((boolean)this.processFlowLogic.releaseProcess(processId));
    }

    @PostMapping(value={"process/save"})
    public R save(@RequestParam(value="data") String processDesingerData, @RequestParam(value="id") long processId) {
        this.processDesingerLogic.saveProcessAndSetting(processDesingerData, processId);
        return R.empty();
    }

    @PostMapping(value={"/open"})
    public R open(@RequestParam(value="id") long processId) {
        boolean openState = this.processFlowLogic.openProcess(processId);
        return R.state((boolean)openState);
    }

    @PostMapping(value={"/closed"})
    public R closed(@RequestParam(value="id") long processId) {
        boolean openState = this.processFlowLogic.closeProcess(processId);
        return R.state((boolean)openState);
    }

    @PostMapping(value={"/temp/save/{id}"})
    public R savePrintTemp(@PathVariable(value="id") long processId, @RequestParam(value="file") MultipartFile var1) {
        boolean b = this.formSettingLogic.updatePrintTemp(processId, var1);
        return R.state((boolean)b);
    }

    @GetMapping(value={"/temp/down"})
    public void tempDown(String path, HttpServletResponse resp) {
        String filePath = this.bpmConfig.getFilePath();
        try {
            int len;
            FileInputStream inputStream = new FileInputStream(filePath + File.separator + path);
            String fileName = FileUtil.getName((String)path);
            String filename = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
            resp.setHeader("Content-Disposition", "attachment;filename=" + filename);
            ServletOutputStream servletOutputStream = resp.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)inputStream).read(buffer)) > 0) {
                servletOutputStream.write(buffer, 0, len);
            }
            servletOutputStream.flush();
            ((InputStream)inputStream).close();
            servletOutputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/formlink/save"})
    public R formLinkSave(@RequestParam(value="formLink", required=false, defaultValue="") String formLink, @RequestParam(value="approveLink", required=false, defaultValue="") String approveLink, @RequestParam(value="manualStartFlag", required=false, defaultValue="1") Integer manualStartFlag, @RequestParam(value="id") long processId) {
        boolean b = this.formSettingLogic.updateFormLink(processId, formLink, approveLink, manualStartFlag);
        return R.state((boolean)b);
    }

    public ProcessFlowRestController(DataSourceProperties dataSourceProperties, ProcessFlowLogic processFlowLogic, ProcessDesingerLogic processDesingerLogic, LoginUserHolder loginUserHolder, FormSettingLogic formSettingLogic, BpmConfig bpmConfig) {
        this.dataSourceProperties = dataSourceProperties;
        this.processFlowLogic = processFlowLogic;
        this.processDesingerLogic = processDesingerLogic;
        this.loginUserHolder = loginUserHolder;
        this.formSettingLogic = formSettingLogic;
        this.bpmConfig = bpmConfig;
    }
}

