/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import cn.hutool.core.lang.Pair;
import com.jingtong.bpm.logic.dto.ProcessTypeDTO;
import com.jingtong.bpm.logic.service.ProcessTypeLogic;
import com.jingtong.data.rest.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/process/type"})
@Api(tags={"\u6d41\u7a0b\u5206\u7c7b"})
public class ProcessTypeRestController {
    private final ProcessTypeLogic processTypeLogic;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d41\u7a0b\u5206\u7c7b", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10")})
    @GetMapping(value={"/list"})
    public R<List<ProcessTypeDTO>> grid(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        Pair<List<ProcessTypeDTO>, Long> pair = this.processTypeLogic.getProcessTypeByPage(pageNo, pageSize);
        return R.ok((Object)pair.getKey(), (Long)((Long)pair.getValue()));
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5206\u7c7b\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParam(name="id", value="id", required=true, paramType="path", dataType="String")
    @GetMapping(value={"/{id}"})
    public R<ProcessTypeDTO> detail(@ApiIgnore @PathVariable Long id) {
        ProcessTypeDTO processTypeDTO = this.processTypeLogic.getDetail(id);
        return R.ok((Object)processTypeDTO);
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5206\u7c7b", httpMethod="DELETE")
    @ApiImplicitParam(name="ids", value="\u591a\u4e2aid\u9017\u53f7\u9694\u5f00", required=true, paramType="path", dataType="String")
    @DeleteMapping(value={"/{ids}"})
    public R delete(@ApiIgnore @PathVariable String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        return R.state((boolean)this.processTypeLogic.batchDeleteByIds(idList));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u5206\u7c7b", httpMethod="POST")
    @PostMapping
    public R save(@Valid @RequestBody ProcessTypeDTO processType) {
        return R.state((boolean)this.processTypeLogic.save(processType));
    }

    public ProcessTypeRestController(ProcessTypeLogic processTypeLogic) {
        this.processTypeLogic = processTypeLogic;
    }
}

