/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.jingtong.bpm.facde.dto.BillItemDTO;
import com.jingtong.bpm.infra.service.FormThirdItemLogic;
import com.jingtong.bpm.logic.converts.BillBasicConvert;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.util.StringUtil;
import com.jingtong.bpm.logic.vo.BillItemVO;
import com.jingtong.data.rest.R;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/third/part/bill"})
public class ThirdPartBillController {
    private final FormThirdItemLogic formThirdItemLogic;
    private final BillLogic billLogic;
    private final BillBasicConvert billBasicConvert;

    @PostMapping(value={"/submit"})
    public R<BillItemDTO> submitFormData(@RequestBody JSONObject jsonObject) {
        Long processId = Long.valueOf(StringUtil.ob2str(jsonObject.get((Object)"processId")));
        Long billId = Long.valueOf(StringUtil.ob2str(jsonObject.get((Object)"billId")));
        String nextApprover = StringUtil.ob2str(jsonObject.get((Object)"nextApprover"));
        String billCode = StringUtil.ob2str(jsonObject.get((Object)"billCode"));
        if (Strings.isNullOrEmpty((String)nextApprover)) {
            nextApprover = "0";
        }
        String toForm = this.formThirdItemLogic.analysisToForm(jsonObject.getString("data"), processId);
        BillItemVO billItem = this.billLogic.startFlow(processId, billId, toForm, nextApprover, billCode);
        return R.ok((Object)this.billBasicConvert.billItemVOToDTO(billItem));
    }

    @PostMapping(value={"/save"})
    public R<BillItemDTO> saveFormData(@RequestBody JSONObject jsonObject) {
        Long processId = Long.valueOf(StringUtil.ob2str(jsonObject.get((Object)"processId")));
        Long billId = Long.valueOf(StringUtil.ob2str(jsonObject.get((Object)"billId")));
        String toForm = this.formThirdItemLogic.analysisToForm(jsonObject.getString("data"), processId);
        BillItemVO billItem = this.billLogic.saveDrafts(processId, billId, toForm);
        return R.ok((Object)this.billBasicConvert.billItemVOToDTO(billItem));
    }

    @PostMapping(value={"/convert"})
    public R convert(String data, Long processId) {
        String toForm = this.formThirdItemLogic.analysisToForm(data, processId);
        return R.ok((Object)toForm);
    }

    public ThirdPartBillController(FormThirdItemLogic formThirdItemLogic, BillLogic billLogic, BillBasicConvert billBasicConvert) {
        this.formThirdItemLogic = formThirdItemLogic;
        this.billLogic = billLogic;
        this.billBasicConvert = billBasicConvert;
    }
}

