/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import cn.hutool.core.lang.Pair;
import com.google.common.base.MoreObjects;
import com.jingtong.bpm.logic.dto.DataTablesInputDTO;
import com.jingtong.bpm.logic.dto.DataTablesOutputDTO;
import com.jingtong.bpm.logic.dto.UserChooseDTO;
import com.jingtong.bpm.logic.query.UserChooseQuery;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/center"})
public class UserCenterController {
    private final UserCenterlogic userCenterlogic;

    @PostMapping(value={"/datagrids"})
    public DataTablesOutputDTO<UserChooseDTO> datatables(@Valid @RequestBody DataTablesInputDTO dataTablesInput) {
        if (dataTablesInput.getLength() == -1) {
            dataTablesInput.setStart(0);
            dataTablesInput.setLength(Integer.MAX_VALUE);
        }
        UserChooseQuery query = (UserChooseQuery)dataTablesInput.getParams().toJavaObject(UserChooseQuery.class);
        int start = (Integer)MoreObjects.firstNonNull((Object)dataTablesInput.getStart(), (Object)0);
        int current = start / dataTablesInput.getLength();
        Pair<List<UserChooseDTO>, Long> result = this.userCenterlogic.getChooseUsers(current, dataTablesInput.getLength(), query);
        DataTablesOutputDTO<UserChooseDTO> dataTablesOutput = new DataTablesOutputDTO<UserChooseDTO>();
        dataTablesOutput.setRecordsTotal((Long)result.getValue());
        dataTablesOutput.setRecordsFiltered((Long)result.getValue());
        dataTablesOutput.setData((List)result.getKey());
        return dataTablesOutput;
    }

    public UserCenterController(UserCenterlogic userCenterlogic) {
        this.userCenterlogic = userCenterlogic;
    }
}

