/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.BillReadRecordDao;
import com.jingtong.bpm.infra.entity.BillReadRecordEntity;
import com.jingtong.bpm.infra.service.BillReadRecordService;
import com.jingtong.util.datetime.DateTimeUtil;
import java.time.LocalDateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillReadRecordServiceImpl
extends BaseServiceImpl<BillReadRecordDao, BillReadRecordEntity>
implements BillReadRecordService {
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public boolean readBillByUserCode(long billId, String userCode) {
        BillReadRecordEntity billReadRecord = (BillReadRecordEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillReadRecordEntity.class).eq(BillReadRecordEntity::getBillId, (Object)billId)).eq(BillReadRecordEntity::getUserCode, (Object)userCode)));
        if (billReadRecord == null) {
            int readTime = DateTimeUtil.unixTime();
            billReadRecord = new BillReadRecordEntity();
            billReadRecord.setBillId(billId);
            billReadRecord.setUserCode(userCode);
            billReadRecord.setCreationTime(LocalDateTime.now());
            billReadRecord.setReadTime(readTime);
            return this.insert(billReadRecord);
        }
        return true;
    }

    @Override
    public void deleteByBillAndEmployeeId(Long billId, String userCode) {
        this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillReadRecordEntity.class).eq(BillReadRecordEntity::getBillId, (Object)billId)).eq(BillReadRecordEntity::getUserCode, (Object)userCode));
    }

    @Override
    public boolean deleteByBillId(long billId) {
        this.remove((Wrapper)Wrappers.lambdaQuery(BillReadRecordEntity.class).eq(BillReadRecordEntity::getBillId, (Object)billId));
        return true;
    }
}

