/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.BillTaskDao;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.po.BillApprovalHistoryPO;
import com.jingtong.bpm.infra.service.BillTaskService;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.BillTaskStatus;
import com.jingtong.bpm.logic.constant.BillTaskType;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.dto.BillActionParamDTO;
import com.jingtong.bpm.logic.dto.BillTaskDTO;
import com.jingtong.util.datetime.DateTimeUtil;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BillTaskServiceImpl
extends BaseServiceImpl<BillTaskDao, BillTaskEntity>
implements BillTaskService {
    @Override
    public List<BillTaskEntity> findTaskByBillAndUserCode(long billId, String userCode) {
        List<BillTaskEntity> billTask = ((BillTaskDao)this.baseMapper).selectTaskByBillAndUserCode(billId, userCode);
        return billTask;
    }

    @Override
    public Map<String, List<BillTaskEntity>> findApprovedByBill(long billId) {
        if (billId <= 0L) {
            return Collections.emptyMap();
        }
        List billTasks = this.list((Wrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId));
        if (CollectionUtil.isNotEmpty((Collection)billTasks)) {
            Map<String, List<BillTaskEntity>> collect = billTasks.stream().collect(Collectors.groupingBy(BillTaskEntity::getNodeName));
            return collect;
        }
        return Collections.emptyMap();
    }

    @Override
    public void updateByReFullIn(long billId, String userCode) {
        if (billId > 0L && !Strings.isNullOrEmpty((String)userCode)) {
            ((BillTaskDao)this.baseMapper).updateByRefullIn(billId, userCode, DateTimeUtil.unixTime());
        }
    }

    @Override
    public com.google.common.base.Optional<BillTaskEntity> findByBillAndEmployeeAndTaskId(long billId, String taskId, String userCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId)).eq(BillTaskEntity::getTaskId, (Object)taskId)).eq(BillTaskEntity::getUserCode, (Object)userCode)).orderByDesc(BillTaskEntity::getSort);
        Optional optional = this.unique(queryWrapper);
        if (!optional.isPresent()) {
            return com.google.common.base.Optional.absent();
        }
        return com.google.common.base.Optional.of(optional.get());
    }

    @Override
    public int findActiveExcludeSelf(Long billId, String taskId, Long id) {
        return ((BillTaskDao)this.baseMapper).selectActiveExcludeSelf(billId, taskId, id, BillTaskStatus.AGREE.getStatus());
    }

    @Override
    public int findTotalCount(Long billId, String taskId, int type) {
        return ((BillTaskDao)this.baseMapper).selectTotalCount(billId, taskId, type);
    }

    @Override
    public void agreeTask(BillTaskEntity task, String userCode, BillActionParamDTO actionParam) {
        int dateline = DateTimeUtil.unixTime();
        task.setNodeStatus(BillTaskStatus.AGREE.getStatus());
        task.setUserCode(userCode);
        task.setUpdateTime(LocalDateTime.now());
        task.setOpinion(actionParam.getOpinion());
        task.setDateline(dateline);
        task.setAction(BillAction.agree.name());
        task.setId(null);
        LambdaUpdateWrapper billTaskEntityLambdaUpdateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)billTaskEntityLambdaUpdateWrapper.eq(BillTaskEntity::getBillId, (Object)actionParam.getBillId())).eq(BillTaskEntity::getUserCode, (Object)userCode)).eq(BillTaskEntity::getTaskId, (Object)actionParam.getTaskId())).eq(BillTaskEntity::getNodeStatus, (Object)BillTaskStatus.APPROVAL.getStatus());
        this.update((Object)task, (Wrapper)billTaskEntityLambdaUpdateWrapper);
    }

    @Override
    public void deleteApproval(Long billId, String taskId, int status) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId)).eq(BillTaskEntity::getTaskId, (Object)taskId)).eq(BillTaskEntity::getNodeStatus, (Object)status);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<BillApprovalHistoryPO> findByBill(ToaBillEntity bill) {
        long billId = bill.getId();
        List<BillApprovalHistoryPO> approvalHistorys = ((BillTaskDao)this.baseMapper).selectHistoryByBillId(billId);
        return approvalHistorys;
    }

    @Override
    public List<BillTaskEntity> findByBillId(long billId) {
        return this.list((Wrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId));
    }

    @Override
    public List<BillTaskEntity> findApprovingByBillAndTaskId(long billId, String taskId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId)).eq(BillTaskEntity::getTaskType, (Object)BillTaskType.DEFAULT.getValue());
        ((LambdaQueryWrapper)queryWrapper.eq(BillTaskEntity::getNodeStatus, (Object)BillTaskStatus.APPROVAL.getStatus())).eq(BillTaskEntity::getTaskId, (Object)taskId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<BillTaskEntity> findEndorseByUserAndTaskId(long billId, String taskId, String userCode) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(BillTaskEntity.class);
        queryWrapper.eq(BillTaskEntity::getBillId, (Object)billId);
        queryWrapper.eq(BillTaskEntity::getTaskId, (Object)taskId);
        queryWrapper.eq(BillTaskEntity::getUserCode, (Object)userCode);
        queryWrapper.eq(BillTaskEntity::getTaskType, (Object)BillTaskType.ENDORSE.getValue());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public BillTaskEntity findCreateTaskByBill(long billId) {
        return ((BillTaskDao)this.baseMapper).selectCreateTaskByBill(billId, NodeLinkType.create.name());
    }

    @Override
    public void saveSkipTask(String taskNodeId, Long billId, String taskId, String taskName, String lastTaskNodeId, String lastTaskId) {
        BillTaskEntity billTask = new BillTaskEntity();
        billTask.setAction(BillAction.none.name());
        billTask.setSort(System.currentTimeMillis());
        billTask.setTaskNodeKey(taskNodeId);
        billTask.setBillId(billId);
        billTask.setTaskType(BillTaskType.SKIP.getValue());
        billTask.setNodeStatus(BillTaskStatus.SKIP.getStatus());
        billTask.setNodeName(taskName);
        billTask.setTaskId(taskId);
        billTask.setDateline(DateTimeUtil.unixTime());
        billTask.setOpinion("\u81ea\u52a8\u8df3\u8fc7");
        billTask.setLastNodeKey(lastTaskNodeId);
        billTask.setLastTaskId(lastTaskId);
        this.insert(billTask);
    }

    @Override
    public List<BillTaskEntity> findApprovingByBillAndUser(long billId, String user) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId)).eq(BillTaskEntity::getNodeStatus, (Object)BillTaskStatus.APPROVAL)).eq(BillTaskEntity::getUserCode, (Object)user);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<BillTaskDTO> getHistoryTasks(Long billid) {
        return ((BillTaskDao)this.baseMapper).selectHistoryTasks(billid);
    }

    @Override
    public List<BillTaskEntity> findApprovedByBillAndUser(long billId, String user) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId)).in(BillTaskEntity::getNodeStatus, new Object[]{BillTaskStatus.AGREE, BillTaskStatus.REFUSE, BillTaskStatus.REPULSE})).eq(BillTaskEntity::getUserCode, (Object)user);
        return this.list((Wrapper)queryWrapper);
    }
}

