/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.FormDetailSettingDao;
import com.jingtong.bpm.infra.entity.FormDetailSettingEntity;
import com.jingtong.bpm.infra.entity.FormFieldEntity;
import com.jingtong.bpm.infra.entity.ToaFormEntity;
import com.jingtong.bpm.infra.service.FormDetailSettingService;
import com.jingtong.bpm.logic.dto.ColumnMappingDto;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.vo.DetailTemplateVo;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.error.ErrorCode;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormDetailSettingServiceImpl
extends BaseServiceImpl<FormDetailSettingDao, FormDetailSettingEntity>
implements FormDetailSettingService {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createDetailSetting(List<FormFieldEntity> detailFields, ToaFormEntity form) {
        long formId = form.getId();
        long processId = form.getProcessId();
        DetailTemplateVo detailTemplateVo = new DetailTemplateVo();
        detailTemplateVo.setFileName(form.getCode());
        detailTemplateVo.setProcessId(processId);
        detailTemplateVo.setDetailFields(detailFields);
        ArrayList columnMappings = Lists.newArrayList();
        for (FormFieldEntity formField : detailFields) {
            ColumnMappingDto columnMappingDto = new ColumnMappingDto();
            columnMappingDto.setFiled(formField.getWidgetName());
            columnMappingDto.setType(formField.getType());
            columnMappings.add(columnMappingDto);
        }
        FormDetailSettingEntity formDetailSetting = (FormDetailSettingEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(FormDetailSettingEntity.class).eq(FormDetailSettingEntity::getProcessId, (Object)processId)));
        if (formDetailSetting == null) {
            formDetailSetting = new FormDetailSettingEntity();
            formDetailSetting.setFormId(formId);
            formDetailSetting.setProcessId(processId);
            formDetailSetting.setColumnMapping(JSON.toJSONString((Object)columnMappings));
            boolean res = this.insert(formDetailSetting);
            if (!res) {
                throw new RbException((ErrorCode)BillCode.BILL_DETAILL_SAVE_ERROR);
            }
        } else {
            formDetailSetting.setColumnMapping(JSON.toJSONString((Object)columnMappings));
            boolean res = this.updateById((Object)formDetailSetting);
            if (!res) {
                throw new RbException((ErrorCode)BillCode.BILL_DETAILL_SAVE_ERROR);
            }
        }
    }
}

