/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.FormFieldDao;
import com.jingtong.bpm.infra.entity.FormFieldEntity;
import com.jingtong.bpm.infra.po.FormFieldPO;
import com.jingtong.bpm.infra.service.FormFieldService;
import com.jingtong.bpm.logic.converts.FormBasicConvert;
import com.jingtong.bpm.logic.define.FormXtype;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FormFieldServiceImpl
extends BaseServiceImpl<FormFieldDao, FormFieldEntity>
implements FormFieldService {
    private final FormBasicConvert formBasicConvert;

    @Override
    public List<FormFieldEntity> findBizFiled(long processId, FormXtype xtype) {
        if (processId <= 0L) {
            return null;
        }
        return ((FormFieldDao)this.baseMapper).selectByProcessIdAndXtype(processId, xtype.name());
    }

    @Override
    public List<FormFieldPO> findVoByProcessId(long processId) {
        if (processId <= 0L) {
            return Collections.emptyList();
        }
        List<FormFieldEntity> fields = ((FormFieldDao)this.baseMapper).selectByProcessId(processId);
        if (CollectionUtil.isEmpty(fields)) {
            return Collections.emptyList();
        }
        return this.convertVO(fields);
    }

    @Override
    public List<FormFieldPO> findPOByFormId(long formId) {
        if (formId <= 0L) {
            return Collections.emptyList();
        }
        List fields = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FormFieldEntity.class).eq(FormFieldEntity::getFormId, (Object)formId)).orderByAsc(FormFieldEntity::getFieldId)).orderByAsc(FormFieldEntity::getSort));
        if (CollectionUtil.isEmpty((Collection)fields)) {
            return Collections.emptyList();
        }
        return this.convertVO(fields);
    }

    @Override
    public FormFieldPO findByWidgetName(String widgetName) {
        Optional unique = this.unique((LambdaQueryWrapper)Wrappers.lambdaQuery(FormFieldEntity.class).eq(FormFieldEntity::getWidgetName, (Object)widgetName));
        if (unique.isPresent()) {
            return this.formBasicConvert.formFieldEntityToPO((FormFieldEntity)((Object)unique.get()));
        }
        return null;
    }

    private List<FormFieldPO> convertVO(List<FormFieldEntity> fields) {
        ArrayList fieldVOS = Lists.newArrayListWithCapacity((int)fields.size());
        HashMap detailGroup = Maps.newHashMap();
        for (FormFieldEntity field : fields) {
            long fieldId;
            String type = field.getType();
            Long id = field.getId();
            FormFieldPO formFieldVO = new FormFieldPO();
            formFieldVO.setId(id);
            formFieldVO.setWidgetName(field.getWidgetName());
            formFieldVO.setTitle(field.getTitle());
            formFieldVO.setType(type);
            formFieldVO.setDescription(field.getDescription());
            formFieldVO.setFormId(field.getFormId());
            formFieldVO.setPlaceholder(field.getPlaceholder());
            formFieldVO.setDatasourceCode(field.getDatasourceCode());
            formFieldVO.setBizType(field.getBizType());
            formFieldVO.setSort(field.getSort());
            String props = field.getProps();
            Map map = (Map)JSON.parseObject((String)props, Map.class);
            Object widget = map.get("widget");
            if (widget != null) {
                formFieldVO.setProps(JSON.toJSONString(widget));
            } else {
                formFieldVO.setProps(field.getProps());
            }
            formFieldVO.setRequired(field.getRequired());
            ArrayList formFieldVOS = Lists.newArrayList();
            formFieldVO.setDetailFields(formFieldVOS);
            if (StringUtils.equals((CharSequence)type, (CharSequence)FormXtype.detailgroup.name())) {
                detailGroup.put(id, formFieldVO);
            }
            if ((fieldId = ((Long)MoreObjects.firstNonNull((Object)field.getFieldId(), (Object)0L)).longValue()) > 0L) {
                FormFieldPO detailGroupField = (FormFieldPO)detailGroup.get(fieldId);
                detailGroupField.getDetailFields().add(formFieldVO);
                continue;
            }
            fieldVOS.add(formFieldVO);
        }
        return fieldVOS;
    }

    public FormFieldServiceImpl(FormBasicConvert formBasicConvert) {
        this.formBasicConvert = formBasicConvert;
    }
}

