/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.FormSettingDao;
import com.jingtong.bpm.infra.entity.FormSettingEntity;
import com.jingtong.bpm.infra.service.FormSettingService;
import com.jingtong.config.BpmConfig;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class FormSettingServiceImpl
extends BaseServiceImpl<FormSettingDao, FormSettingEntity>
implements FormSettingService {
    private final BpmConfig bpmConfig;

    @Override
    public Optional<FormSettingEntity> findByFormId(Long id) {
        return this.unique((LambdaQueryWrapper)Wrappers.lambdaQuery(FormSettingEntity.class).eq(FormSettingEntity::getFormId, (Object)id));
    }

    @Override
    public FormSettingEntity findByProcess(long processId) {
        return ((FormSettingDao)this.baseMapper).selectByProcess(processId);
    }

    @Override
    public String getPrintTmp(Long processId) {
        FormSettingEntity byProcess = this.findByProcess(processId);
        if (Objects.isNull((Object)byProcess)) {
            return "";
        }
        return this.bpmConfig.getFilePath() + File.separator + byProcess.getPrintTemplatePath();
    }

    public FormSettingServiceImpl(BpmConfig bpmConfig) {
        this.bpmConfig = bpmConfig;
    }
}

