/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jingtong.bpm.infra.entity.FormThirdEntity;
import com.jingtong.bpm.infra.entity.FormThirdItemEntity;
import com.jingtong.bpm.infra.entity.ToaFormEntity;
import com.jingtong.bpm.infra.po.FormFieldPO;
import com.jingtong.bpm.infra.service.FormFieldService;
import com.jingtong.bpm.infra.service.FormThirdItemLogic;
import com.jingtong.bpm.infra.service.FormThirdItemService;
import com.jingtong.bpm.infra.service.FormThirdService;
import com.jingtong.bpm.infra.service.ToaFormService;
import com.jingtong.bpm.logic.converts.FormBasicConvert;
import com.jingtong.bpm.logic.dto.FormThirdDTO;
import com.jingtong.bpm.logic.dto.FormThirdItemDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormThirdItemLogicImpl
implements FormThirdItemLogic {
    private final FormThirdService formThirdService;
    private final FormThirdItemService formThirdItemService;
    private final ToaFormService formService;
    private final FormFieldService formFieldService;
    private final FormBasicConvert formBasicConvert;

    @Override
    public String analysisToForm(String dataStr, Long processId) {
        JSONObject data = JSON.parseObject((String)dataStr);
        List<FormThirdItemEntity> thirdItemList = this.formThirdItemService.findItemsByProcessId(processId);
        ConcurrentMap dataMap = Maps.newConcurrentMap();
        if (CollectionUtil.isEmpty(thirdItemList)) {
            return JSON.toJSONString((Object)dataMap);
        }
        Map<String, String> map = thirdItemList.stream().collect(Collectors.toMap(FormThirdItemEntity::getThirdKey, FormThirdItemEntity::getFormFiled));
        for (String s : data.keySet()) {
            Object o = data.get((Object)s);
            String key = map.get(s);
            if (Strings.isNullOrEmpty((String)key)) continue;
            if (o instanceof JSONArray) {
                ArrayList items = Lists.newArrayList();
                JSONArray tmp = (JSONArray)o;
                for (Object o1 : tmp) {
                    ConcurrentMap ttt = Maps.newConcurrentMap();
                    JSONObject tt = (JSONObject)o1;
                    for (String s1 : tt.keySet()) {
                        String key1 = map.get(s1);
                        if (Strings.isNullOrEmpty((String)key1)) continue;
                        Object value = tt.get((Object)s1);
                        if (NumberUtil.isNumber((CharSequence)value.toString())) {
                            ttt.put(key1, NumberUtil.toBigDecimal((String)value.toString()).doubleValue());
                            continue;
                        }
                        ttt.put(key1, value);
                    }
                    items.add(ttt);
                }
                dataMap.put(key, items);
                continue;
            }
            if (NumberUtil.isNumber((CharSequence)o.toString())) {
                dataMap.put(key, NumberUtil.toBigDecimal((String)o.toString()).doubleValue());
                continue;
            }
            dataMap.put(key, o);
        }
        return JSON.toJSONString((Object)dataMap);
    }

    @Override
    public List<FormThirdItemDTO> findByProcessId(Long processId) {
        ToaFormEntity formEntity = (ToaFormEntity)((Object)this.formService.getOne((Wrapper)Wrappers.lambdaQuery(ToaFormEntity.class).eq(ToaFormEntity::getProcessId, (Object)processId)));
        Long formId = formEntity.getId();
        FormThirdEntity formThirdEntity = (FormThirdEntity)((Object)this.formThirdService.getOne((Wrapper)Wrappers.lambdaQuery(FormThirdEntity.class).eq(FormThirdEntity::getFormId, (Object)formId)));
        List<FormFieldPO> poByFormId = this.formFieldService.findPOByFormId(formId);
        if (Objects.isNull((Object)formThirdEntity)) {
            ArrayList result = Lists.newArrayList();
            for (FormFieldPO formFieldPO : poByFormId) {
                FormThirdItemDTO formThirdItemDTO = new FormThirdItemDTO();
                formThirdItemDTO.setFormFiled(formFieldPO.getWidgetName());
                formThirdItemDTO.setName(formFieldPO.getTitle());
                result.add(formThirdItemDTO);
                List<FormFieldPO> detailFields = formFieldPO.getDetailFields();
                if (!CollectionUtil.isNotEmpty(detailFields)) continue;
                for (FormFieldPO detailField : detailFields) {
                    FormThirdItemDTO formThirdItemDTO1 = new FormThirdItemDTO();
                    formThirdItemDTO1.setFormFiled(detailField.getWidgetName());
                    formThirdItemDTO1.setName(formFieldPO.getTitle() + "-\u660e\u7ec6-" + detailField.getTitle());
                    result.add(formThirdItemDTO1);
                }
            }
            return result;
        }
        List<FormThirdItemEntity> itemsByProcessId = this.formThirdItemService.findItemsByProcessId(processId);
        Map<String, FormThirdItemEntity> configMap = itemsByProcessId.stream().collect(Collectors.toMap(FormThirdItemEntity::getFormFiled, a -> a, (a, b) -> a));
        ArrayList result = Lists.newArrayList();
        for (FormFieldPO formFieldPO : poByFormId) {
            FormThirdItemDTO formThirdItemDTO = new FormThirdItemDTO();
            String widgetName = formFieldPO.getWidgetName();
            formThirdItemDTO.setFormFiled(widgetName);
            formThirdItemDTO.setName(formFieldPO.getTitle());
            FormThirdItemEntity formThirdItemEntity = configMap.get(widgetName);
            if (!Objects.isNull((Object)formThirdItemEntity)) {
                formThirdItemDTO.setThirdKey(formThirdItemEntity.getThirdKey());
            }
            result.add(formThirdItemDTO);
            List<FormFieldPO> detailFields = formFieldPO.getDetailFields();
            if (!CollectionUtil.isNotEmpty(detailFields)) continue;
            for (FormFieldPO detailField : detailFields) {
                FormThirdItemDTO formThirdItemDTO1 = new FormThirdItemDTO();
                formThirdItemDTO1.setFormFiled(detailField.getWidgetName());
                formThirdItemDTO1.setName(formFieldPO.getTitle() + "-\u660e\u7ec6-" + detailField.getTitle());
                FormThirdItemEntity formThirdItemEntity1 = configMap.get(detailField.getWidgetName());
                if (!Objects.isNull((Object)formThirdItemEntity1)) {
                    formThirdItemDTO1.setThirdKey(formThirdItemEntity1.getThirdKey());
                }
                result.add(formThirdItemDTO1);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(FormThirdDTO formThirdDTO) {
        ToaFormEntity formEntity = (ToaFormEntity)((Object)this.formService.getOne((Wrapper)Wrappers.lambdaQuery(ToaFormEntity.class).eq(ToaFormEntity::getProcessId, (Object)formThirdDTO.getProcessId())));
        Long formId = formEntity.getId();
        LambdaQueryWrapper thirdEntityLambdaQueryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(FormThirdEntity.class).eq(FormThirdEntity::getFormId, (Object)formId);
        FormThirdEntity one = (FormThirdEntity)((Object)this.formThirdService.getOne((Wrapper)thirdEntityLambdaQueryWrapper));
        if (!Objects.isNull((Object)one)) {
            Long id = one.getId();
            this.formThirdService.physicalDeleteById(id);
            this.formThirdItemService.physicalDeleteByThirdId(id);
        }
        List<FormThirdItemDTO> itemDTOS = formThirdDTO.getItemDTOS();
        List<FormThirdItemEntity> formThirdItemEntities = this.formBasicConvert.formThirdItemDTOToEntity(itemDTOS);
        one = new FormThirdEntity();
        one.setFormId(formId);
        one.setName(formEntity.getName());
        one.setId(IdWorker.getId());
        this.formThirdService.save((Object)one);
        ArrayList insertLists = Lists.newArrayList();
        for (FormThirdItemEntity formThirdItemEntity : formThirdItemEntities) {
            formThirdItemEntity.setThirdId(one.getId());
            if (Strings.isNullOrEmpty((String)formThirdItemEntity.getThirdKey())) continue;
            insertLists.add(formThirdItemEntity);
        }
        if (CollectionUtil.isNotEmpty((Collection)insertLists)) {
            this.formThirdItemService.saveBatch(insertLists);
        }
    }

    public FormThirdItemLogicImpl(FormThirdService formThirdService, FormThirdItemService formThirdItemService, ToaFormService formService, FormFieldService formFieldService, FormBasicConvert formBasicConvert) {
        this.formThirdService = formThirdService;
        this.formThirdItemService = formThirdItemService;
        this.formService = formService;
        this.formFieldService = formFieldService;
        this.formBasicConvert = formBasicConvert;
    }
}

