/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.ProcessDesingerDao;
import com.jingtong.bpm.infra.entity.ProcessDesingerEntity;
import com.jingtong.bpm.infra.service.ProcessDesingerService;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.vo.ProcessDesingerVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.error.ErrorCode;
import org.springframework.stereotype.Service;

@Service
public class ProcessDesingerServiceImpl
extends BaseServiceImpl<ProcessDesingerDao, ProcessDesingerEntity>
implements ProcessDesingerService {
    @Override
    public void saveOrUpdateByProcess(long processId, String processDesingerJSON, ProcessDesingerVO processDesingerVO) {
        ProcessDesingerEntity desinger = (ProcessDesingerEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(ProcessDesingerEntity.class).eq(ProcessDesingerEntity::getProcessId, (Object)processId)));
        if (desinger == null) {
            desinger = new ProcessDesingerEntity();
            desinger.setProcessId(processId);
            desinger.setProcessXml(processDesingerVO.getXml());
            desinger.setDesingerJson(processDesingerJSON);
            boolean desingerSaveState = this.insert(desinger);
            if (!desingerSaveState) {
                throw new RbException((ErrorCode)BillCode.PROCESS_DESIGN_SAVE_ERROR);
            }
        } else {
            desinger.setProcessXml(processDesingerVO.getXml());
            desinger.setDesingerJson(processDesingerJSON);
            boolean desingerUpdateState = this.updateById((Object)desinger);
            if (!desingerUpdateState) {
                throw new RbException((ErrorCode)BillCode.PROCESS_DESIGN_SAVE_ERROR);
            }
        }
    }
}

