/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.ProcessNodeExtendDao;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.data.exception.RbException;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ProcessNodeExtendServiceImpl
extends BaseServiceImpl<ProcessNodeExtendDao, ProcessNodeExtendEntity>
implements ProcessNodeExtendService {
    @Override
    public void saveOrUpdate(List<ProcessNodeExtendEntity> nodeExtends, long processId) {
        boolean b;
        this.remove((Wrapper)Wrappers.lambdaQuery(ProcessNodeExtendEntity.class).eq(ProcessNodeExtendEntity::getProcessId, (Object)processId));
        if (CollectionUtil.isNotEmpty(nodeExtends) && !(b = this.saveBatch(nodeExtends))) {
            throw new RbException("insert batch node extend has error!");
        }
    }

    @Override
    public List<ProcessNodeExtendEntity> findTaskNodeByProcess(long processId) {
        if (processId <= 0L) {
            return Collections.emptyList();
        }
        return ((ProcessNodeExtendDao)this.baseMapper).selectByProcessAndNodeType(processId, "task");
    }

    @Override
    public Optional<ProcessNodeExtendEntity> findByTaskId(String taskId) {
        if (Strings.isNullOrEmpty((String)taskId)) {
            return Optional.absent();
        }
        ProcessNodeExtendEntity nodeExtend = ((ProcessNodeExtendDao)this.baseMapper).selectByTaskId(taskId);
        if (nodeExtend == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)nodeExtend));
    }

    @Override
    public Optional<ProcessNodeExtendEntity> findByFlowIdAndNodeId(String nodeId, String flowId) {
        if (Strings.isNullOrEmpty((String)nodeId) || Strings.isNullOrEmpty((String)flowId)) {
            return Optional.absent();
        }
        ProcessNodeExtendEntity nodeExtend = ((ProcessNodeExtendDao)this.baseMapper).selectByNodeIdAndFlowId(nodeId, flowId);
        if (nodeExtend == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)nodeExtend));
    }

    @Override
    public Optional<ProcessNodeExtendEntity> findByNodeIdAndProcessId(long processId, String nodeId) {
        if (Strings.isNullOrEmpty((String)nodeId)) {
            return Optional.absent();
        }
        ProcessNodeExtendEntity nodeExtend = ((ProcessNodeExtendDao)this.baseMapper).selectByProcessAndNodeId(processId, nodeId);
        if (nodeExtend == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)nodeExtend));
    }

    @Override
    public String findTaskNodeIdByProcessAndLinkType(long processId, NodeLinkType linkType) {
        ProcessNodeExtendEntity nodeExtends = ((ProcessNodeExtendDao)this.baseMapper).selectByProcessAndLinkType(processId, linkType.name());
        if (null == nodeExtends) {
            return "";
        }
        String nodeId = nodeExtends.getNodeId();
        if (Strings.isNullOrEmpty((String)nodeId)) {
            return "";
        }
        return nodeId;
    }
}

