/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.ProcessNodeFormFieldDao;
import com.jingtong.bpm.infra.entity.ProcessNodeFormFieldEntity;
import com.jingtong.bpm.infra.po.FormPermissionPO;
import com.jingtong.bpm.infra.service.ProcessNodeFormFieldService;
import com.jingtong.data.exception.RbException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ProcessNodeFormFieldServiceImpl
extends BaseServiceImpl<ProcessNodeFormFieldDao, ProcessNodeFormFieldEntity>
implements ProcessNodeFormFieldService {
    @Override
    public void saveOrUpdate(List<ProcessNodeFormFieldEntity> nodeFormFields, long processId) {
        boolean insertState;
        this.remove((Wrapper)Wrappers.lambdaQuery(ProcessNodeFormFieldEntity.class).eq(ProcessNodeFormFieldEntity::getProcessId, (Object)processId));
        if (CollectionUtil.isNotEmpty(nodeFormFields) && !(insertState = this.saveBatch(nodeFormFields))) {
            throw new RbException("process node formfield save has error!");
        }
    }

    @Override
    public List<FormPermissionPO> nodeFieldPermission(long processId, String nodeId) {
        LambdaQueryWrapper queryWrapper;
        List nodeFormFields;
        if (!Strings.isNullOrEmpty((String)nodeId) && CollectionUtil.isNotEmpty((Collection)(nodeFormFields = this.list((Wrapper)(queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProcessNodeFormFieldEntity.class).eq(ProcessNodeFormFieldEntity::getProcessId, (Object)processId)).eq(ProcessNodeFormFieldEntity::getNodeId, (Object)nodeId)))))) {
            ArrayList permissionVOS = Lists.newArrayList();
            for (ProcessNodeFormFieldEntity nodeFormField : nodeFormFields) {
                FormPermissionPO permissionVO = new FormPermissionPO();
                permissionVO.setHidden(nodeFormField.getVisibleFlag() != 1);
                permissionVO.setEdit(nodeFormField.getEditFlag() == 1);
                permissionVO.setWidgetName(nodeFormField.getFormWidgetName());
                permissionVOS.add(permissionVO);
            }
            return permissionVOS;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessNodeFormFieldEntity> selectByProcessIdAndNodeId(long processId, String nodeId) {
        if (processId <= 0L || Strings.isNullOrEmpty((String)nodeId)) {
            return Collections.emptyList();
        }
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProcessNodeFormFieldEntity.class).eq(ProcessNodeFormFieldEntity::getProcessId, (Object)processId)).eq(ProcessNodeFormFieldEntity::getNodeId, (Object)nodeId));
    }
}

