/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.infra.service.impl;

import com.google.common.base.Strings;
import com.jingtong.bpm.infra.service.SerialNumberLogic;
import com.jingtong.util.datetime.DateTimeUtil;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SerialNumberLogicImpl
implements SerialNumberLogic {
    private static final Logger log = LoggerFactory.getLogger(SerialNumberLogicImpl.class);
    private final RedisTemplate<String, String> redisTemplate;

    @Override
    public String serialNumber(String redisCacheKey, int digits) {
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)redisCacheKey);
        if (Strings.isNullOrEmpty((String)((String)operations.get()))) {
            operations.set((Object)"0");
        }
        Long increment = this.redisTemplate.opsForValue().increment((Object)redisCacheKey, 1L);
        String digitsFormat = "%0" + digits + "d";
        String serialNumber = String.format(digitsFormat, increment);
        if (StringUtils.length((CharSequence)serialNumber) > digits) {
            operations.set((Object)"0");
            increment = this.redisTemplate.opsForValue().increment((Object)redisCacheKey, 1L);
            return String.format(digitsFormat, increment);
        }
        return serialNumber;
    }

    @Override
    public String dayPolling(String redisCacheKey, int digits) {
        return DateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmssSSS");
    }

    public SerialNumberLogicImpl(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

