/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.aviator;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImplicationFunction
extends AbstractFunction {
    public static final String NAME = "implication";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplicationFunction.class);

    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object first = arg1.getValue(env);
        if (first == null) {
            throw new NullPointerException("null seq");
        }
        Object sencond = arg2.getValue(env);
        if (sencond == null) {
            return AviatorBoolean.FALSE;
        }
        Class<?> clazz = first.getClass();
        Class<?> implicationClass = sencond.getClass();
        boolean contains = false;
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection seq = (Collection)first;
            if (Collection.class.isAssignableFrom(implicationClass)) {
                Collection listSencond = (Collection)sencond;
                contains = CollectionUtil.containsAny((Collection)seq, (Collection)listSencond);
            } else {
                if (implicationClass.isArray()) {
                    throw new IllegalArgumentException(arg2.desc(env) + " is not a toa collection");
                }
                try {
                    String name = ((AviatorJavaType)arg1).getName();
                    if (name.startsWith("fd_")) {
                        String value = sencond.toString();
                        List split = StrUtil.split((CharSequence)value, (char)',');
                        JSONArray a = (JSONArray)first;
                        split.retainAll((Collection<?>)a);
                        if (CollectionUtil.isNotEmpty((Collection)split)) {
                            contains = true;
                        }
                        contains = false;
                    }
                    for (Object obj : seq) {
                        if (new AviatorRuntimeJavaType(obj).compare(arg2, env) != 0) continue;
                        contains = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("implication funcation has error!", (Throwable)e);
                    return AviatorBoolean.FALSE;
                }
            }
        } else {
            throw new IllegalArgumentException(arg1.desc(env) + " is not a toa collection");
        }
        return AviatorBoolean.valueOf((boolean)contains);
    }

    public String getName() {
        return NAME;
    }

    @PostConstruct
    public void addFunction() {
        AviatorEvaluator.addFunction((AviatorFunction)new ImplicationFunction());
    }
}

