/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.context;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jingtong.bpm.logic.dto.OrganizationBpmnDTO;
import com.jingtong.bpm.logic.dto.PositionBpmnDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BpmnBillContext
implements Serializable {
    private static final long serialVersionUID = -988633119855312577L;
    private String id;
    private String code;
    private String name;
    private OrganizationBpmnDTO org;
    private List<PositionBpmnDTO> positions;
    private List<String> projectTypes;
    private List<String> customerTypes;

    public Map<String, Object> toEnvParam(String express) {
        HashMap env = Maps.newHashMap();
        if (StringUtils.contains((CharSequence)express, (CharSequence)"ae_position")) {
            ArrayList empPositions = Lists.newArrayList();
            List<PositionBpmnDTO> positions = this.getPositions();
            if (CollectionUtil.isNotEmpty(positions)) {
                for (PositionBpmnDTO position : positions) {
                    empPositions.add(String.valueOf(position.getId()));
                }
            }
            env.put("ae_position", empPositions);
        }
        if (StringUtils.contains((CharSequence)express, (CharSequence)"ae_org")) {
            OrganizationBpmnDTO employeeOrg = this.getOrg();
            String orgId = "";
            if (employeeOrg != null) {
                orgId = employeeOrg.getCode();
            }
            env.put("ae_org", orgId);
        }
        if (StringUtils.contains((CharSequence)express, (CharSequence)"var_porjcet_type") && CollectionUtil.isNotEmpty(this.projectTypes)) {
            env.put("var_porjcet_type", this.projectTypes.get(0));
        }
        return env;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public OrganizationBpmnDTO getOrg() {
        return this.org;
    }

    public List<PositionBpmnDTO> getPositions() {
        return this.positions;
    }

    public List<String> getProjectTypes() {
        return this.projectTypes;
    }

    public List<String> getCustomerTypes() {
        return this.customerTypes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrg(OrganizationBpmnDTO org) {
        this.org = org;
    }

    public void setPositions(List<PositionBpmnDTO> positions) {
        this.positions = positions;
    }

    public void setProjectTypes(List<String> projectTypes) {
        this.projectTypes = projectTypes;
    }

    public void setCustomerTypes(List<String> customerTypes) {
        this.customerTypes = customerTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BpmnBillContext)) {
            return false;
        }
        BpmnBillContext other = (BpmnBillContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        OrganizationBpmnDTO this$org = this.getOrg();
        OrganizationBpmnDTO other$org = other.getOrg();
        if (this$org == null ? other$org != null : !((Object)this$org).equals(other$org)) {
            return false;
        }
        List<PositionBpmnDTO> this$positions = this.getPositions();
        List<PositionBpmnDTO> other$positions = other.getPositions();
        if (this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions)) {
            return false;
        }
        List<String> this$projectTypes = this.getProjectTypes();
        List<String> other$projectTypes = other.getProjectTypes();
        if (this$projectTypes == null ? other$projectTypes != null : !((Object)this$projectTypes).equals(other$projectTypes)) {
            return false;
        }
        List<String> this$customerTypes = this.getCustomerTypes();
        List<String> other$customerTypes = other.getCustomerTypes();
        return !(this$customerTypes == null ? other$customerTypes != null : !((Object)this$customerTypes).equals(other$customerTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BpmnBillContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        OrganizationBpmnDTO $org = this.getOrg();
        result = result * 59 + ($org == null ? 43 : ((Object)$org).hashCode());
        List<PositionBpmnDTO> $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 43 : ((Object)$positions).hashCode());
        List<String> $projectTypes = this.getProjectTypes();
        result = result * 59 + ($projectTypes == null ? 43 : ((Object)$projectTypes).hashCode());
        List<String> $customerTypes = this.getCustomerTypes();
        result = result * 59 + ($customerTypes == null ? 43 : ((Object)$customerTypes).hashCode());
        return result;
    }

    public String toString() {
        return "BpmnBillContext(id=" + this.getId() + ", code=" + this.getCode() + ", name=" + this.getName() + ", org=" + this.getOrg() + ", positions=" + this.getPositions() + ", projectTypes=" + this.getProjectTypes() + ", customerTypes=" + this.getCustomerTypes() + ")";
    }
}

