/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.define.widget;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jingtong.bpm.infra.entity.FormFieldEntity;
import com.jingtong.bpm.logic.define.FormXtype;
import com.jingtong.bpm.logic.define.widget.WidgetField;
import com.jingtong.bpm.logic.dto.FormTableFieldDto;

public abstract class AbstractWidget
implements WidgetField {
    protected String widgetName;
    protected String title;
    protected String placeholder;
    protected String desc;
    protected boolean required;
    protected boolean visible;
    protected boolean readonly;
    private FormXtype xtype;

    public String getWidgetName() {
        return this.widgetName;
    }

    public void setWidgetName(String widgetName) {
        this.widgetName = widgetName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public FormXtype getXtype() {
        return this.xtype;
    }

    public void setXtype(FormXtype xtype) {
        this.xtype = xtype;
    }

    @Override
    public FormFieldEntity toField(long formId, int sort, long detailFiledId) {
        FormFieldEntity formField = new FormFieldEntity();
        formField.setTitle(this.getTitle());
        formField.setFormId(formId);
        formField.setWidgetName(this.getWidgetName());
        formField.setType(this.xtype.toString());
        formField.setDescription(this.getDesc());
        formField.setPlaceholder(this.getPlaceholder());
        formField.setRequired(this.isRequired() ? 1 : 0);
        formField.setSort(sort);
        formField.setFieldId(detailFiledId);
        formField.setProps(JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.DisableCircularReferenceDetect}));
        return formField;
    }

    @Override
    public String title() {
        return this.getTitle();
    }

    FormTableFieldDto createVarcharField() {
        FormTableFieldDto formTableField = new FormTableFieldDto();
        formTableField.setComment(this.title);
        formTableField.setFieldName(this.widgetName);
        formTableField.setDataType("varchar(255)");
        return formTableField;
    }

    FormTableFieldDto createTextExtField() {
        FormTableFieldDto formTableField = new FormTableFieldDto();
        formTableField.setComment(this.title + "--\u6269\u5c55");
        formTableField.setFieldName(this.widgetName + "_ext");
        formTableField.setDataType("text");
        return formTableField;
    }
}

