/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.dto;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jingtong.bpm.logic.dto.ColumnDTO;
import com.jingtong.bpm.logic.dto.OrderDTO;
import com.jingtong.bpm.logic.dto.SearchDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class DataTablesInputDTO {
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) Integer draw = 1;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) Integer start = 0;
    @NotNull
    @Min(value=-1L)
    private @NotNull @Min(value=-1L) Integer length = 10;
    @NotNull
    private SearchDTO search = new SearchDTO();
    @NotEmpty
    private List<OrderDTO> order = Lists.newArrayList();
    @NotEmpty
    private List<ColumnDTO> columns = Lists.newArrayList();
    private JSONObject params;

    public Map<String, ColumnDTO> getColumnsAsMap() {
        HashMap map = Maps.newHashMap();
        for (ColumnDTO column : this.columns) {
            map.put(column.getData(), column);
        }
        return map;
    }

    public ColumnDTO getColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        for (ColumnDTO column : this.columns) {
            if (!columnName.equals(column.getData())) continue;
            return column;
        }
        return null;
    }

    public void addColumn(String columnName, boolean searchable, boolean orderable, String searchValue) {
        this.columns.add(new ColumnDTO(columnName, "", searchable, orderable, new SearchDTO(searchValue, false)));
    }

    public void addOrder(String columnName, boolean ascending) {
        if (columnName == null) {
            return;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!columnName.equals(this.columns.get(i).getData())) continue;
            this.order.add(new OrderDTO(i, ascending ? "asc" : "desc"));
        }
    }

    public boolean hasParasm() {
        return this.params != null && !this.params.isEmpty();
    }

    public Integer getDraw() {
        return this.draw;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLength() {
        return this.length;
    }

    public SearchDTO getSearch() {
        return this.search;
    }

    public List<OrderDTO> getOrder() {
        return this.order;
    }

    public List<ColumnDTO> getColumns() {
        return this.columns;
    }

    public JSONObject getParams() {
        return this.params;
    }

    public void setDraw(Integer draw) {
        this.draw = draw;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setSearch(SearchDTO search) {
        this.search = search;
    }

    public void setOrder(List<OrderDTO> order) {
        this.order = order;
    }

    public void setColumns(List<ColumnDTO> columns) {
        this.columns = columns;
    }

    public void setParams(JSONObject params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTablesInputDTO)) {
            return false;
        }
        DataTablesInputDTO other = (DataTablesInputDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$draw = this.getDraw();
        Integer other$draw = other.getDraw();
        if (this$draw == null ? other$draw != null : !((Object)this$draw).equals(other$draw)) {
            return false;
        }
        Integer this$start = this.getStart();
        Integer other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        SearchDTO this$search = this.getSearch();
        SearchDTO other$search = other.getSearch();
        if (this$search == null ? other$search != null : !((Object)this$search).equals(other$search)) {
            return false;
        }
        List<OrderDTO> this$order = this.getOrder();
        List<OrderDTO> other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        List<ColumnDTO> this$columns = this.getColumns();
        List<ColumnDTO> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        JSONObject this$params = this.getParams();
        JSONObject other$params = other.getParams();
        return !(this$params == null ? other$params != null : !this$params.equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTablesInputDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $draw = this.getDraw();
        result = result * 59 + ($draw == null ? 43 : ((Object)$draw).hashCode());
        Integer $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        SearchDTO $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
        List<OrderDTO> $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        List<ColumnDTO> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        JSONObject $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        return result;
    }

    public String toString() {
        return "DataTablesInputDTO(draw=" + this.getDraw() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", search=" + this.getSearch() + ", order=" + this.getOrder() + ", columns=" + this.getColumns() + ", params=" + this.getParams() + ")";
    }
}

