/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.event;

import com.google.common.base.MoreObjects;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.service.ToaBillService;
import com.jingtong.bpm.logic.constant.BillStatus;
import com.jingtong.bpm.logic.event.BillAgreeEvent;
import com.jingtong.bpm.logic.event.BillRefuseEvent;
import com.jingtong.bpm.logic.event.BillRepulseEvent;
import com.jingtong.bpm.logic.service.CallBackLogic;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BillEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BillEventListener.class);
    private final ToaBillService billService;
    private final CallBackLogic callBackLogic;
    private final EventBus eventBus;

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public void accept(BillRefuseEvent refuseEvent) {
        LOGGER.info("bill refuse event has accept! the event data is {}", (Object)refuseEvent);
        ToaBillEntity bill = new ToaBillEntity();
        bill.setId(refuseEvent.getBillId());
        bill.setStatus(BillStatus.REFUSE.getStatus());
        bill.setUpdateTime(LocalDateTime.now());
        this.billService.updateById((Object)bill);
        this.callBackLogic.callBack(refuseEvent.getProcessId(), refuseEvent.getBillId(), BillStatus.REFUSE.getStatus());
    }

    @Subscribe
    public void accept(BillRepulseEvent refuseEvent) {
        LOGGER.info("bill refuse event has accept! the event data is {}", (Object)refuseEvent);
        this.callBackLogic.callBack(refuseEvent.getProcessId(), refuseEvent.getBillId(), BillStatus.REPULSE.getStatus());
    }

    @Subscribe
    public void accept(BillAgreeEvent agreeEvent) {
        LOGGER.info("bill agree event has accept! the event data is {}", (Object)agreeEvent);
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(agreeEvent.getBillId())));
        int status = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)0);
        BillStatus billStatus = BillStatus.valueTo(status);
        if (billStatus.equals((Object)BillStatus.REFUSE)) {
            bill.setId(agreeEvent.getBillId());
            bill.setStatus(BillStatus.APPROVAL.getStatus());
            bill.setUpdateTime(LocalDateTime.now());
            this.billService.updateById((Object)bill);
        }
    }

    public BillEventListener(ToaBillService billService, CallBackLogic callBackLogic, EventBus eventBus) {
        this.billService = billService;
        this.callBackLogic = callBackLogic;
        this.eventBus = eventBus;
    }
}

