/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.listener;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.jingtong.bpm.logic.service.BillTaskLogic;
import com.jingtong.config.SpringContextHolder;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssigneeTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(AssigneeTaskListener.class);
    private static final long serialVersionUID = 1432405797963462666L;

    public void notify(DelegateTask delegateTask) {
        log.debug("\u8fdb\u5165\u4e86AssigneeTask");
        DelegateExecution execution = delegateTask.getExecution();
        String nodeId = execution.getCurrentActivityId();
        String businessKey = execution.getProcessInstanceBusinessKey();
        if (log.isDebugEnabled()) {
            log.debug("the assignee task node is {} and billId is {}", (Object)nodeId, (Object)businessKey);
        }
        if (Strings.isNullOrEmpty((String)businessKey) || Strings.isNullOrEmpty((String)nodeId)) {
            log.warn("The billId {} and  task is {} has not found businessKey and nodeId", (Object)businessKey, (Object)delegateTask.getId());
            return;
        }
        long billId = (Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)businessKey), (Object)0L);
        if (billId <= 0L) {
            log.warn("the node {} bill is null!!! businessKey is {}", (Object)nodeId, (Object)businessKey);
            return;
        }
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        if (Strings.isNullOrEmpty((String)processDefinitionId)) {
            log.warn("the node {} and billId {} processDefinitionId is null!!!", (Object)nodeId, (Object)businessKey);
            return;
        }
        BillTaskLogic approverService = SpringContextHolder.getBean(BillTaskLogic.class);
        String assignee = delegateTask.getAssignee();
        approverService.saveBillApprover(Sets.newHashSet((Object[])new String[]{assignee}), billId, delegateTask);
    }
}

