/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.listener;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import com.jingtong.bpm.logic.service.BillCcPersonLogic;
import com.jingtong.bpm.logic.service.NodeCcLogic;
import com.jingtong.config.SpringContextHolder;
import java.util.Collections;
import java.util.Set;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplateTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(ComplateTaskListener.class);
    private static final long serialVersionUID = 5102408796560913909L;

    public void notify(DelegateTask delegateTask) {
        log.info("\u6700\u65b0\u7684\u6d88\u606f:{}", (Object)delegateTask);
        DelegateExecution execution = delegateTask.getExecution();
        String nodeId = execution.getCurrentActivityId();
        log.info("the create task node is {}", (Object)nodeId);
        String businessKey = execution.getProcessInstanceBusinessKey();
        String taskId = delegateTask.getId();
        if (Strings.isNullOrEmpty((String)businessKey) || Strings.isNullOrEmpty((String)nodeId)) {
            log.warn("The billId {} and  task is {} has not found businessKey and nodeId", (Object)businessKey, (Object)taskId);
            return;
        }
        long billId = (Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)businessKey), (Object)0L);
        if (billId <= 0L) {
            log.warn("the node {} bill is null!!! businessKey is {}", (Object)nodeId, (Object)businessKey);
            return;
        }
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        if (Strings.isNullOrEmpty((String)processDefinitionId)) {
            log.warn("the node {} and billId {} processDefinitionId is null!!!", (Object)nodeId, (Object)businessKey);
            return;
        }
        String processFlowId = StrUtil.split((CharSequence)processDefinitionId, (CharSequence)":")[0];
        NodeCcLogic nodeCcService = SpringContextHolder.getBean(NodeCcLogic.class);
        delegateTask.getVariable("var_bill_context");
        Set<String> ccUsers = nodeCcService.resolve(processFlowId, nodeId, delegateTask, Collections.emptyList());
        if (CollectionUtil.isNotEmpty(ccUsers)) {
            BillCcPersonLogic billCcPersonService = SpringContextHolder.getBean(BillCcPersonLogic.class);
            billCcPersonService.saveBillCc(ccUsers, billId, nodeId, processFlowId);
        }
    }
}

