/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.listener;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.logic.service.BillTaskLogic;
import com.jingtong.bpm.logic.service.NodeApproverLogic;
import com.jingtong.config.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTaskListener.class);
    private static final long serialVersionUID = 1432405797963462666L;

    public void notify(DelegateTask delegateTask) {
        log.debug("\u8fdb\u5165\u4e86CreateTaskListener");
        DelegateExecution execution = delegateTask.getExecution();
        String nodeId = execution.getCurrentActivityId();
        log.info("the create task node is {}", (Object)nodeId);
        String businessKey = execution.getProcessInstanceBusinessKey();
        String taskId = delegateTask.getId();
        if (Strings.isNullOrEmpty((String)businessKey) || Strings.isNullOrEmpty((String)nodeId)) {
            log.warn("The billId {} and  task is {} has not found businessKey and nodeId", (Object)businessKey, (Object)taskId);
            return;
        }
        long billId = (Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)businessKey), (Object)0L);
        if (billId <= 0L) {
            log.warn("the node {} bill is null!!! businessKey is {}", (Object)nodeId, (Object)businessKey);
            return;
        }
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        if (Strings.isNullOrEmpty((String)processDefinitionId)) {
            log.warn("the node {} and billId {} processDefinitionId is null!!!", (Object)nodeId, (Object)businessKey);
            return;
        }
        String processFlowId = StrUtil.split((CharSequence)processDefinitionId, (CharSequence)":")[0];
        NodeApproverLogic nodeApproverService = SpringContextHolder.getBean(NodeApproverLogic.class);
        Map<Long, Set<String>> approverSettings = nodeApproverService.resolve(processFlowId, nodeId, delegateTask);
        Set approvers = Sets.newConcurrentHashSet();
        for (Set<String> value : approverSettings.values()) {
            approvers.addAll(value);
        }
        if (CollectionUtil.isNotEmpty((Collection)approvers)) {
            delegateTask.addCandidateUsers((Collection)approvers);
        } else {
            log.info("the task {} current node is {} , not found approver!!!", (Object)taskId, (Object)delegateTask.getName());
        }
        BillTaskLogic approverService = SpringContextHolder.getBean(BillTaskLogic.class);
        List<BillTaskEntity> billTaskEntities = approverService.saveBillApprover(approverSettings, billId, delegateTask);
        Set approvingUsers = billTaskEntities.stream().map(BillTaskEntity::getUserCode).collect(Collectors.toSet());
        ArrayList employeeIds = Lists.newArrayList();
        employeeIds.addAll(approvingUsers);
    }
}

