/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.listener;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.config.SpringContextHolder;
import java.util.Objects;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBillListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessBillListener.class);
    private static final long serialVersionUID = 1720995327038825119L;

    public void notify(DelegateExecution execution) {
        log.debug("\u8fdb\u5165\u4e86ProcessBillListener");
        String eventName = execution.getEventName();
        if (StringUtils.equals((CharSequence)eventName, (CharSequence)"end")) {
            long billId;
            Object varAction = ((ExecutionEntityImpl)execution).getProcessInstance().getVariable("var_action");
            String action = Objects.isNull(varAction) ? "" : (String)varAction;
            String businessKey = execution.getProcessInstanceBusinessKey();
            if (StringUtils.isNotEmpty((CharSequence)businessKey) && (billId = ((Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)businessKey), (Object)0L)).longValue()) > 0L) {
                BillLogic billService = SpringContextHolder.getBean(BillLogic.class);
                billService.complete(billId, action);
            }
        }
    }
}

