/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.query.list;

import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.google.common.base.Strings;
import com.jingtong.util.datetime.DateTimeUtil;
import java.io.Serializable;
import java.time.LocalDate;

public class DraftBillQuery
implements Serializable {
    public static final String RANGE_TIME_DASH = " - ";
    private static final long serialVersionUID = -822556348605273588L;
    private String rangeTime;
    private long processId;
    private String code;
    private String title;
    private String text;
    private Integer status;

    public long getUnixStartTime() {
        if (Strings.isNullOrEmpty((String)this.rangeTime)) {
            return 0L;
        }
        String[] timeSplit = this.rangeTime.split(RANGE_TIME_DASH);
        LocalDate startDay = DateTimeUtil.str2Date((String)timeSplit[0]);
        return DateTimeUtil.timeMillsOfStartDate((LocalDate)startDay) / 1000L;
    }

    public long getUnixEndTime() {
        if (Strings.isNullOrEmpty((String)this.rangeTime)) {
            return 0L;
        }
        String[] timeSplit = this.rangeTime.split(RANGE_TIME_DASH);
        LocalDate endTime = DateTimeUtil.str2Date((String)timeSplit[1]);
        return DateTimeUtil.timeMillsOfEndDate((LocalDate)endTime) / 1000L + 86399L;
    }

    public String getCodeLike() {
        if (Strings.isNullOrEmpty((String)this.code)) {
            return "";
        }
        return SqlUtils.concatLike((Object)this.code, (SqlLike)SqlLike.RIGHT);
    }

    public String getTitleLike() {
        if (Strings.isNullOrEmpty((String)this.title)) {
            return "";
        }
        return SqlUtils.concatLike((Object)this.title, (SqlLike)SqlLike.RIGHT);
    }

    public String getTextLike() {
        if (Strings.isNullOrEmpty((String)this.text)) {
            return "";
        }
        return SqlUtils.concatLike((Object)this.text, (SqlLike)SqlLike.DEFAULT);
    }

    public String getRangeTime() {
        return this.rangeTime;
    }

    public long getProcessId() {
        return this.processId;
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setRangeTime(String rangeTime) {
        this.rangeTime = rangeTime;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DraftBillQuery)) {
            return false;
        }
        DraftBillQuery other = (DraftBillQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessId() != other.getProcessId()) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$rangeTime = this.getRangeTime();
        String other$rangeTime = other.getRangeTime();
        if (this$rangeTime == null ? other$rangeTime != null : !this$rangeTime.equals(other$rangeTime)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DraftBillQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $processId = this.getProcessId();
        result = result * 59 + (int)($processId >>> 32 ^ $processId);
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $rangeTime = this.getRangeTime();
        result = result * 59 + ($rangeTime == null ? 43 : $rangeTime.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "DraftBillQuery(rangeTime=" + this.getRangeTime() + ", processId=" + this.getProcessId() + ", code=" + this.getCode() + ", title=" + this.getTitle() + ", text=" + this.getText() + ", status=" + this.getStatus() + ")";
    }
}

