/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import com.googlecode.aviator.AviatorEvaluator;
import com.jingtong.bpm.infra.entity.ProcessNodeConnectionEntity;
import com.jingtong.bpm.infra.service.ProcessNodeConnectionService;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.FastJsonType;
import com.jingtong.bpm.logic.context.BpmnBillContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.activiti.engine.delegate.DelegateExecution;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="lineExpr")
public class LineExpressService {
    private static final Logger log = LoggerFactory.getLogger(LineExpressService.class);
    static final String LINE_EXPRESS = "lineExpr";
    private final ProcessNodeConnectionService nodeConnectionService;

    public boolean invoke(DelegateExecution execution, String processId, String nodeId, String proposer, String approver, Map<String, Object> formDataMap, String action) {
        if (Strings.isNullOrEmpty((String)processId)) {
            log.warn("the node condition express processId is null! please check!");
            return false;
        }
        if (Strings.isNullOrEmpty((String)nodeId)) {
            log.warn("the node condition express nodeId is null! please check!");
            return false;
        }
        long lProcessId = (Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)processId), (Object)0L);
        if (lProcessId <= 0L) {
            log.warn("the node condition express processId is zero! please check!");
            return false;
        }
        if (!StringUtils.equals((CharSequence)action, (CharSequence)BillAction.agree.name()) && !StringUtils.equals((CharSequence)action, (CharSequence)BillAction.submit.name())) {
            log.warn("The node action is not agree, return false;");
            return false;
        }
        long flowProcessId = (Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)processId), (Object)0L);
        ProcessNodeConnectionEntity connection = (ProcessNodeConnectionEntity)((Object)this.nodeConnectionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProcessNodeConnectionEntity.class).eq(ProcessNodeConnectionEntity::getProcessId, (Object)flowProcessId)).eq(ProcessNodeConnectionEntity::getNodeId, (Object)nodeId)));
        if (!Objects.isNull((Object)connection)) {
            String express = connection.getExpress();
            if (Strings.isNullOrEmpty((String)express)) {
                return true;
            }
            String expressParams = connection.getExpressParams();
            if (log.isDebugEnabled()) {
                log.debug("The line node express is \n **** {} \n param is \n *** {} ", (Object)express, (Object)expressParams);
            }
            BpmnBillContext billContext = (BpmnBillContext)JSON.parseObject((String)proposer, BpmnBillContext.class);
            HashMap env = Maps.newHashMap();
            for (String key : formDataMap.keySet()) {
                if (Objects.isNull(formDataMap.get(key)) || !NumberUtil.isNumber((CharSequence)formDataMap.get(key).toString())) continue;
                formDataMap.put(key, Float.valueOf(NumberUtil.toBigDecimal((String)formDataMap.get(key).toString()).floatValue()));
            }
            if (StringUtils.contains((CharSequence)express, (CharSequence)"var_formData")) {
                env.put("var_formData", formDataMap);
            }
            env.putAll(billContext.toEnvParam(express));
            if (!Strings.isNullOrEmpty((String)expressParams)) {
                Map paramMap = (Map)JSON.parseObject((String)expressParams, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
                env.putAll(paramMap);
            }
            env.put("var_apply_employee", String.valueOf(billContext.getId()));
            boolean pass = BooleanUtils.toBoolean((Boolean)((Boolean)AviatorEvaluator.execute((String)express, (Map)env)));
            if (log.isDebugEnabled()) {
                log.debug("line express resolve param is \n ------ processId: {} \n ------ nodeId: {}\n ------ proposer: {}\n ------ approver: {}\n ------ action: {}\n ------ formData: {}", new Object[]{processId, nodeId, proposer, approver, action, JSON.toJSONString(formDataMap)});
                log.debug("The line node {} [{}] parse result is {} \n --- the express is {} \n --- the express params is {} ", new Object[]{nodeId, "", pass ? "pass" : "no pass", express, expressParams});
            }
            return pass;
        }
        if (log.isDebugEnabled()) {
            log.debug("line express resolve param is \n ------ processId: {} \n ------ nodeId: {}\n ------ proposer: {}\n ------ approver: {}\n ------ action: {}\n ------ formData: {}", new Object[]{processId, nodeId, proposer, approver, action, JSON.toJSONString(formDataMap)});
        }
        return true;
    }

    public LineExpressService(ProcessNodeConnectionService nodeConnectionService) {
        this.nodeConnectionService = nodeConnectionService;
    }
}

