/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeFormFieldEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.po.FormFieldPO;
import com.jingtong.bpm.infra.po.ProcessDetailPO;
import com.jingtong.bpm.infra.service.BillReadRecordService;
import com.jingtong.bpm.infra.service.BillTaskService;
import com.jingtong.bpm.infra.service.FormFieldService;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.infra.service.ProcessNodeFormFieldService;
import com.jingtong.bpm.infra.service.ToaBillService;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.BillStatus;
import com.jingtong.bpm.logic.constant.BillTaskStatus;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.context.BillDataContext;
import com.jingtong.bpm.logic.context.BpmnBillContext;
import com.jingtong.bpm.logic.define.FormXtype;
import com.jingtong.bpm.logic.dto.OrganizationBpmnDTO;
import com.jingtong.bpm.logic.dto.PositionBpmnDTO;
import com.jingtong.bpm.logic.dto.UserInfoDTO;
import com.jingtong.bpm.logic.dto.UserOrgDTO;
import com.jingtong.bpm.logic.dto.UserPositionDTO;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.BillBpmnLogic;
import com.jingtong.bpm.logic.service.BillItemLogic;
import com.jingtong.bpm.logic.service.CallBackLogic;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.bpm.logic.vo.FormPermissionVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.ErrorCode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillBpmnLogicImpl
implements BillBpmnLogic {
    private static final Logger log = LoggerFactory.getLogger(BillBpmnLogicImpl.class);
    private final RepositoryService repositoryService;
    private final RuntimeService runtimeService;
    private final TaskService taskService;
    private final IdentityService identityService;
    private final ProcessNodeExtendService nodeExtendService;
    private final ProcessNodeFormFieldService nodeFormFieldService;
    private final BillItemLogic billItemLogic;
    private final FormFieldService formFieldService;
    private final BillTaskService billTaskService;
    private final ToaBillService billService;
    private final BillReadRecordService billReadRecordService;
    private final UserCenterlogic userCenterlogic;
    private final CallBackLogic callBackLogic;
    private final HistoryService historyService;

    @Override
    public List<FormPermissionVO> findPermissionByProcessStartNode(long processId) {
        String firstNodeId = this.nodeExtendService.findTaskNodeIdByProcessAndLinkType(processId, NodeLinkType.create);
        return this.nodeFieldPermission(processId, firstNodeId);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<FormPermissionVO> nodeFieldPermission(long processId, String nodeId) {
        List<ProcessNodeFormFieldEntity> nodeFormFields;
        if (!Strings.isNullOrEmpty((String)nodeId) && CollectionUtil.isNotEmpty(nodeFormFields = this.nodeFormFieldService.selectByProcessIdAndNodeId(processId, nodeId))) {
            ArrayList permissionVOS = Lists.newArrayList();
            for (ProcessNodeFormFieldEntity nodeFormField : nodeFormFields) {
                FormPermissionVO permissionVO = new FormPermissionVO();
                permissionVO.setHidden(nodeFormField.getVisibleFlag() != 1);
                permissionVO.setEdit(nodeFormField.getEditFlag() == 1);
                permissionVO.setWidgetName(nodeFormField.getFormWidgetName());
                permissionVOS.add(permissionVO);
            }
            return permissionVOS;
        }
        return Collections.emptyList();
    }

    @Override
    public List<FormPermissionVO> findPermissionByBill(ToaBillEntity bill, String userCode) {
        if (bill == null) {
            log.error("the bill is null!");
            return Collections.emptyList();
        }
        long processId = (Long)MoreObjects.firstNonNull((Object)bill.getProcessId(), (Object)0L);
        BillStatus billStatus = BillStatus.valueTo(bill.getStatus());
        if (billStatus == BillStatus.DRAFTS) {
            if (!bill.getSender().equals(userCode)) {
                return Collections.emptyList();
            }
            return this.findPermissionByProcessStartNode(processId);
        }
        return this.findPermissionByProcessStartNode(processId);
    }

    @Override
    public Optional<ProcessInstance> startFlow(BillDataContext billDataValue, ProcessDetailPO processDetail, UserInfoDTO userInfoDTO, String nextApprover) {
        String processKey = processDetail.getFlowId();
        ProcessDefinition processDefinition = this.findLastVersionByFlowId(processKey);
        if (processDefinition == null) {
            throw new RbException("\u4e1a\u52a1\u6d41\u7a0b\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (ErrorCode)BillCode.PROCESS_NOT_FOUND);
        }
        long billId = billDataValue.getId();
        String businessKey = String.valueOf(billId);
        String authenticatedUserId = userInfoDTO.getCode();
        Map<String, Object> formDataParam = this.parseFormValues(billDataValue, authenticatedUserId, processDetail);
        BpmnBillContext bpmnBillContext = this.createBpmnContext(userInfoDTO, billDataValue);
        String varDataContext = JSON.toJSONString((Object)bpmnBillContext);
        HashMap variables = Maps.newHashMap();
        variables.put("var_formData", formDataParam);
        variables.put("var_bill_context", varDataContext);
        variables.put("var_apply_process", processDetail.getId());
        variables.put("var_apply_employee", authenticatedUserId);
        variables.put("var_approver_employee", authenticatedUserId);
        variables.put("var_action", BillAction.submit.name());
        variables.put("var_next_approver", nextApprover);
        variables.put("var_agree_data", Maps.newHashMap());
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).active();
        List processInstances = query.list();
        if (CollectionUtil.isNotEmpty((Collection)processInstances)) {
            for (ProcessInstance processInstance : processInstances) {
                this.runtimeService.setVariables(processInstance.getId(), (Map)variables);
                TaskQuery taskQuery = ((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(authenticatedUserId).processInstanceId(processInstance.getId())).active();
                List todoList = taskQuery.list();
                if (!CollectionUtil.isNotEmpty((Collection)todoList)) continue;
                Task firstNodeTask = (Task)todoList.get(0);
                this.taskService.complete(firstNodeTask.getId(), (Map)variables);
            }
            long processId = processDetail.getId();
            this.billItemLogic.converPhysicalData(authenticatedUserId, processId, billId, formDataParam);
            ProcessInstance processInstance = (ProcessInstance)processInstances.get(0);
            return Optional.of((Object)processInstance);
        }
        String definitionId = processDefinition.getId();
        List<FlowElement> userTaskNodes = this.findFirstTaskNode(definitionId);
        if (CollectionUtil.isNotEmpty(userTaskNodes)) {
            TaskQuery taskQuery;
            List todoList;
            UserTask userTask = (UserTask)userTaskNodes.get(0);
            String userTaskId = userTask.getId();
            boolean firstTaskComplete = false;
            Optional<ProcessNodeExtendEntity> nodeExtendOpt = this.nodeExtendService.findByFlowIdAndNodeId(userTaskId, processKey);
            if (nodeExtendOpt.isPresent()) {
                ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOpt.get());
                String linkType = nodeExtend.getLinkType();
                firstTaskComplete = StringUtils.equals((CharSequence)linkType, (CharSequence)NodeLinkType.create.name());
            }
            this.identityService.setAuthenticatedUserId(authenticatedUserId);
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(definitionId, businessKey, (Map)variables);
            String processInstanceId = processInstance.getId();
            if (firstTaskComplete && CollectionUtil.isNotEmpty((Collection)(todoList = (taskQuery = ((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(authenticatedUserId).processInstanceId(processInstanceId)).active()).list()))) {
                Task firstNodeTask = (Task)todoList.get(0);
                this.taskService.complete(firstNodeTask.getId(), (Map)variables);
            }
            long processId = processDetail.getId();
            this.billItemLogic.converPhysicalData(authenticatedUserId, processId, billId, formDataParam);
            return Optional.of((Object)processInstance);
        }
        return Optional.absent();
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<FlowElement> findFirstTaskNode(String definitionId) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(definitionId);
        if (bpmnModel != null) {
            ArrayList nodes = Lists.newArrayList();
            Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
            if (CollectionUtil.isNotEmpty((Collection)flowElements)) {
                for (FlowElement flowElement : flowElements) {
                    if (!(flowElement instanceof StartEvent)) continue;
                    List outgoingFlows = ((StartEvent)flowElement).getOutgoingFlows();
                    for (SequenceFlow outgoingFlow : outgoingFlows) {
                        FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
                        nodes.add(targetFlowElement);
                    }
                }
            }
            return nodes;
        }
        return Collections.emptyList();
    }

    private BpmnBillContext createBpmnContext(UserInfoDTO userInfoDTO, BillDataContext billDataValue) {
        List<UserPositionDTO> positions;
        BpmnBillContext bpmnBillContext = new BpmnBillContext();
        bpmnBillContext.setId(userInfoDTO.getId());
        bpmnBillContext.setCode(userInfoDTO.getCode());
        bpmnBillContext.setName(userInfoDTO.getNickname());
        List<UserOrgDTO> orgs = userInfoDTO.getOrgs();
        if (CollectionUtil.isNotEmpty(orgs)) {
            UserOrgDTO userOrgDTO = orgs.get(0);
            OrganizationBpmnDTO organizationBpmnDTO = new OrganizationBpmnDTO();
            organizationBpmnDTO.setCode(userOrgDTO.getOrgCode());
            organizationBpmnDTO.setId(userOrgDTO.getOrgId());
            organizationBpmnDTO.setName(userOrgDTO.getOrgName());
            bpmnBillContext.setOrg(organizationBpmnDTO);
        }
        if (CollectionUtil.isNotEmpty(positions = userInfoDTO.getPositions())) {
            ArrayList positionBpmns = Lists.newArrayListWithCapacity((int)positions.size());
            for (UserPositionDTO position : positions) {
                PositionBpmnDTO positionBpmnDTO = new PositionBpmnDTO();
                positionBpmnDTO.setId(position.getPositionId());
                positionBpmnDTO.setCode(position.getPositionCode());
                positionBpmnDTO.setName(position.getPositionName());
                positionBpmns.add(positionBpmnDTO);
            }
            bpmnBillContext.setPositions(positionBpmns);
        }
        if (billDataValue != null) {
            bpmnBillContext.setProjectTypes(billDataValue.getProjectTypes());
        }
        return bpmnBillContext;
    }

    private Map<String, Object> parseFormValues(BillDataContext billDataValue, String authenticatedUserId, ProcessDetailPO processDetail) {
        Map<String, Object> formDataMap = billDataValue.getFormDataMap();
        long processId = processDetail.getId();
        List<FormFieldPO> formFields = this.formFieldService.findVoByProcessId(processId);
        if (CollectionUtil.isEmpty(formFields)) {
            throw new RbException((ErrorCode)BillCode.FORM_FIELD_ERROR);
        }
        HashMap formDataParam = Maps.newHashMapWithExpectedSize((int)formDataMap.size());
        block4: for (FormFieldPO formField : formFields) {
            String widgetName = formField.getWidgetName();
            Object widgetValue = formDataMap.get(widgetName);
            String type = formField.getType();
            FormXtype xtype = FormXtype.valueOf(type);
            switch (xtype) {
                case triggerselect: {
                    Triple<String, String, Set<Object>> triggerValue = this.billItemLogic.getTriggerValue(formField, widgetValue);
                    String dataValue = (String)triggerValue.getLeft();
                    if (Strings.isNullOrEmpty((String)dataValue)) {
                        formDataParam.put(widgetName, "");
                        formDataParam.put(widgetName + "_ext", "");
                        break;
                    }
                    formDataParam.put(widgetName, dataValue);
                    formDataParam.put(widgetName + "_ext", triggerValue.getMiddle());
                    break;
                }
                case detailgroup: {
                    List<FormFieldPO> detailFields = formField.getDetailFields();
                    if (!(widgetValue instanceof JSONArray)) continue block4;
                    HashMap detailFiledTemp = Maps.newHashMap();
                    for (FormFieldPO detailField : detailFields) {
                        detailFiledTemp.put(detailField.getWidgetName(), detailField);
                    }
                    JSONArray detailValues = (JSONArray)widgetValue;
                    ArrayList detailValueMap = Lists.newArrayList();
                    if (!CollectionUtil.isNotEmpty((Collection)detailValues)) continue block4;
                    for (Object detailValue : detailValues) {
                        JSONObject detailObject = (JSONObject)detailValue;
                        Map<String, Object> detailMap = this.getDetailValues(detailFiledTemp, detailObject);
                        detailValueMap.add(detailMap);
                    }
                    formDataParam.put(widgetName, detailValueMap);
                    break;
                }
                default: {
                    Map<String, Object> params = this.billItemLogic.parseFileValue(formField, widgetValue);
                    formDataParam.putAll(params);
                }
            }
        }
        return formDataParam;
    }

    private Map<String, Object> getDetailValues(Map<String, FormFieldPO> detailFiledTemp, JSONObject detailObject) {
        HashMap detailMap = Maps.newHashMap();
        for (String widgetDetailName : detailObject.keySet()) {
            Object widgetDetailvalue = detailObject.get((Object)widgetDetailName);
            FormFieldPO formFieldVO = detailFiledTemp.get(widgetDetailName);
            Map<String, Object> params = this.billItemLogic.parseFileValue(formFieldVO, widgetDetailvalue);
            detailMap.putAll(params);
        }
        return detailMap;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ProcessDefinition findLastVersionByFlowId(String flowId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(flowId).latestVersion().singleResult();
    }

    @Override
    public Optional<BillTaskEntity> findTaskBybillAndEmployeeAndTaskId(long billId, String taskId, String userCode) {
        if (billId <= 0L || Strings.isNullOrEmpty((String)taskId) || Strings.isNullOrEmpty((String)userCode)) {
            return Optional.absent();
        }
        return this.billTaskService.findByBillAndEmployeeAndTaskId(billId, taskId, userCode);
    }

    @Override
    public boolean complete(ToaBillEntity bill, String taskId, String opinion, String userCode, String nextApprover, String formData, String lastTaskNodeId, String lastTaskId) {
        HashMap variables = Maps.newHashMap();
        variables.put("var_opinion", opinion);
        variables.put("var_approver_employee", userCode);
        variables.put("var_action", BillAction.agree.name());
        variables.put("var_next_approver", nextApprover);
        variables.put("var_last_node_key", lastTaskNodeId);
        variables.put("var_last_task_id", lastTaskId);
        variables.put("var_agree_data", JSON.parseObject((String)formData, Map.class));
        this.taskService.complete(taskId, (Map)variables);
        return true;
    }

    @Override
    public boolean refuse(ToaBillEntity bill, String taskId, String opinion, String userCode) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new RbException((ErrorCode)BillCode.TASK_NOT_FOUND);
        }
        HashMap variables = Maps.newHashMap();
        variables.put("var_opinion", opinion);
        variables.put("var_approver_employee", userCode);
        variables.put("var_action", BillAction.refuse.name());
        this.taskService.complete(task.getId(), (Map)variables);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recall(ToaBillEntity bill, String taskId, String opinion, String userCode) {
        long billId = (Long)MoreObjects.firstNonNull((Object)bill.getId(), (Object)0L);
        String businessKey = String.valueOf(billId);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).active();
        List processInstanceList = query.list();
        for (ProcessInstance processInstance : processInstanceList) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), opinion);
        }
        List<BillTaskEntity> tasks = this.billTaskService.findByBillId(billId);
        if (CollectionUtil.isNotEmpty(tasks)) {
            int taskSize = tasks.size();
            ArrayList billTasks = Lists.newArrayListWithCapacity((int)taskSize);
            int dateline = DateTimeUtil.unixTime();
            ArrayList taskIds = Lists.newArrayList();
            for (BillTaskEntity task : tasks) {
                task.setNodeStatus(BillTaskStatus.APPLY_CANCEL.getStatus());
                task.setDateline(dateline);
                task.setIsDeleted(1);
                task.setUpdateTime(LocalDateTime.now());
                billTasks.add(task);
                taskIds.add(task.getId());
            }
            BillTaskEntity billTask = new BillTaskEntity();
            billTask.setOpinion(opinion);
            billTask.setDateline(dateline);
            billTask.setNodeStatus(BillTaskStatus.CANCEL.getStatus());
            billTask.setAction(BillAction.recall.name());
            billTask.setBillId(billId);
            billTask.setUserCode(userCode);
            billTask.setSort(System.currentTimeMillis());
            boolean recallTask = this.billTaskService.insert(billTask);
            if (!recallTask) {
                throw new RbException("recall back has error!");
            }
            boolean updateState = this.billTaskService.updateBatchById(billTasks);
            this.billTaskService.removeByIds(taskIds);
            if (!updateState) {
                throw new RbException("update task status has error");
            }
            bill.setStatus(BillStatus.CANCEL.getStatus());
            bill.setProcessInstanceId("");
            bill.setId(billId);
            boolean update = this.billService.upldate(bill);
            if (!update) {
                throw new RbException("bill update status update error!");
            }
            ToaBillEntity byId = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
            this.callBackLogic.callBack(byId.getProcessId(), billId, BillStatus.CANCEL.getStatus());
            boolean bl = this.billReadRecordService.deleteByBillId(billId);
        }
    }

    @Override
    public BpmnBillContext createBpmnContext(String employeeId, BillDataContext billDataValue) {
        BpmnBillContext bpmnBillContext = new BpmnBillContext();
        UserInfoDTO userInfoDTO = this.userCenterlogic.getUserInfoByCode(employeeId);
        bpmnBillContext.setId(userInfoDTO.getId());
        bpmnBillContext.setCode(userInfoDTO.getCode());
        bpmnBillContext.setName(userInfoDTO.getNickname());
        List<UserOrgDTO> orgs = userInfoDTO.getOrgs();
        if (CollectionUtil.isNotEmpty(orgs)) {
            UserOrgDTO userOrgDTO = orgs.get(0);
            OrganizationBpmnDTO organizationBpmnDTO = new OrganizationBpmnDTO();
            organizationBpmnDTO.setCode(userOrgDTO.getOrgCode());
            organizationBpmnDTO.setId(userOrgDTO.getOrgId());
            organizationBpmnDTO.setName(userOrgDTO.getOrgName());
            bpmnBillContext.setOrg(organizationBpmnDTO);
            List<UserPositionDTO> positions = this.userCenterlogic.getUserPositionByUserAndOrg(employeeId, userOrgDTO.getOrgId());
            if (CollectionUtil.isNotEmpty(positions)) {
                ArrayList positionBpmns = Lists.newArrayListWithCapacity((int)positions.size());
                for (UserPositionDTO position : positions) {
                    PositionBpmnDTO positionBpmnDTO = new PositionBpmnDTO();
                    positionBpmnDTO.setId(position.getPositionId());
                    positionBpmnDTO.setCode(position.getPositionCode());
                    positionBpmnDTO.setName(position.getPositionName());
                    positionBpmns.add(positionBpmnDTO);
                }
                bpmnBillContext.setPositions(positionBpmns);
            }
        }
        return bpmnBillContext;
    }

    @Override
    public void commitProcess(Task task, Map<String, Object> variables, String targetActivityId) {
        String currentActivityId = task.getTaskDefinitionKey();
        String processDefinitionId = task.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        FlowElement currentFlow = bpmnModel.getFlowElement(currentActivityId);
        FlowElement targetFlow = bpmnModel.getFlowElement(targetActivityId);
        String uuid = UUID.randomUUID().toString().replace("-", "");
        SequenceFlow newSequenceFlow = new SequenceFlow();
        newSequenceFlow.setId(uuid);
        newSequenceFlow.setSourceFlowElement(currentFlow);
        newSequenceFlow.setTargetFlowElement(targetFlow);
        newSequenceFlow.setConditionExpression("${\"+uuid+\"==\"" + uuid + "\"}");
        bpmnModel.getMainProcess().addFlowElement((FlowElement)newSequenceFlow);
        variables.clear();
        variables.put(uuid, uuid);
        this.taskService.addComment(task.getId(), task.getProcessInstanceId(), "\u64a4\u56de");
        this.taskService.complete(task.getId(), variables);
        bpmnModel.getMainProcess().removeFlowElement(uuid);
    }

    @Override
    public void returnToTargetTask(BillTaskEntity taskId, BillTaskEntity targetId, String userCode, String opinion, String nextApprover) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId.getTaskId())).singleResult();
        if (Objects.isNull(task)) {
            throw new RbException((ErrorCode)BillCode.CURRENT_TASK_NULL);
        }
        String processDefinitionId = task.getProcessDefinitionId();
        List haiList = this.historyService.createHistoricActivityInstanceQuery().executionId(task.getExecutionId()).finished().list();
        String targetActivityId = "";
        for (HistoricActivityInstance historicActivityInstance : haiList) {
            if (!targetId.getTaskId().equals(historicActivityInstance.getTaskId())) continue;
            targetActivityId = historicActivityInstance.getActivityId();
            break;
        }
        if (Strings.isNullOrEmpty((String)targetActivityId)) {
            throw new RbException((ErrorCode)BillCode.TARGET_TASK_NULL);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        FlowNode targetFlowNod = (FlowNode)bpmnModel.getMainProcess().getFlowElement(targetActivityId);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode flowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        ArrayList oriSequenceFlows = Lists.newArrayList();
        oriSequenceFlows.addAll(flowNode.getOutgoingFlows());
        flowNode.getOutgoingFlows().clear();
        ArrayList newSequenceFlowList = Lists.newArrayList();
        SequenceFlow newSequenceFlow = new SequenceFlow();
        newSequenceFlow.setId("newSequenceFlowId");
        newSequenceFlow.setSourceFlowElement((FlowElement)flowNode);
        newSequenceFlow.setTargetFlowElement((FlowElement)targetFlowNod);
        newSequenceFlowList.add(newSequenceFlow);
        flowNode.setOutgoingFlows((List)newSequenceFlowList);
        HashMap variables = Maps.newHashMap();
        variables.put("var_opinion", opinion);
        variables.put("var_approver_employee", userCode);
        variables.put("var_action", BillAction.back.name());
        variables.put("var_last_node_key", taskId.getTaskNodeKey());
        variables.put("var_last_task_id", taskId.getTaskId());
        variables.put("var_next_approver", nextApprover);
        this.taskService.complete(task.getId(), (Map)variables);
        flowNode.setOutgoingFlows((List)oriSequenceFlows);
    }

    public BillBpmnLogicImpl(RepositoryService repositoryService, RuntimeService runtimeService, TaskService taskService, IdentityService identityService, ProcessNodeExtendService nodeExtendService, ProcessNodeFormFieldService nodeFormFieldService, BillItemLogic billItemLogic, FormFieldService formFieldService, BillTaskService billTaskService, ToaBillService billService, BillReadRecordService billReadRecordService, UserCenterlogic userCenterlogic, CallBackLogic callBackLogic, HistoryService historyService) {
        this.repositoryService = repositoryService;
        this.runtimeService = runtimeService;
        this.taskService = taskService;
        this.identityService = identityService;
        this.nodeExtendService = nodeExtendService;
        this.nodeFormFieldService = nodeFormFieldService;
        this.billItemLogic = billItemLogic;
        this.formFieldService = formFieldService;
        this.billTaskService = billTaskService;
        this.billService = billService;
        this.billReadRecordService = billReadRecordService;
        this.userCenterlogic = userCenterlogic;
        this.callBackLogic = callBackLogic;
        this.historyService = historyService;
    }
}

