/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jingtong.bpm.infra.entity.BillCcPersonEntity;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.infra.entity.FormExtensionsEntity;
import com.jingtong.bpm.infra.entity.FormSettingEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.po.ProcessDetailPO;
import com.jingtong.bpm.infra.service.BillCcPersonService;
import com.jingtong.bpm.infra.service.FormExpressionService;
import com.jingtong.bpm.infra.service.FormSettingService;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.BillStatus;
import com.jingtong.bpm.logic.constant.BillTaskStatus;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.dto.ProcessDetailDTO;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.BillBtnLogic;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.error.ErrorCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillBtnLogicImpl
implements BillBtnLogic {
    private static final Logger log = LoggerFactory.getLogger(BillBtnLogicImpl.class);
    private final FormExpressionService formExpressionService;
    private final ToaProcessService processService;
    private final RepositoryService repositoryService;
    private final ProcessNodeExtendService nodeExtendService;
    private final BillCcPersonService billCcPersonService;
    private final FormSettingService formSettingService;

    @Override
    public List<String> findBtnsOnCreateBill(ProcessDetailDTO process) {
        ArrayList btns = Lists.newArrayList((Object[])new String[]{"btn-submit", "btn-save"});
        return btns;
    }

    @Override
    public List<String> findBtnsOnTaskAction(String userCode, ToaBillEntity bill, BillTaskEntity billTask) {
        String sender = bill.getSender();
        if (sender.equals(userCode)) {
            return this.findBtnsOnSelfApproval(bill, billTask);
        }
        return this.findBtnsOnCanApproval(bill, billTask);
    }

    private List<String> findBtnsOnCanApproval(ToaBillEntity bill, BillTaskEntity billTask) {
        ArrayList btns;
        int status = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)-1);
        BillStatus billStatus = BillStatus.valueTo(status);
        long processId = (Long)MoreObjects.firstNonNull((Object)bill.getProcessId(), (Object)0L);
        int billTaskNodeStatus = billTask.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(billTaskNodeStatus);
        block0 : switch (billStatus) {
            case DRAFTS: {
                throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
            }
            case APPROVAL: {
                String taskNodeKey;
                switch (1.$SwitchMap$com$jingtong$bpm$logic$constant$BillTaskStatus[billTaskStatus.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                        break block0;
                    }
                    case 9: {
                        taskNodeKey = billTask.getTaskNodeKey();
                        Optional<ProcessNodeExtendEntity> nodeExtendOpt = this.nodeExtendService.findByNodeIdAndProcessId(processId, taskNodeKey);
                        if (nodeExtendOpt.isPresent()) {
                            ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOpt.get());
                            String linkType = nodeExtend.getLinkType();
                            NodeLinkType nodeLinkType = NodeLinkType.valueOf(linkType);
                            switch (nodeLinkType) {
                                case approvl: {
                                    btns = Lists.newArrayList((Object[])new String[]{"btn-agree", "btn-transfer", "btn-back"});
                                    boolean isRefuseNode = this.nextNodeHasRefuse(processId, nodeExtend);
                                    if (isRefuseNode) {
                                        btns.add(1, "btn-refuse");
                                    }
                                    if (nodeExtend.getCountersignFlag().compareTo(1) == 0) {
                                        btns.add("btn-endorse");
                                    }
                                    btns.add("btn-track");
                                    break block0;
                                }
                                case submit: {
                                    btns = Lists.newArrayList((Object[])new String[]{"btn-present", "btn-track"});
                                    break block0;
                                }
                                case create: {
                                    log.error("When the examination and approval to create nodes, should not ah. the task id is {}", (Object)billTask.getId());
                                    throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                                }
                                case archive: {
                                    btns = Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                                    break block0;
                                }
                            }
                            log.error("The corresponding approval task node operation type does not exist. the task id is {}", (Object)billTask.getId());
                            throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                        }
                    }
                    log.error("Cannot find the approval task corresponding node. the task id is {}", (Object)billTask.getId());
                    throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                    case 10: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                        break block0;
                    }
                    case 11: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                        break block0;
                    }
                }
                log.error("the bill task's status has not found. the task id is {}", (Object)billTask.getId());
                throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
            }
            case ARCHIVE: {
                switch (billTaskStatus) {
                    case APPROVAL: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                        break block0;
                    }
                }
                btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                break;
            }
            case CANCEL: 
            case COMPLETE: 
            case REFUSE: {
                String taskNodeKey;
                switch (1.$SwitchMap$com$jingtong$bpm$logic$constant$BillTaskStatus[billTaskStatus.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                        break block0;
                    }
                    case 9: {
                        taskNodeKey = billTask.getTaskNodeKey();
                        Optional<ProcessNodeExtendEntity> nodeExtendOpt = this.nodeExtendService.findByNodeIdAndProcessId(processId, taskNodeKey);
                        if (nodeExtendOpt.isPresent()) {
                            ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOpt.get());
                            String linkType = nodeExtend.getLinkType();
                            NodeLinkType nodeLinkType = NodeLinkType.valueOf(linkType);
                            switch (nodeLinkType) {
                                case approvl: {
                                    btns = Lists.newArrayList((Object[])new String[]{"btn-agree"});
                                    boolean isRefuseNode = this.nextNodeHasRefuse(processId, nodeExtend);
                                    if (isRefuseNode) {
                                        btns.add(1, "btn-refuse");
                                    }
                                    if (nodeExtend.getCountersignFlag().compareTo(1) == 0) {
                                        btns.add("btn-endorse");
                                    }
                                    btns.add("btn-transfer");
                                    btns.add("btn-track");
                                    break block0;
                                }
                                case submit: {
                                    btns = Lists.newArrayList((Object[])new String[]{"btn-present", "btn-track"});
                                    break block0;
                                }
                                case create: {
                                    log.error("When the examination and approval to create nodes, should not ah. the task id is {}", (Object)billTask.getId());
                                    throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                                }
                                case archive: {
                                    btns = Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                                    break block0;
                                }
                            }
                            log.error("The corresponding approval task node operation type does not exist. the task id is {}", (Object)billTask.getId());
                            throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                        }
                    }
                    log.error("Cannot find the approval task corresponding node. the task id is {}", (Object)billTask.getId());
                    throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                    case 10: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                        break block0;
                    }
                    case 11: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                        break block0;
                    }
                }
                log.error("the bill task's status has not found. the task id is {}", (Object)billTask.getId());
                throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
            }
            default: {
                log.error("Error state approval paper. the bill id is {}", (Object)bill.getId());
                throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
            }
        }
        boolean printTemplate = this.hasPrintTemplate(processId);
        if (printTemplate) {
            btns.add("btn-print");
        }
        return btns;
    }

    private List<String> findBtnsOnSelfApproval(ToaBillEntity bill, BillTaskEntity billTask) {
        List<Object> btns;
        int status = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)-1);
        BillStatus billStatus = BillStatus.valueTo(status);
        long processId = (Long)MoreObjects.firstNonNull((Object)bill.getProcessId(), (Object)0L);
        int billTaskNodeStatus = billTask.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(billTaskNodeStatus);
        block0 : switch (billTaskStatus) {
            case FILL_IN: {
                switch (billStatus) {
                    case APPROVAL: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-cancel", "btn-track"});
                        break block0;
                    }
                    case DRAFTS: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-submit", "btn-save", "btn-track"});
                        break block0;
                    }
                    case ARCHIVE: 
                    case COMPLETE: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                        break block0;
                    }
                    case REFUSE: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                        break block0;
                    }
                    case CANCEL: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-submit", "btn-track"});
                        break block0;
                    }
                }
                throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
            }
            case REFUSE_FILL_IN: {
                switch (billStatus) {
                    case REPULSE: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-submit", "btn-track"});
                        break block0;
                    }
                    case APPROVAL: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-cancel", "btn-track"});
                        break block0;
                    }
                    case REFUSE: {
                        btns = this.findBtnsOnReFullIn(processId);
                        break block0;
                    }
                }
                btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                break;
            }
            case APPROVAL: {
                switch (billStatus) {
                    case APPROVAL: {
                        btns = this.findBtnsOnSelfApproval(billTask, processId);
                        break block0;
                    }
                    case ARCHIVE: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                        break block0;
                    }
                }
                btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                break;
            }
            case REFUSE: 
            case CANCEL: {
                btns = this.findBtnsOnReFullIn(processId);
                break;
            }
            case AGREE: 
            case OTHER_APPROVAL: {
                switch (billStatus) {
                    case APPROVAL: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-cancel", "btn-track"});
                        break block0;
                    }
                }
                btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                break;
            }
            case ARCHIVED: {
                switch (billStatus) {
                    case APPROVAL: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                        break block0;
                    }
                }
                btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                break;
            }
            case APPLY_CANCEL: {
                switch (billStatus) {
                    case APPROVAL: {
                        btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                        break block0;
                    }
                }
                btns = Lists.newArrayList((Object[])new String[]{"btn-submit", "btn-track"});
                break;
            }
            case ENDORSE: 
            case TURN: 
            case TRANSFER: {
                btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                break;
            }
            default: {
                btns = Collections.emptyList();
            }
        }
        boolean printTemplate = this.hasPrintTemplate(processId);
        if (printTemplate) {
            btns.add("btn-print");
        }
        return btns;
    }

    private List<String> findBtnsOnSelfApproval(BillTaskEntity billTask, long processId) {
        String taskId = billTask.getTaskId();
        Optional<ProcessNodeExtendEntity> nodeExtendOpt = this.nodeExtendService.findByTaskId(taskId);
        if (nodeExtendOpt.isPresent()) {
            ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOpt.get());
            String linkType = nodeExtend.getLinkType();
            NodeLinkType nodeLinkType = NodeLinkType.valueOf(linkType);
            switch (nodeLinkType) {
                case create: {
                    return this.findBtnsOnReFullIn(processId);
                }
                case archive: {
                    return Lists.newArrayList((Object[])new String[]{"btn-archived", "btn-track"});
                }
                case approvl: {
                    boolean hasRefuse = this.nextNodeHasRefuse(processId, nodeExtend);
                    ArrayList btns = Lists.newArrayList((Object[])new String[]{"btn-cancel", "btn-agree", "btn-back"});
                    if (hasRefuse) {
                        btns.add(2, "btn-refuse");
                    }
                    if (!Objects.isNull(nodeExtend.getCountersignFlag()) && nodeExtend.getCountersignFlag().compareTo(1) == 0) {
                        btns.add("btn-endorse");
                    }
                    btns.add("btn-transfer");
                    btns.add("btn-track");
                    boolean printTemplate = this.hasPrintTemplate(processId);
                    if (printTemplate) {
                        btns.add("btn-print");
                    }
                    return btns;
                }
                case submit: {
                    return Lists.newArrayList((Object[])new String[]{"btn-present", "btn-track"});
                }
            }
            log.error("I launched the approval for examination and approval of the node type error. the bill task id is {}", (Object)billTask.getId());
            throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
        }
        throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
    }

    private boolean nextNodeHasRefuse(long processId, ProcessNodeExtendEntity nodeExtend) {
        boolean isRefuseNode;
        block1: {
            ProcessNodeExtendEntity targetExtend;
            String nodeAction;
            SequenceFlow outgoingFlow;
            String outgoingFlowId;
            Optional<ProcessNodeExtendEntity> targetNode;
            String flowId = "Process_" + processId;
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(flowId).latestVersion().singleResult();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
            FlowElement flowElement = bpmnModel.getFlowElement(nodeExtend.getNodeId());
            isRefuseNode = false;
            if (flowElement == null || !(flowElement instanceof UserTask)) break block1;
            UserTask userTask = (UserTask)flowElement;
            List outgoingFlows = userTask.getOutgoingFlows();
            Iterator iterator = outgoingFlows.iterator();
            while (!(!iterator.hasNext() || (targetNode = this.nodeExtendService.findByFlowIdAndNodeId(outgoingFlowId = (outgoingFlow = (SequenceFlow)iterator.next()).getId(), flowId)).isPresent() && (isRefuseNode = StringUtils.equals((CharSequence)(nodeAction = (targetExtend = (ProcessNodeExtendEntity)((Object)targetNode.get())).getNodeAction()), (CharSequence)BillAction.refuse.toString())))) {
            }
        }
        return isRefuseNode;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<String> findBtnsOnReFullIn(long processId) {
        ProcessDetailPO process = this.processService.findDetailById(processId);
        ArrayList btns = Lists.newArrayList((Object[])new String[]{"btn-submit"});
        List<String> featureBtns = this.findFormExtensions(processId);
        if (CollectionUtil.isNotEmpty(featureBtns)) {
            btns.addAll(featureBtns);
        }
        return btns;
    }

    @Override
    public List<String> findBtnsOnViewBill(String userCode, ToaBillEntity bill) {
        String sender = bill.getSender();
        int status = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)-1);
        BillStatus billStatus = BillStatus.valueTo(status);
        if (sender.equals(userCode)) {
            ArrayList btns;
            long processId = (Long)MoreObjects.firstNonNull((Object)bill.getProcessId(), (Object)0L);
            boolean printTmplate = this.hasPrintTemplate(processId);
            switch (billStatus) {
                case DRAFTS: {
                    btns = Lists.newArrayList((Object[])new String[]{"btn-submit", "btn-save"});
                    break;
                }
                case APPROVAL: {
                    btns = Lists.newArrayList((Object[])new String[]{"btn-cancel", "btn-track"});
                    break;
                }
                case ARCHIVE: 
                case COMPLETE: {
                    btns = Lists.newArrayList((Object[])new String[]{"btn-track"});
                    break;
                }
                case CANCEL: {
                    btns = Lists.newArrayList((Object[])new String[]{"btn-submit", "btn-track"});
                    break;
                }
                default: {
                    log.error("Approval for the current status, there is an error!");
                    throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
                }
            }
            if (printTmplate && billStatus != BillStatus.DRAFTS) {
                btns.add("btn-print");
            }
            return btns;
        }
        long billId = bill.getId();
        BillCcPersonEntity ccPerson = this.billCcPersonService.findByEmployeeAndBill(billId, userCode);
        if (ccPerson != null) {
            return Lists.newArrayList((Object[])new String[]{"btn-track"});
        }
        throw new RbException((ErrorCode)BillCode.CAN_NOT_SEE);
    }

    @Override
    public List<String> filterByNode(BillTaskEntity billTask, List<String> btns) {
        if (Objects.isNull((Object)billTask)) {
            return btns;
        }
        String taskId = billTask.getTaskId();
        Optional<ProcessNodeExtendEntity> byTaskId = this.nodeExtendService.findByTaskId(taskId);
        if (byTaskId.isPresent()) {
            ProcessNodeExtendEntity processNodeExtendEntity = (ProcessNodeExtendEntity)((Object)byTaskId.get());
            String btns1 = processNodeExtendEntity.getBtns();
            List split = StrUtil.split((CharSequence)btns1, (char)',');
            split.add("btn-submit");
            split.add("btn-cancel");
            split.add("btn-track");
            split.add("btn-endorse");
            return btns.stream().filter(a -> split.contains(a)).collect(Collectors.toList());
        }
        return btns;
    }

    private List<String> findFormExtensions(long processId) {
        ArrayList btns = Lists.newArrayList();
        List<FormExtensionsEntity> formExtensions = this.formExpressionService.findByProcessId(processId);
        if (CollectionUtil.isNotEmpty(formExtensions)) {
            for (FormExtensionsEntity formExtension : formExtensions) {
                String feature;
                String type = formExtension.getType();
                if (Strings.isNullOrEmpty((String)type) || !StringUtils.equals((CharSequence)type, (CharSequence)"001") || Strings.isNullOrEmpty((String)(feature = formExtension.getFeature())) || btns.contains(feature)) continue;
                btns.add(feature);
            }
        }
        return btns;
    }

    private boolean hasPrintTemplate(long processId) {
        FormSettingEntity processSetting = this.formSettingService.findByProcess(processId);
        boolean printTmplate = false;
        if (processSetting != null) {
            String printTemplatePath = processSetting.getPrintTemplatePath();
            printTmplate = !Strings.isNullOrEmpty((String)printTemplatePath);
        }
        return printTmplate;
    }

    public BillBtnLogicImpl(FormExpressionService formExpressionService, ToaProcessService processService, RepositoryService repositoryService, ProcessNodeExtendService nodeExtendService, BillCcPersonService billCcPersonService, FormSettingService formSettingService) {
        this.formExpressionService = formExpressionService;
        this.processService = processService;
        this.repositoryService = repositoryService;
        this.nodeExtendService = nodeExtendService;
        this.billCcPersonService = billCcPersonService;
        this.formSettingService = formSettingService;
    }
}

