/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import com.google.common.collect.Lists;
import com.jingtong.bpm.infra.entity.BillCcPersonEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.service.BillCcPersonService;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.service.BillCcPersonLogic;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.datetime.DateTimeUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BillCcPersonLogicImpl
implements BillCcPersonLogic {
    private static final Logger log = LoggerFactory.getLogger(BillCcPersonLogicImpl.class);
    private final ToaProcessService processService;
    private final ProcessNodeExtendService nodeExtendService;
    private final BillCcPersonService billCcPersonService;

    @Override
    public void saveBillCc(Set<String> ccUsers, long billId, String nodeId, String flowId) {
        Optional<ToaProcessEntity> process = this.processService.getByFlowId(flowId);
        if (!process.isPresent()) {
            throw new RbException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff01");
        }
        long processId = process.get().getId();
        com.google.common.base.Optional<ProcessNodeExtendEntity> nodeExtendOptional = this.nodeExtendService.findByFlowIdAndNodeId(nodeId, flowId);
        String nodeName = "";
        if (nodeExtendOptional.isPresent()) {
            ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOptional.get());
            nodeName = nodeExtend.getNodeName();
        }
        ArrayList billCcPeople = Lists.newArrayList();
        for (String ccUser : ccUsers) {
            BillCcPersonEntity billCcPerson = new BillCcPersonEntity();
            billCcPerson.setBillId(billId);
            billCcPerson.setCreationTime(LocalDateTime.now());
            billCcPerson.setIsDeleted(0);
            billCcPerson.setUserCode(ccUser);
            billCcPerson.setProcessId(processId);
            billCcPerson.setNodeName(nodeName);
            billCcPerson.setDateline(DateTimeUtil.unixTime());
            billCcPeople.add(billCcPerson);
        }
        boolean isOk = this.billCcPersonService.saveBatch(billCcPeople);
        if (!isOk) {
            throw new RbException("\u4fdd\u5b58\u5ba1\u6279\u6284\u9001\u4eba\u5931\u8d25\uff01");
        }
    }

    public BillCcPersonLogicImpl(ToaProcessService processService, ProcessNodeExtendService nodeExtendService, BillCcPersonService billCcPersonService) {
        this.processService = processService;
        this.nodeExtendService = nodeExtendService;
        this.billCcPersonService = billCcPersonService;
    }
}

