/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.googlecode.aviator.AviatorEvaluator;
import com.jingtong.bpm.infra.entity.SysCodeFormatEntity;
import com.jingtong.bpm.infra.service.SysCodeFormatService;
import com.jingtong.bpm.logic.service.BillCodeLogic;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillCodeLogicImpl
implements BillCodeLogic {
    private static final Logger log = LoggerFactory.getLogger(BillCodeLogicImpl.class);
    String PROCESS_TYPE = "process_type";
    String PROCESS_CODE = "process_code";
    protected final SysCodeFormatService codeFormatService;

    @Override
    @Transactional(readOnly=true)
    public String execCodeRule(long codeId, long processId, long processTypeId) {
        if (codeId <= 0L) {
            return "";
        }
        SysCodeFormatEntity codeFormat = (SysCodeFormatEntity)((Object)this.codeFormatService.getById(Long.valueOf(codeId)));
        String format = codeFormat.getFormat();
        if (Strings.isNullOrEmpty((String)format)) {
            return "";
        }
        HashMap env = Maps.newHashMap();
        if (StringUtils.contains((CharSequence)format, (CharSequence)this.PROCESS_TYPE)) {
            if (processTypeId <= 0L) {
                return "";
            }
            env.put("id", processTypeId);
        } else if (StringUtils.contains((CharSequence)format, (CharSequence)this.PROCESS_CODE)) {
            if (processId <= 0L) {
                return "";
            }
            env.put("id", processId);
        }
        return AviatorEvaluator.execute((String)format, (Map)env).toString();
    }

    public BillCodeLogicImpl(SysCodeFormatService codeFormatService) {
        this.codeFormatService = codeFormatService;
    }
}

