/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jingtong.bpm.infra.entity.BillDataJsonEntity;
import com.jingtong.bpm.infra.entity.FormDesingerEntity;
import com.jingtong.bpm.infra.service.BillDataJsonService;
import com.jingtong.bpm.infra.service.FormDesingerService;
import com.jingtong.bpm.logic.constant.FastJsonType;
import com.jingtong.bpm.logic.context.BillDataContext;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.BillDataJsonLogic;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.error.ErrorCode;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillDataJsonLogicImpl
implements BillDataJsonLogic {
    private static final Logger log = LoggerFactory.getLogger(BillDataJsonLogicImpl.class);
    private final BillDataJsonService billDataJsonService;
    private final FormDesingerService formDesingerService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BillDataJsonEntity saveByBillData(BillDataContext billDataValue, String formDataJSON) {
        boolean insertState;
        long billId = billDataValue.getId();
        long processId = billDataValue.getProcessId();
        BillDataJsonEntity dbObj = (BillDataJsonEntity)((Object)this.billDataJsonService.getOne((Wrapper)Wrappers.lambdaQuery(BillDataJsonEntity.class).eq(BillDataJsonEntity::getBillId, (Object)billId)));
        FormDesingerEntity formDesinger = this.formDesingerService.getByProcessId(processId);
        BillDataJsonEntity dataJson = new BillDataJsonEntity();
        dataJson.setFormData(formDataJSON);
        dataJson.setFormSchema(formDesinger.getDesingerJson());
        dataJson.setBillId(billId);
        dataJson.setOutline(billDataValue.getOutline());
        dataJson.setAssociated(billDataValue.getAssociated());
        if (!Objects.isNull((Object)dbObj)) {
            dataJson.setId(dbObj.getId());
        }
        boolean bl = insertState = Objects.isNull((Object)dbObj) ? this.billDataJsonService.save((Object)dataJson) : this.billDataJsonService.upldate(dataJson);
        if (!insertState) {
            throw new RbException((ErrorCode)BillCode.BILL_DATA_SAVE_ERROR);
        }
        return dataJson;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateByBillId(long billId, Map<String, Object> dataMap) {
        BillDataJsonEntity dataJson = (BillDataJsonEntity)((Object)this.billDataJsonService.getOne((Wrapper)Wrappers.lambdaQuery(BillDataJsonEntity.class).eq(BillDataJsonEntity::getBillId, (Object)billId)));
        String dbFormData = dataJson.getFormData();
        log.debug("the bill {} formdata is {}", (Object)billId, (Object)dbFormData);
        Map dbDataMap = (Map)JSON.parseObject((String)dbFormData, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        for (String dataKey : dataMap.keySet()) {
            dbDataMap.put(dataKey, dataMap.get(dataKey));
        }
        String formData = JSON.toJSONString((Object)dbDataMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue});
        dataJson.setFormData(formData);
        log.debug("the bill {} update aft formdata is {}", (Object)billId, (Object)formData);
        return this.billDataJsonService.upldate(dataJson);
    }

    public BillDataJsonLogicImpl(BillDataJsonService billDataJsonService, FormDesingerService formDesingerService) {
        this.billDataJsonService = billDataJsonService;
        this.formDesingerService = formDesingerService;
    }
}

