/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jingtong.bpm.infra.entity.BillBizDataEntity;
import com.jingtong.bpm.infra.entity.FormFieldEntity;
import com.jingtong.bpm.infra.entity.ToaFormEntity;
import com.jingtong.bpm.infra.po.FormFieldPO;
import com.jingtong.bpm.infra.service.FormFieldService;
import com.jingtong.bpm.infra.service.FormTableService;
import com.jingtong.bpm.infra.service.ToaFormService;
import com.jingtong.bpm.logic.constant.BizType;
import com.jingtong.bpm.logic.constant.FastJsonType;
import com.jingtong.bpm.logic.constant.FormCode;
import com.jingtong.bpm.logic.define.FormXtype;
import com.jingtong.bpm.logic.define.widget.ImageuploadWidget;
import com.jingtong.bpm.logic.define.widget.TriggerselectWidget;
import com.jingtong.bpm.logic.dto.BillItemFieldDto;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.exception.FormDataException;
import com.jingtong.bpm.logic.service.BillDataJsonLogic;
import com.jingtong.bpm.logic.service.BillItemLogic;
import com.jingtong.bpm.logic.vo.BillAssociatedVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.ErrorCode;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.form.model.FormField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BillItemLogicImpl
implements BillItemLogic {
    private static final Logger log = LoggerFactory.getLogger(BillItemLogicImpl.class);
    private final ToaFormService formService;
    private final FormFieldService formFieldService;
    private final FormTableService formTableService;
    private final BillDataJsonLogic billDataJsonLogic;
    private static final String ID_PARAM = "#{id_}";

    @Override
    public Pair<List<BillAssociatedVO>, List<BillBizDataEntity>> formTriggerselectValue(Map<String, Object> formDataMap, FormFieldPO formFieldVO, long newBillId) {
        ArrayList associateds = Lists.newArrayList();
        ArrayList bizdatas = Lists.newArrayList();
        String widgetName = formFieldVO.getWidgetName();
        Object selectWidgetObject = formDataMap.get(widgetName);
        if (selectWidgetObject != null) {
            if (selectWidgetObject instanceof JSONArray) {
                JSONArray selectValues = (JSONArray)selectWidgetObject;
                if (CollectionUtil.isNotEmpty((Collection)selectValues)) {
                    Pair<List<BillBizDataEntity>, List<BillAssociatedVO>> associatedAndBizdData = this.multiSelectValue(formFieldVO, newBillId, selectValues);
                    List bizDatas = (List)associatedAndBizdData.getKey();
                    List associatedList = (List)associatedAndBizdData.getRight();
                    if (CollectionUtil.isNotEmpty((Collection)bizDatas)) {
                        bizdatas.addAll(bizDatas);
                    }
                    if (CollectionUtil.isNotEmpty((Collection)associatedList)) {
                        associateds.addAll(associatedList);
                    }
                }
            } else {
                JSONObject selectValue = (JSONObject)selectWidgetObject;
                String dataVal = selectValue.getString("value");
                String record = selectValue.getString("record");
                BillAssociatedVO billAssociated = new BillAssociatedVO();
                billAssociated.setId(dataVal);
                billAssociated.setTitle(formFieldVO.getTitle());
                billAssociated.setName(selectValue.getString("text"));
                associateds.add(billAssociated);
                BillBizDataEntity bizData = new BillBizDataEntity();
                bizData.setBillId(newBillId);
                bizData.setBizType(formFieldVO.getDatasourceCode());
                bizData.setBizValue(dataVal);
                bizData.setBizRecord(record);
                bizdatas.add(bizData);
            }
        }
        return Pair.of((Object)associateds, (Object)bizdatas);
    }

    private Pair<List<BillBizDataEntity>, List<BillAssociatedVO>> multiSelectValue(FormFieldPO formFieldVO, long newBillId, JSONArray selectValues) {
        ArrayList bizdatas = Lists.newArrayList();
        ArrayList associateds = Lists.newArrayList();
        for (Object selectValue : selectValues) {
            Object selectRecord;
            JSONObject value = (JSONObject)selectValue;
            String checkValue = value.getString("value");
            if (Strings.isNullOrEmpty((String)checkValue) || (selectRecord = value.get((Object)"record")) == null) continue;
            BillAssociatedVO billAssociated = new BillAssociatedVO();
            billAssociated.setId(checkValue);
            billAssociated.setTitle(formFieldVO.getTitle());
            billAssociated.setName(value.getString("text"));
            associateds.add(billAssociated);
            BillBizDataEntity bizData = new BillBizDataEntity();
            bizData.setBillId(newBillId);
            bizData.setBizType(formFieldVO.getDatasourceCode());
            bizData.setBizValue(checkValue);
            bizData.setBizRecord(value.getString("record"));
            bizdatas.add(bizData);
        }
        return Pair.of((Object)bizdatas, (Object)associateds);
    }

    @Override
    public Triple<Boolean, List<BillAssociatedVO>, List<BillBizDataEntity>> detailFormFileds(long billId, JSONArray detailgroupDatas, List<FormFieldPO> detailFields) {
        ArrayList associateds = Lists.newArrayList();
        ArrayList bizDatas = Lists.newArrayList();
        boolean attachment = false;
        for (Object detailgroupData : detailgroupDatas) {
            JSONObject jsonObject = (JSONObject)detailgroupData;
            for (FormFieldPO detailField : detailFields) {
                if (detailField == null) continue;
                String detailFieldType = detailField.getType();
                FormXtype detialXtype = FormXtype.valueOf(detailFieldType);
                switch (detialXtype) {
                    case triggerselect: {
                        Pair<List<BillAssociatedVO>, List<BillBizDataEntity>> triggerPair = this.formTriggerselectValue((Map<String, Object>)jsonObject, detailField, billId);
                        List associatedList = (List)triggerPair.getKey();
                        associateds.addAll(associatedList);
                        List bizDataList = (List)triggerPair.getValue();
                        bizDatas.addAll(bizDataList);
                        break;
                    }
                    case imageupload: 
                    case fileupload: {
                        Pair<String, String> uploadValue = this.formUploadValue((Map<String, Object>)jsonObject, detailField);
                        if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)uploadValue.getKey()))) break;
                        attachment = true;
                        break;
                    }
                }
            }
        }
        return Triple.of((Object)attachment, (Object)associateds, (Object)bizDatas);
    }

    @Override
    public void converPhysicalData(String userCode, long processId, long billId, Map<String, Object> formDataMap) {
        ToaFormEntity processForm = (ToaFormEntity)((Object)this.formService.getOne((Wrapper)Wrappers.lambdaQuery(ToaFormEntity.class).eq(ToaFormEntity::getProcessId, (Object)processId)));
        String tableName = processForm.getTableName();
        if (Strings.isNullOrEmpty((String)tableName)) {
            return;
        }
        List detailFromField = this.formFieldService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FormFieldEntity.class).eq(FormFieldEntity::getFormId, (Object)processForm.getId())).eq(FormFieldEntity::getType, (Object)FormXtype.detailgroup.name()));
        this.checkAndDeleted(billId, tableName, detailFromField);
        if (CollectionUtil.isNotEmpty((Collection)detailFromField)) {
            int detailOrder = 1;
            for (FormFieldEntity formField : detailFromField) {
                String widgetName = formField.getWidgetName();
                List detailDatas = (List)formDataMap.get(widgetName);
                for (Object detailData : detailDatas) {
                    Map detailDataMap = (Map)detailData;
                    ArrayList detailWidgetNames = Lists.newArrayList();
                    ArrayList paramDetailNames = Lists.newArrayList();
                    detailWidgetNames.add("id_");
                    detailWidgetNames.add("main_id_");
                    paramDetailNames.add(ID_PARAM);
                    paramDetailNames.add("#{main_id_}");
                    Map<String, Object> params = this.parseToSqlAndParams(detailWidgetNames, paramDetailNames, detailDataMap);
                    params.put("id_", IdWorker.getId());
                    params.put("main_id_", billId);
                    String detailTableName = tableName + "_dt" + detailOrder;
                    String sqlFormat = "insert into {0} ({1}) values ({2})";
                    String columns = StringUtils.join((Iterable)detailWidgetNames, (String)",");
                    String paramColumns = StringUtils.join((Iterable)paramDetailNames, (String)",");
                    String sql = StrUtil.indexedFormat((CharSequence)sqlFormat, (Object[])new Object[]{detailTableName, columns, paramColumns});
                    this.formTableService.executeUpdateSql(sql, params);
                }
                formDataMap.remove(widgetName);
                ++detailOrder;
            }
        }
        ArrayList mainWidgetName = Lists.newArrayList();
        ArrayList mainParams = Lists.newArrayList();
        mainWidgetName.add("id_");
        mainWidgetName.add("user_code");
        mainWidgetName.add("create_time");
        mainParams.add(ID_PARAM);
        mainParams.add("#{user_code}");
        mainParams.add("#{create_time}");
        Map<String, Object> params = this.parseToSqlAndParams(mainWidgetName, mainParams, formDataMap);
        params.put("id_", billId);
        params.put("create_time", DateTimeUtil.unixTime());
        params.put("user_code", userCode);
        String sqlFormat = "insert into {0} ({1}) values ({2})";
        String columns = StringUtils.join((Iterable)mainWidgetName, (String)",");
        String paramColumns = StringUtils.join((Iterable)mainParams, (String)",");
        String sql = StrUtil.indexedFormat((CharSequence)sqlFormat, (Object[])new Object[]{tableName, columns, paramColumns});
        this.formTableService.executeUpdateSql(sql, params);
    }

    private void checkAndDeleted(long billId, String tableName, List<FormFieldEntity> detailFromField) {
        String countStr;
        int count;
        Map<String, Object> countResult;
        String template = "SELECT count(1) as count from {} WHERE id_ = {} LIMIT 1";
        String existSql = StrUtil.format((CharSequence)"SELECT count(1) as count from {} WHERE id_ = {} LIMIT 1", (Object[])new Object[]{tableName, "#{sql.id_}"});
        HashMap existSqlParams = Maps.newHashMapWithExpectedSize((int)1);
        existSqlParams.put("id_", billId);
        List<Map<String, Object>> countResults = this.formTableService.executeSelectSql(existSql, existSqlParams);
        if (CollectionUtil.isNotEmpty(countResults) && CollectionUtil.isNotEmpty(countResult = countResults.get(0)) && (count = ((Integer)MoreObjects.firstNonNull((Object)NumberUtils.createInteger((String)(countStr = String.valueOf(countResult.get("count")))), (Object)0)).intValue()) > 0) {
            if (CollectionUtil.isNotEmpty(detailFromField)) {
                int detailOrder = 1;
                for (FormFieldEntity ignored : detailFromField) {
                    String sqlFormat = "DELETE FROM {} WHERE main_id_ = {}";
                    String detailTableName = tableName + "_dt" + detailOrder;
                    String deleteDtailSql = StrUtil.format((CharSequence)sqlFormat, (Object[])new Object[]{detailTableName, ID_PARAM});
                    this.formTableService.executeUpdateSql(deleteDtailSql, existSqlParams);
                    ++detailOrder;
                }
            }
            String sqlFormat = "DELETE FROM {} WHERE id_ = {}";
            String deleteMainSql = StrUtil.format((CharSequence)sqlFormat, (Object[])new Object[]{tableName, ID_PARAM});
            this.formTableService.executeUpdateSql(deleteMainSql, existSqlParams);
        }
    }

    private Map<String, Object> parseToSqlAndParams(List<String> widgetNames, List<String> paramsnames, Map<String, Object> dataMap) {
        HashMap params = Maps.newHashMap();
        for (String detailWidgetName : dataMap.keySet()) {
            if (StringUtils.equals((CharSequence)detailWidgetName, (CharSequence)"var_porject") || StringUtils.equals((CharSequence)detailWidgetName, (CharSequence)"var_customer")) continue;
            widgetNames.add(detailWidgetName);
            paramsnames.add(StrUtil.format((CharSequence)"#{{}}", (Object[])new Object[]{detailWidgetName}));
            Object detailFileValue = dataMap.get(detailWidgetName);
            params.put(detailWidgetName, detailFileValue);
        }
        return params;
    }

    @Override
    public void updateByFormDataByBill(long billId, String formData) {
        ToaFormEntity form = this.formService.findByBillId(billId);
        if (form == null) {
            log.error("the form is not found! billid is {}", (Object)billId);
            return;
        }
        Map dataMap = (Map)JSON.parseObject((String)formData, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        this.billDataJsonLogic.updateByBillId(billId, dataMap);
        ArrayList mainParams = Lists.newArrayList();
        Map<String, Object> params = this.parseUpdateSqlAndParams(form.getId(), mainParams, dataMap);
        params.put("id_", billId);
        String sqlFormat = "update {0} set {1} WHERE id_={2}";
        String tableName = form.getTableName();
        String paramColumns = StringUtils.join((Iterable)mainParams, (String)",");
        String sql = StrUtil.indexedFormat((CharSequence)sqlFormat, (Object[])new Object[]{tableName, paramColumns, ID_PARAM});
        this.formTableService.executeUpdateSql(sql, params);
    }

    private Map<String, Object> parseUpdateSqlAndParams(long formId, List<String> paramsnames, Map<String, Object> dataMap) {
        List<FormFieldPO> formFields = this.formFieldService.findPOByFormId(formId);
        HashMap widgetFieldMap = Maps.newHashMap();
        for (FormFieldPO formField : formFields) {
            widgetFieldMap.put(formField.getWidgetName(), formField);
        }
        HashMap params = Maps.newHashMap();
        for (String widgetName : dataMap.keySet()) {
            FormFieldPO formField = (FormFieldPO)widgetFieldMap.get(widgetName);
            Object widgetValue = dataMap.get(widgetName);
            Map<String, Object> fileValueMap = this.parseFileValue(formField, widgetValue);
            params.putAll(fileValueMap);
            paramsnames.add(StrUtil.format((CharSequence)"{}=#{{}}", (Object[])new Object[]{widgetName, widgetName}));
        }
        return params;
    }

    @Override
    public Map<String, Object> parseFileValue(FormFieldPO formField, Object widgetValue) {
        String fieldType = formField.getType();
        FormXtype type = FormXtype.valueOf(fieldType);
        String widgetName = formField.getWidgetName();
        HashMap params = Maps.newHashMap();
        switch (type) {
            case text: 
            case textarea: 
            case biz: {
                String strValue = this.getStringValue(widgetName, widgetValue);
                params.put(widgetName, strValue);
                break;
            }
            case datetime: {
                this.parseFieldDatetime(params, widgetName, widgetValue);
                break;
            }
            case number: {
                Double numberValue = this.getNumberValue(widgetName, widgetValue);
                params.put(widgetName, numberValue);
                break;
            }
            case detailcalculate: 
            case money: {
                BigDecimal moneyValue = this.getMoneyValue(widgetName, widgetValue);
                params.put(widgetName, moneyValue);
                break;
            }
            case radiogroup: 
            case select: {
                String value = this.getSelectValue(formField, widgetValue);
                params.put(widgetName, value);
                break;
            }
            case checkboxgroup: 
            case multiselect: {
                Pair<String, String> selectValue = this.getMulteSelectValue(formField, widgetValue);
                params.put(widgetName, selectValue.getKey());
                params.put(widgetName + "_ext", selectValue.getValue());
                break;
            }
            case imageupload: {
                String uploadVal = this.getImageUploadValue(formField, widgetValue);
                params.put(widgetName, uploadVal);
                break;
            }
            case fileupload: {
                String uploadVal = this.getImageUploadValue(formField, widgetValue);
                params.put(widgetName, uploadVal);
                break;
            }
            case triggerselect: {
                Triple<String, String, Set<Object>> triggerValue = this.getTriggerValue(formField, widgetValue);
                String dataValue = (String)triggerValue.getLeft();
                if (Strings.isNullOrEmpty((String)dataValue)) {
                    params.put(widgetName, "");
                    params.put(widgetName + "_ext", "");
                    break;
                }
                params.put(widgetName, dataValue);
                params.put(widgetName + "_ext", triggerValue.getMiddle());
                break;
            }
        }
        return params;
    }

    @Override
    public Triple<String, String, Set<Object>> getTriggerValue(FormFieldPO formField, Object widgetValue) {
        if (widgetValue == null) {
            return Triple.of((Object)"", (Object)"", Collections.emptySet());
        }
        String props = formField.getProps();
        if (Strings.isNullOrEmpty((String)props)) {
            return Triple.of((Object)"", (Object)"", Collections.emptySet());
        }
        TriggerselectWidget triggerWidget = (TriggerselectWidget)JSONObject.parseObject((String)props, TriggerselectWidget.class);
        if (triggerWidget.isMultiSelect()) {
            if (widgetValue instanceof JSONArray) {
                ArrayList dataValues = Lists.newArrayList();
                ArrayList dataExtValues = Lists.newArrayList();
                JSONArray valueArray = (JSONArray)widgetValue;
                if (CollectionUtil.isNotEmpty((Collection)valueArray)) {
                    HashSet records = Sets.newHashSet();
                    for (Object value : valueArray) {
                        JSONObject jsonObject = (JSONObject)value;
                        String dataValue = (String)MoreObjects.firstNonNull((Object)jsonObject.getString("value"), (Object)"");
                        String dataExtValue = (String)MoreObjects.firstNonNull((Object)jsonObject.getString("text"), (Object)"");
                        dataValues.add(dataValue);
                        dataExtValues.add(dataExtValue);
                        records.add(jsonObject.get((Object)"record"));
                    }
                    String extValue = JSON.toJSONString((Object)dataExtValues);
                    return Triple.of((Object)JSON.toJSONString((Object)dataValues), (Object)extValue, (Object)records);
                }
                return Triple.of((Object)"", (Object)"", Collections.emptySet());
            }
            throw new FormDataException((ErrorCode)FormCode.MULTI_REQUIRED, formField.getTitle() + "\u591a\u9009");
        }
        if (widgetValue instanceof JSONObject) {
            JSONObject valueObject = (JSONObject)widgetValue;
            String dataValue = valueObject.getString("value");
            String dataExtValue = valueObject.getString("text");
            HashSet records = Sets.newHashSet((Object[])new Object[]{valueObject.get((Object)"record")});
            return Triple.of((Object)dataValue, (Object)dataExtValue, (Object)records);
        }
        throw new FormDataException(FormCode.SIGNLE_REQUIRED);
    }

    private String getImageUploadValue(FormFieldPO formFieldVO, Object widgetValue) {
        String dataVal;
        if (widgetValue != null) {
            String props = formFieldVO.getProps();
            if (Strings.isNullOrEmpty((String)props)) {
                return "";
            }
            ImageuploadWidget imageuploadWidget = (ImageuploadWidget)JSON.parseObject((String)props, ImageuploadWidget.class);
            boolean allowMulti = imageuploadWidget.isAllowMulti();
            dataVal = this.uploadValue(widgetValue, allowMulti);
        } else {
            dataVal = "";
        }
        return dataVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String uploadValue(Object widgetValue, boolean allowMulti) {
        if (allowMulti) {
            if (widgetValue instanceof JSONArray) {
                JSONArray uploadValues = (JSONArray)widgetValue;
                if (CollectionUtil.isEmpty((Collection)uploadValues)) {
                    return "";
                }
                ArrayList values = Lists.newArrayList();
                Iterator iterator = uploadValues.iterator();
                while (iterator.hasNext()) {
                    Object uploadValue = iterator.next();
                    JSONObject value = (JSONObject)uploadValue;
                    values.add(value.getString("attrId"));
                }
                return JSON.toJSONString((Object)values);
            }
            if (widgetValue instanceof JSONObject) {
                JSONObject uploadValue = (JSONObject)widgetValue;
                return uploadValue.getString("attrId");
            }
            log.error("the multi image upload. client upload data has error!!!!");
            throw new FormDataException(FormCode.MULTI_REQUIRED);
        }
        if (widgetValue instanceof JSONArray) {
            log.error("the image upload is single upload but the client upload multi images!");
            throw new FormDataException(FormCode.SIGNLE_REQUIRED);
        }
        JSONObject uploadValue = (JSONObject)widgetValue;
        return uploadValue.getString("attrId");
    }

    private Pair<String, String> getMulteSelectValue(FormFieldPO formField, Object widgetValue) {
        String dataValExt;
        String dataVal;
        if (widgetValue == null) {
            return Pair.of((Object)"", (Object)"");
        }
        if (widgetValue instanceof JSONArray) {
            JSONArray selectValues = (JSONArray)widgetValue;
            if (CollectionUtil.isEmpty((Collection)selectValues)) {
                dataVal = "";
                dataValExt = "";
            } else {
                ArrayList values = Lists.newArrayList();
                ArrayList extValues = Lists.newArrayList();
                for (Object selectValue : selectValues) {
                    JSONObject value = (JSONObject)selectValue;
                    String checkValue = value.getString("value");
                    if (Strings.isNullOrEmpty((String)checkValue)) continue;
                    values.add(checkValue);
                    Object selectRecord = value.get((Object)"text");
                    if (selectRecord == null) continue;
                    extValues.add(selectRecord);
                }
                dataVal = JSON.toJSONString((Object)values);
                dataValExt = JSON.toJSONString((Object)extValues);
            }
        } else {
            String value = String.valueOf(widgetValue);
            if (StringUtils.isBlank((CharSequence)value)) {
                dataVal = "";
                dataValExt = "";
            } else if (StringUtils.equals((CharSequence)"null", (CharSequence)value)) {
                dataVal = "";
                dataValExt = "";
            } else {
                dataVal = value;
                dataValExt = "";
            }
        }
        return Pair.of((Object)dataVal, (Object)dataValExt);
    }

    private String getSelectValue(FormFieldPO formField, Object widgetValue) {
        JSONObject value;
        String checkValue;
        if (widgetValue == null) {
            return "";
        }
        String dataVal = widgetValue instanceof JSONObject ? (Strings.isNullOrEmpty((String)(checkValue = (value = (JSONObject)widgetValue).getString("value"))) ? "" : (StringUtils.equals((CharSequence)"null", (CharSequence)checkValue) ? "" : checkValue)) : (StringUtils.isBlank((CharSequence)(value = String.valueOf(widgetValue))) ? "" : (StringUtils.equals((CharSequence)"null", (CharSequence)value) ? "" : value));
        return dataVal;
    }

    private BigDecimal getMoneyValue(String widgetName, Object widgetValue) {
        if (widgetValue == null) {
            return BigDecimal.ZERO;
        }
        String value = String.valueOf(widgetValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            return BigDecimal.ZERO;
        }
        if (StringUtils.equals((CharSequence)"null", (CharSequence)value)) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.createBigDecimal((String)value);
    }

    private Double getNumberValue(String widgetName, Object widgetValue) {
        if (widgetValue == null) {
            return 0.0;
        }
        String value = String.valueOf(widgetValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0.0;
        }
        if (StringUtils.equals((CharSequence)"null", (CharSequence)value)) {
            return 0.0;
        }
        return NumberUtils.createDouble((String)value);
    }

    private String getStringValue(String widgetName, Object widgetValue) {
        if (widgetValue == null) {
            return "";
        }
        String value = String.valueOf(widgetValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        if (StringUtils.equals((CharSequence)"null", (CharSequence)value)) {
            return "";
        }
        return value;
    }

    private void parseFieldDatetime(Map<String, Object> formDataParam, String widgetName, Object widgetValue) {
        try {
            Date dateValue = this.getDateValue(widgetName, widgetValue);
            formDataParam.put(widgetName, dateValue);
        }
        catch (ParseException e) {
            log.error("parse datatime filed has error", (Throwable)e);
            throw new RbException("\u5b57\u6bb5[" + widgetName + "] \u8f93\u5165\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef!", (ErrorCode)BillCode.FORM_DATA_ERROR);
        }
    }

    private Date getDateValue(String widgetName, Object widgetValue) throws ParseException {
        if (widgetValue == null) {
            return null;
        }
        String value = String.valueOf(widgetValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)"null", (CharSequence)value)) {
            return null;
        }
        return DateUtils.parseDate((String)value, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy"});
    }

    @Override
    public List<List<BillItemFieldDto>> findDetailByColumn(Map<String, FormField> column, String tableName, long billid) {
        return null;
    }

    @Override
    public List<List<BillItemFieldDto>> findDetailByColumnZone(Map<String, FormField> column, String tableName, long billid) {
        return null;
    }

    @Override
    public List<BillItemFieldDto> findItemByFiled(Map<String, FormField> column, String tableName, long billId) {
        return null;
    }

    @Override
    public List<BillItemFieldDto> findItemByFiledZone(Map<String, FormField> column, String tableName, long billId) {
        return null;
    }

    @Override
    public String formDatetimeValue(Date date, String props) {
        return null;
    }

    @Override
    public Pair<String, String> formBizValue(Map<String, Object> formDataMap, FormFieldPO formField) {
        String code = "";
        String title = "";
        String bizType = formField.getBizType();
        if (!Strings.isNullOrEmpty((String)bizType)) {
            String bizValue = (String)formDataMap.get(formField.getWidgetName());
            if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizType.billCode.name())) {
                code = bizValue;
                if (Strings.isNullOrEmpty((String)code)) {
                    code = DateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmm") + RandomUtil.randomNumbers((int)6);
                }
            } else if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizType.billTitle.name()) && Strings.isNullOrEmpty((String)(title = bizValue))) {
                title = DateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmm") + RandomUtil.randomNumbers((int)6);
            }
        }
        return Pair.of((Object)code, (Object)title);
    }

    @Override
    public Pair<String, String> formUploadValue(Map<String, Object> formDataMap, FormFieldPO formFieldVO) {
        String extValue;
        String dataVal;
        String widgetName = formFieldVO.getWidgetName();
        Object uploadValue = formDataMap.get(widgetName);
        if (uploadValue != null) {
            if (uploadValue instanceof JSONArray) {
                JSONArray uploadValues = (JSONArray)uploadValue;
                if (CollectionUtil.isEmpty((Collection)uploadValues)) {
                    dataVal = formFieldVO.defaultValue();
                    extValue = "{}";
                } else {
                    ArrayList values = Lists.newArrayList();
                    ArrayList extValues = Lists.newArrayList();
                    for (Object itemUploadVal : uploadValues) {
                        JSONObject value = (JSONObject)itemUploadVal;
                        values.add(value.getString("attrId"));
                        extValues.add(value);
                    }
                    dataVal = JSON.toJSONString((Object)values);
                    extValue = JSON.toJSONString((Object)extValues);
                }
            } else {
                JSONObject itemUploadVal = (JSONObject)uploadValue;
                dataVal = itemUploadVal.getString("attrId");
                extValue = JSON.toJSONString((Object)uploadValue);
            }
        } else {
            dataVal = formFieldVO.defaultValue();
            extValue = "{}";
        }
        return Pair.of((Object)dataVal, (Object)extValue);
    }

    public BillItemLogicImpl(ToaFormService formService, FormFieldService formFieldService, FormTableService formTableService, BillDataJsonLogic billDataJsonLogic) {
        this.formService = formService;
        this.formFieldService = formFieldService;
        this.formTableService = formTableService;
        this.billDataJsonLogic = billDataJsonLogic;
    }
}

