/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.jingtong.base.infra.entity.BaseEntity;
import com.jingtong.bpm.infra.entity.BillBizDataEntity;
import com.jingtong.bpm.infra.entity.BillDataJsonEntity;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.infra.entity.FormDesingerEntity;
import com.jingtong.bpm.infra.entity.FormFieldEntity;
import com.jingtong.bpm.infra.entity.FormSettingEntity;
import com.jingtong.bpm.infra.entity.FormValidationEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeApproverEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.po.BillApprovalHistoryPO;
import com.jingtong.bpm.infra.po.BillItemPO;
import com.jingtong.bpm.infra.po.FormFieldPO;
import com.jingtong.bpm.infra.po.ProcessDetailPO;
import com.jingtong.bpm.infra.service.BillBizDataService;
import com.jingtong.bpm.infra.service.BillDataJsonService;
import com.jingtong.bpm.infra.service.BillReadRecordService;
import com.jingtong.bpm.infra.service.BillTaskService;
import com.jingtong.bpm.infra.service.FormDesingerService;
import com.jingtong.bpm.infra.service.FormFieldService;
import com.jingtong.bpm.infra.service.FormSettingService;
import com.jingtong.bpm.infra.service.FormValidationService;
import com.jingtong.bpm.infra.service.ProcessNodeApproverService;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.infra.service.ProcessNodeFormFieldService;
import com.jingtong.bpm.infra.service.SerialNumberLogic;
import com.jingtong.bpm.infra.service.ToaBillService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.BillStatus;
import com.jingtong.bpm.logic.constant.BillTaskStatus;
import com.jingtong.bpm.logic.constant.BillTaskType;
import com.jingtong.bpm.logic.constant.BizType;
import com.jingtong.bpm.logic.constant.CountersignType;
import com.jingtong.bpm.logic.constant.FastJsonType;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.constant.ProcessCode;
import com.jingtong.bpm.logic.context.BillDataContext;
import com.jingtong.bpm.logic.converts.BillBasicConvert;
import com.jingtong.bpm.logic.converts.FormBasicConvert;
import com.jingtong.bpm.logic.define.FormXtype;
import com.jingtong.bpm.logic.dto.BillActionParamDTO;
import com.jingtong.bpm.logic.dto.ProcessDetailDTO;
import com.jingtong.bpm.logic.dto.UserInfoDTO;
import com.jingtong.bpm.logic.dto.UserOrgDTO;
import com.jingtong.bpm.logic.dto.ValidationResultDTO;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.event.BillAgreeEvent;
import com.jingtong.bpm.logic.event.BillRepulseEvent;
import com.jingtong.bpm.logic.query.list.ApprovedBillQuery;
import com.jingtong.bpm.logic.query.list.CcBillQuery;
import com.jingtong.bpm.logic.query.list.DraftBillQuery;
import com.jingtong.bpm.logic.query.list.MeCreateBillQuery;
import com.jingtong.bpm.logic.query.list.TodoBillQuery;
import com.jingtong.bpm.logic.service.BillBpmnLogic;
import com.jingtong.bpm.logic.service.BillBtnLogic;
import com.jingtong.bpm.logic.service.BillDataJsonLogic;
import com.jingtong.bpm.logic.service.BillItemLogic;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.service.BillTitleLogic;
import com.jingtong.bpm.logic.service.BillValidationLogic;
import com.jingtong.bpm.logic.service.CallBackLogic;
import com.jingtong.bpm.logic.service.FlowMsgLogic;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.bpm.logic.service.impl.CallBackThreadPoolManager;
import com.jingtong.bpm.logic.util.DateToStringUtil;
import com.jingtong.bpm.logic.vo.BillApprovalHistoryVO;
import com.jingtong.bpm.logic.vo.BillAssociatedVO;
import com.jingtong.bpm.logic.vo.BillDetailVO;
import com.jingtong.bpm.logic.vo.BillItemVO;
import com.jingtong.bpm.logic.vo.BillOpinionVO;
import com.jingtong.bpm.logic.vo.CountersignVO;
import com.jingtong.bpm.logic.vo.FormFieldVO;
import com.jingtong.bpm.logic.vo.FormPermissionVO;
import com.jingtong.config.SpringContextHolder;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.bean.BeanUtil;
import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.ErrorCode;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillLogicImpl
implements BillLogic {
    private static final Logger log = LoggerFactory.getLogger(BillLogicImpl.class);
    private final ToaProcessService processService;
    private final ProcessNodeExtendService nodeExtendService;
    private final FormDesingerService formDesingerService;
    private final ProcessNodeFormFieldService nodeFieldPermission;
    private final FormFieldService formFieldService;
    private final UserCenterlogic userCenterlogic;
    private final BillBtnLogic billBtnLogic;
    private final ToaBillService billService;
    private final BillDataJsonService billDataJsonService;
    private final BillTaskService billTaskService;
    private final BillReadRecordService billReadRecordService;
    private final BillBizDataService billBizDataService;
    private final BillBpmnLogic billBpmnLogic;
    private final BillDataJsonLogic billDataJsonLogic;
    private final BillItemLogic billItemLogic;
    private final EventBus eventBus;
    private final ProcessNodeApproverService nodeApproverService;
    private final LoginUserHolder loginUserHolder;
    private final FlowMsgLogic flowMsgLogic;
    private final BillTitleLogic billTitleLogic;
    private final SerialNumberLogic serialNumberLogic;
    private final FormValidationService formValidationService;
    private final FormSettingService formSettingService;
    private final CallBackLogic callBackLogic;
    private final FormBasicConvert formBasicConvert;
    private final BillBasicConvert billBasicConvert;

    @Override
    public BillDetailVO create(long processId) {
        ProcessDetailDTO process = this.checkProcess(processId);
        FormDesingerEntity formDesinger = this.formDesingerService.getByProcessId(processId);
        ArrayList opinionVOS = Lists.newArrayList();
        String firstNodeId = "";
        List<ProcessNodeExtendEntity> taskNodes = this.nodeExtendService.findTaskNodeByProcess(processId);
        if (CollectionUtil.isNotEmpty(taskNodes)) {
            for (ProcessNodeExtendEntity taskNode : taskNodes) {
                String linkType = taskNode.getLinkType();
                if (org.apache.commons.codec.binary.StringUtils.equals((CharSequence)linkType, (CharSequence)NodeLinkType.create.name())) {
                    firstNodeId = taskNode.getNodeId();
                    continue;
                }
                if (!org.apache.commons.codec.binary.StringUtils.equals((CharSequence)linkType, (CharSequence)NodeLinkType.approvl.name())) continue;
                BillOpinionVO billOpinionVO = new BillOpinionVO();
                billOpinionVO.setTitle(taskNode.getNodeName());
                opinionVOS.add(billOpinionVO);
            }
        }
        List<FormPermissionVO> permissionVOS = this.formBasicConvert.formPermissionPOtoVO(this.nodeFieldPermission.nodeFieldPermission(processId, firstNodeId));
        ToaProcessEntity byId = (ToaProcessEntity)((Object)this.processService.getById(Long.valueOf(processId)));
        String code = DateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmm") + RandomUtil.randomNumbers((int)6);
        UserInfoDTO userInfoByCode = this.userCenterlogic.getUserInfoByCode(this.loginUserHolder.getUserCode());
        String title = this.billTitleLogic.getTitle(processId, userInfoByCode.getNickname());
        Map<String, Object> formData = this.bizFormData(process, userInfoByCode, title);
        List<String> btns = this.billBtnLogic.findBtnsOnCreateBill(process);
        return BillDetailVO.builder().title(title).code(code).form(formDesinger.getDesingerJson()).formData(formData).processId(processId).opinions(opinionVOS).permission(permissionVOS).btns(btns).mode("create").build();
    }

    @Override
    public BillDetailVO findBillDetail(long billId, String page) {
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException("", (ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        BillDataJsonEntity billDataJson = (BillDataJsonEntity)((Object)this.billDataJsonService.getOne((Wrapper)Wrappers.lambdaQuery(BillDataJsonEntity.class).eq(BillDataJsonEntity::getBillId, (Object)billId)));
        if (null == billDataJson) {
            throw new RbException("", (ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        BillDetailVO.BillDetailVOBuilder<String> detailBuilder = this.billDetailBuilder(billDataJson, bill);
        FormSettingEntity byProcess = this.formSettingService.findByProcess(bill.getProcessId());
        if (!Objects.isNull((Object)byProcess)) {
            if (!Strings.isNullOrEmpty((String)byProcess.getApproveLink())) {
                detailBuilder.approveLink(byProcess.getApproveLink().trim());
            }
            if (!Objects.isNull(byProcess.getApproveFormHeight())) {
                detailBuilder.approveFormHeight(byProcess.getApproveFormHeight());
            }
        }
        detailBuilder.selfTaskNames(this.getSelfNodeName(billId, this.loginUserHolder.getUserCode(), page));
        List<BillOpinionVO> opinionVOS = this.billOpinions(bill);
        String formSchema = billDataJson.getFormSchema();
        return detailBuilder.form(formSchema).opinions(opinionVOS).title(bill.getTitle()).code(bill.getCode()).mode("edit").build();
    }

    private Set<String> getSelfNodeName(long billId, String user, String page) {
        if (page.equals("view")) {
            List<BillTaskEntity> billTaskEntities = this.billTaskService.findApprovedByBillAndUser(billId, user);
            Set<String> nodeNames = billTaskEntities.stream().map(BillTaskEntity::getNodeName).collect(Collectors.toSet());
            return nodeNames;
        }
        List<BillTaskEntity> billTaskEntities = this.billTaskService.findApprovingByBillAndUser(billId, user);
        Set<String> nodeNames = billTaskEntities.stream().map(BillTaskEntity::getNodeName).collect(Collectors.toSet());
        return nodeNames;
    }

    @Override
    public BillDetailVO findBillDetailModeView(long billId, String page) {
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException("", (ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        BillDataJsonEntity billDataJson = (BillDataJsonEntity)((Object)this.billDataJsonService.getOne((Wrapper)Wrappers.lambdaQuery(BillDataJsonEntity.class).eq(BillDataJsonEntity::getBillId, (Object)billId)));
        if (null == billDataJson) {
            throw new RbException("", (ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        BillDetailVO.BillDetailVOBuilder<String> detailBuilder = this.billDetailBuilder(billDataJson, bill, page);
        FormSettingEntity byProcess = this.formSettingService.findByProcess(bill.getProcessId());
        if (!Objects.isNull((Object)byProcess)) {
            if (!Strings.isNullOrEmpty((String)byProcess.getApproveLink())) {
                detailBuilder.approveLink(byProcess.getApproveLink().trim());
            }
            if (!Objects.isNull(byProcess.getApproveFormHeight())) {
                detailBuilder.approveFormHeight(byProcess.getApproveFormHeight());
            }
        }
        detailBuilder.selfTaskNames(this.getSelfNodeName(billId, this.loginUserHolder.getUserCode(), page));
        List<BillOpinionVO> opinionVOS = this.billOpinions(bill);
        String formSchema = billDataJson.getFormSchema();
        return detailBuilder.form(formSchema).code(bill.getCode()).opinions(opinionVOS).mode("view").build();
    }

    @Override
    public boolean readBill(long billId) {
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException((ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        String userCode = this.loginUserHolder.getUserCode();
        String sender = bill.getSender();
        return sender.equals(userCode) || this.billReadRecordService.readBillByUserCode(billId, userCode);
    }

    @Override
    public BillItemVO saveDrafts(long processId, long billId, String formDataJson) {
        boolean state;
        ToaBillEntity bill;
        Preconditions.checkNotNull((Object)formDataJson);
        ProcessDetailPO processDetail = this.processService.findDetailById(processId);
        Map dataMap = (Map)JSON.parseObject((String)formDataJson, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        BillDataContext billDataValue = this.resolveFormData(billId, processDetail, dataMap);
        String userCode = this.loginUserHolder.getUserCode();
        UserInfoDTO userInfoByCode = this.userCenterlogic.getUserInfoByCode(userCode);
        if (billId <= 0L) {
            bill = this.createBill(processDetail, BillStatus.DRAFTS, billDataValue, userInfoByCode);
            bill.setStartTime(DateTimeUtil.unixTime());
            state = this.billService.insert(bill);
        } else {
            bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
            if (bill.getStatus().intValue() != BillStatus.DRAFTS.getStatus()) {
                throw new RbException((ErrorCode)BillCode.BILL_NOT_IN_DRAFTS);
            }
            bill.setStartTime(DateTimeUtil.unixTime());
            bill.setAttachmentFlag(billDataValue.isAttachment() ? 1 : 0);
            bill.setUpdateTime(LocalDateTime.now());
            state = this.billService.updateById((Object)bill);
        }
        if (state) {
            this.billDataJsonLogic.saveByBillData(billDataValue, formDataJson);
            this.billBizDataService.saveByBillData(billDataValue);
        }
        return BillItemVO.toVO(bill, processDetail);
    }

    @Override
    public Pair<List<BillItemVO>, Long> findApproved(Integer pageNo, Integer pageSize, ApprovedBillQuery query) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String userCode = this.loginUserHolder.getUserCode();
        List<BillItemPO> billItemDtos = this.billService.findApprovedByEmployee(page, userCode, query);
        Page<BillItemVO> billItemVOPage = this.toItemVOList(page, billItemDtos, userCode);
        return Pair.of((Object)billItemVOPage.getRecords(), (Object)billItemVOPage.getTotal());
    }

    @Override
    public Pair<List<BillItemVO>, Long> findTodo(Integer pageNo, Integer pageSize, TodoBillQuery query) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{BillStatus.APPROVAL.getStatus(), BillStatus.REFUSE.getStatus()});
        String userCode = this.loginUserHolder.getUserCode();
        List<BillItemPO> billDatas = this.billService.findTodoByStatus(page, userCode, query, statusList);
        Page<BillItemVO> billItemVOPage = this.toItemVOList(page, billDatas, userCode);
        return Pair.of((Object)billItemVOPage.getRecords(), (Object)billItemVOPage.getTotal());
    }

    @Override
    public Pair<List<BillItemVO>, Long> findMeCreate(Integer pageNo, Integer pageSize, MeCreateBillQuery query) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String userCode = this.loginUserHolder.getUserCode();
        List<BillItemPO> billDatas = this.billService.findCreateByEmployee(page, userCode, query);
        Page<BillItemVO> billItemVOPage = this.toItemVOList(page, billDatas, userCode);
        return Pair.of((Object)billItemVOPage.getRecords(), (Object)billItemVOPage.getTotal());
    }

    @Override
    public Pair<List<BillItemVO>, Long> findDraft(Integer pageNo, Integer pageSize, DraftBillQuery query) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String userCode = this.loginUserHolder.getUserCode();
        List<BillItemPO> billDatas = this.billService.findDraftsBySender(page, userCode, query);
        Page<BillItemVO> billItemVOPage = this.toItemVOList(page, billDatas, userCode);
        return Pair.of((Object)billItemVOPage.getRecords(), (Object)billItemVOPage.getTotal());
    }

    @Override
    public Pair<List<BillItemVO>, Long> findCc(Integer pageNo, Integer pageSize, CcBillQuery query) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String userCode = this.loginUserHolder.getUserCode();
        List<BillItemPO> cc = this.billService.findCc(page, userCode, query);
        Page<BillItemVO> billItemVOPage = this.toItemVOList(page, cc, userCode);
        return Pair.of((Object)billItemVOPage.getRecords(), (Object)billItemVOPage.getTotal());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BillItemVO startFlow(long processId, long billId, String formDataJson, String nextApprover, String billCode) {
        Optional<ProcessInstance> processInstanceOpt;
        BillTaskEntity createTaskByBill;
        ToaBillEntity bill;
        ValidationResultDTO validationResult;
        Preconditions.checkNotNull((Object)formDataJson);
        ProcessDetailPO processDetail = this.processService.findDetailById(processId);
        Map dataMap = (Map)JSON.parseObject((String)formDataJson, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        String userCode = this.loginUserHolder.getUserCode();
        UserInfoDTO userInfoDTO = this.userCenterlogic.getUserInfoByCode(userCode);
        BillDataContext billDataValue = this.resolveFormData(billId, processDetail, dataMap);
        if (!Strings.isNullOrEmpty((String)billCode)) {
            billDataValue.setCode(billCode);
        }
        if ((validationResult = this.validationBySubmitFlow(processDetail, billDataValue, userCode)) != null && !validationResult.getAllowGoOnFlag().booleanValue()) {
            throw new RbException(validationResult.getTipMessage(), (ErrorCode)BillCode.START_FLOW_ERROR);
        }
        if (billId <= 0L) {
            bill = this.createBill(processDetail, BillStatus.APPROVAL, billDataValue, userInfoDTO);
            this.billService.insert(bill);
        } else {
            bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
            Integer billStatus = bill.getStatus();
            BillStatus status = BillStatus.valueTo(billStatus);
            switch (status) {
                case ARCHIVE: 
                case COMPLETE: {
                    throw new RbException((ErrorCode)BillCode.BILL_HAS_COMPLETE);
                }
                case APPROVAL: {
                    throw new RbException((ErrorCode)BillCode.Bill_APPROVAL_IN);
                }
            }
            String title = billDataValue.getTitle();
            String code = billDataValue.getCode();
            if (Strings.isNullOrEmpty((String)title)) {
                String day = DateToStringUtil.yyyymmdashNow();
                String processName = processDetail.getName();
                String username = userInfoDTO.getNickname();
                String titleText = StrUtil.format((CharSequence)"{}-{}-{}", (Object[])new Object[]{processName, username, day});
                bill.setTitle(titleText);
            } else {
                bill.setTitle(title);
            }
            if (!Strings.isNullOrEmpty((String)code)) {
                bill.setCode(code);
            } else {
                String billCodeText = this.serialNumberLogic.dayPolling("bill_default_sn", 6);
                String codeText = StrUtil.format((CharSequence)"{}", (Object[])new Object[]{billCodeText});
                bill.setCode(codeText);
            }
        }
        if (billId > 0L && !Objects.isNull((Object)(createTaskByBill = this.billTaskService.findCreateTaskByBill(billId)))) {
            createTaskByBill.setDateline(DateTimeUtil.unixTime());
            Long sourceTaskId = createTaskByBill.getSourceTaskId();
            if (!Objects.isNull(sourceTaskId) && sourceTaskId.compareTo(0L) != 0) {
                BillTaskEntity byId = (BillTaskEntity)((Object)this.billTaskService.getById(sourceTaskId));
                String taskId = byId.getTaskId();
                List<BillTaskEntity> approvingByBillAndTaskId = this.billTaskService.findApprovingByBillAndTaskId(billId, taskId);
                for (BillTaskEntity billTaskEntity : approvingByBillAndTaskId) {
                    billTaskEntity.setSort(DateTimeUtil.timeMills());
                }
                approvingByBillAndTaskId.add(createTaskByBill);
                byId.setId(null);
                byId.setOpinion(null);
                byId.setNodeStatus(BillTaskStatus.APPROVAL.getStatus());
                byId.setSort(DateTimeUtil.timeMills());
                this.billTaskService.insert(byId);
                if (CollectionUtil.isNotEmpty(approvingByBillAndTaskId)) {
                    this.billTaskService.updateBatchById(approvingByBillAndTaskId);
                }
                bill.setStatus(BillStatus.APPROVAL.getStatus());
                boolean state = this.billService.upldate(bill);
                if (state) {
                    this.billDataJsonLogic.saveByBillData(billDataValue, formDataJson);
                    this.billBizDataService.saveByBillData(billDataValue);
                }
                return BillItemVO.toVO(bill, processDetail);
            }
        }
        if ((processInstanceOpt = this.billBpmnLogic.startFlow(billDataValue, processDetail, userInfoDTO, nextApprover)).isPresent()) {
            boolean state;
            ProcessInstance processInstance = (ProcessInstance)processInstanceOpt.get();
            LocalDateTime now = LocalDateTime.now();
            int unixTime = DateTimeUtil.unixTime();
            if (billId <= 0L) {
                bill.setProcessInstanceId(processInstance.getId());
                bill.setStartTime(unixTime);
                state = this.billService.updateById((Object)bill);
            } else {
                int status = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)-1);
                BillStatus billStatus = BillStatus.valueTo(status);
                switch (billStatus) {
                    case DRAFTS: {
                        bill.setAttachmentFlag(billDataValue.isAttachment() ? 1 : 0);
                        bill.setProcessInstanceId(processInstance.getId());
                        bill.setUpdateTime(now);
                        bill.setStatus(BillStatus.APPROVAL.getStatus());
                        bill.setStartTime(unixTime);
                        state = this.billService.updateById((Object)bill);
                        break;
                    }
                    case REFUSE: 
                    case CANCEL: {
                        bill.setAttachmentFlag(billDataValue.isAttachment() ? 1 : 0);
                        bill.setProcessInstanceId(processInstance.getId());
                        bill.setUpdateTime(now);
                        bill.setStatus(BillStatus.APPROVAL.getStatus());
                        state = this.billService.updateById((Object)bill);
                        this.billTaskService.updateByReFullIn(billId, userInfoDTO.getCode());
                        break;
                    }
                    default: {
                        throw new RbException((ErrorCode)BillCode.BILL_NOT_IN_DRAFTS);
                    }
                }
            }
            if (state) {
                this.billDataJsonLogic.saveByBillData(billDataValue, formDataJson);
                this.billBizDataService.saveByBillData(billDataValue);
            }
            return BillItemVO.toVO(bill, processDetail);
        }
        throw new RbException((ErrorCode)BillCode.START_FLOW_ERROR);
    }

    private ValidationResultDTO validationBySubmitFlow(ProcessDetailPO processDetail, BillDataContext billDataValue, String userCode) {
        BillValidationLogic validationService = this.getValidationService(processDetail.getId());
        return this.validataionWithResult(billDataValue, userCode, validationService);
    }

    @Override
    public BillItemVO sendProcess(long billId, long processId, String nextApprover) {
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException((ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        BillDataJsonEntity billDataJson = (BillDataJsonEntity)((Object)this.billDataJsonService.getOne((Wrapper)Wrappers.lambdaQuery(BillDataJsonEntity.class).eq(BillDataJsonEntity::getBillId, (Object)billId)));
        String formData = billDataJson.getFormData();
        return this.startFlow(processId, billId, formData, nextApprover, "");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void agreeFlow(BillActionParamDTO actionParam) {
        long billId = actionParam.getBillId();
        String taskId = actionParam.getTaskId();
        String opinion = actionParam.getOpinion();
        String userCode = actionParam.getUserCode();
        String nextApprover = actionParam.getNextApprover();
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException((ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        int status = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)0);
        BillStatus billStatus = BillStatus.valueTo(status);
        block0 : switch (billStatus) {
            case REFUSE: {
                BillAgreeEvent billAgreeEvent = new BillAgreeEvent();
                billAgreeEvent.setBillId(billId);
                this.eventBus.post((Object)billAgreeEvent);
            }
            case APPROVAL: {
                Optional<BillTaskEntity> taskOpt = this.billBpmnLogic.findTaskBybillAndEmployeeAndTaskId(billId, taskId, userCode);
                if (taskOpt.isPresent()) {
                    BillTaskEntity billTask = (BillTaskEntity)((Object)taskOpt.get());
                    int nodeStatus = billTask.getNodeStatus();
                    BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(nodeStatus);
                    Integer taskType = billTask.getTaskType();
                    BillTaskType billTaskType = BillTaskType.forValue(taskType);
                    switch (billTaskType) {
                        case TRANSFER: 
                        case TURN: 
                        case DEFAULT: {
                            switch (billTaskStatus) {
                                case APPROVAL: {
                                    boolean goFlag = this.agreeIsGoOn(billTask);
                                    this.flowMsgLogic.sendMsg(Lists.newArrayList((Object[])new BillTaskEntity[]{billTask}));
                                    if (goFlag) {
                                        this.billTaskService.agreeTask(billTask, userCode, actionParam);
                                        this.billItemLogic.updateByFormDataByBill(billId, actionParam.getFormData());
                                        this.billBpmnLogic.complete(bill, taskId, opinion, userCode, nextApprover, actionParam.getFormData(), billTask.getTaskNodeKey(), billTask.getTaskId());
                                        this.billTaskService.deleteApproval(billTask.getBillId(), billTask.getTaskId(), BillTaskStatus.APPROVAL.getStatus());
                                        break block0;
                                    }
                                    this.billTaskService.agreeTask(billTask, userCode, actionParam);
                                    break block0;
                                }
                                case AGREE: 
                                case REFUSE: {
                                    throw new RbException((ErrorCode)BillCode.BILL_TASK_HAS_APPROVED);
                                }
                            }
                            throw new RbException((ErrorCode)BillCode.BILL_TASK_NOT_APPROVAL);
                        }
                        case ENDORSE: {
                            switch (billTaskStatus) {
                                case APPROVAL: {
                                    List<BillTaskEntity> billTaskEntities = this.billTaskService.findEndorseByUserAndTaskId(billId, taskId, userCode);
                                    ArrayList updates = Lists.newArrayList();
                                    ArrayList inserts = Lists.newArrayList();
                                    for (BillTaskEntity billTaskEntity : billTaskEntities) {
                                        BillTaskEntity newBillTask = (BillTaskEntity)((Object)BeanUtil.sourceToTarget((Object)((Object)billTask), BillTaskEntity.class));
                                        billTaskEntity.setNodeStatus(BillTaskStatus.AGREE.getStatus());
                                        billTaskEntity.setDateline(DateTimeUtil.unixTime());
                                        billTaskEntity.setUpdateTime(LocalDateTime.now());
                                        billTaskEntity.setOpinion(actionParam.getOpinion());
                                        updates.add(billTaskEntity);
                                        newBillTask.setId(IdWorker.getId());
                                        newBillTask.setUserCode(billTaskEntity.getSourceUserCode());
                                        newBillTask.setTaskType(BillTaskType.DEFAULT.getValue());
                                        newBillTask.setSourceTaskId(null);
                                        newBillTask.setSourceUserCode(null);
                                        newBillTask.setSort(DateTimeUtil.timeMills());
                                        newBillTask.setCreationTime(LocalDateTime.now());
                                        inserts.add(newBillTask);
                                    }
                                    if (CollectionUtil.isNotEmpty((Collection)updates)) {
                                        this.billTaskService.updateBatchById(updates);
                                    }
                                    if (CollectionUtil.isNotEmpty((Collection)inserts)) {
                                        this.billTaskService.saveBatch(inserts);
                                    }
                                    ArrayList sends = Lists.newArrayList();
                                    sends.addAll(updates);
                                    sends.addAll(inserts);
                                    this.flowMsgLogic.sendMsg(sends);
                                    break block0;
                                }
                                case AGREE: 
                                case REFUSE: {
                                    throw new RbException((ErrorCode)BillCode.BILL_TASK_HAS_APPROVED);
                                }
                            }
                            throw new RbException((ErrorCode)BillCode.BILL_TASK_NOT_APPROVAL);
                        }
                    }
                    break;
                }
                throw new RbException((ErrorCode)BillCode.TASK_NOT_FOUND);
            }
            case CANCEL: {
                throw new RbException((ErrorCode)BillCode.BILL_CANCEL_ONAGREE);
            }
            default: {
                throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refuseFlow(BillActionParamDTO actionParam) {
        long billId = actionParam.getBillId();
        String taskId = actionParam.getTaskId();
        String opinion = actionParam.getOpinion();
        String userCode = actionParam.getUserCode();
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException((ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        int status = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)0);
        BillStatus billStatus = BillStatus.valueTo(status);
        block0 : switch (billStatus) {
            case APPROVAL: {
                Optional<BillTaskEntity> taskOpt = this.billBpmnLogic.findTaskBybillAndEmployeeAndTaskId(billId, taskId, userCode);
                if (taskOpt.isPresent()) {
                    BillTaskEntity task = (BillTaskEntity)((Object)taskOpt.get());
                    int taskNodeStatus = task.getNodeStatus();
                    BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(taskNodeStatus);
                    switch (billTaskStatus) {
                        case APPROVAL: {
                            this.refuseApproval(taskId, opinion, bill, userCode, task);
                            String formData = actionParam.getFormData();
                            if (!Strings.isNullOrEmpty((String)formData) && !StringUtils.equals((CharSequence)"{}", (CharSequence)formData)) {
                                this.billItemLogic.updateByFormDataByBill(billId, formData);
                            }
                            this.billTaskService.deleteApproval(task.getBillId(), task.getTaskId(), BillTaskStatus.APPROVAL.getStatus());
                            break block0;
                        }
                        case AGREE: 
                        case REFUSE: {
                            throw new RbException((ErrorCode)BillCode.BILL_TASK_HAS_APPROVED);
                        }
                    }
                    throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
                }
                throw new RbException("", (ErrorCode)ProcessCode.PROCESS_ACTIVITI_ERROR);
            }
            case ARCHIVE: {
                throw new RbException((ErrorCode)BillCode.ARCHIVE_STATUS_REFUSE);
            }
            default: {
                throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complete(final long billId, final String action) {
        final ToaBillEntity bill = new ToaBillEntity();
        int dateline = DateTimeUtil.unixTime();
        bill.setId(billId);
        bill.setCompletionTime(dateline);
        bill.setStatus(BillStatus.COMPLETE.getStatus());
        bill.setArchivedTime(dateline);
        TimerTask businessTask = new TimerTask(){

            @Override
            public void run() {
                ToaBillEntity byId = (ToaBillEntity)((Object)BillLogicImpl.this.billService.getById(Long.valueOf(billId)));
                BillLogicImpl.this.billService.upldate(bill);
                if (action.equals(BillAction.refuse.name())) {
                    BillLogicImpl.this.callBackLogic.callBack(byId.getProcessId(), billId, BillTaskStatus.REFUSE.getStatus());
                } else {
                    BillLogicImpl.this.callBackLogic.callBack(byId.getProcessId(), billId, BillStatus.COMPLETE.getStatus());
                }
            }
        };
        CallBackThreadPoolManager.me().executeLog(businessTask);
    }

    @Override
    public List<BillApprovalHistoryVO> findBillApprovalHistory(long billId) {
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException((ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        List<BillApprovalHistoryPO> byBill = this.billTaskService.findByBill(bill);
        Set<String> userCodes = byBill.stream().map(BillApprovalHistoryPO::getUserCode).collect(Collectors.toSet());
        Set userCodes1 = byBill.stream().map(BillApprovalHistoryPO::getSourceUserCode).collect(Collectors.toSet());
        Set userCodes2 = byBill.stream().map(BillApprovalHistoryPO::getTargetUserCode).collect(Collectors.toSet());
        userCodes.addAll(userCodes1);
        userCodes.addAll(userCodes2);
        List<UserInfoDTO> userInfoDTOS = this.userCenterlogic.getUserByCodes(userCodes);
        if (CollectionUtil.isNotEmpty(userInfoDTOS)) {
            Map<String, String> codeNameMap = userInfoDTOS.stream().collect(Collectors.toMap(UserInfoDTO::getCode, UserInfoDTO::getNickname));
            for (BillApprovalHistoryPO billApprovalHistoryPO : byBill) {
                String targetUserCode;
                String userCode = billApprovalHistoryPO.getUserCode();
                String name = codeNameMap.get(userCode);
                billApprovalHistoryPO.setUserName(name);
                String sourceUserCode = billApprovalHistoryPO.getSourceUserCode();
                if (!Strings.isNullOrEmpty((String)sourceUserCode)) {
                    billApprovalHistoryPO.setSourceUserName(codeNameMap.get(sourceUserCode));
                }
                if (!Strings.isNullOrEmpty((String)(targetUserCode = billApprovalHistoryPO.getTargetUserCode()))) {
                    billApprovalHistoryPO.setTargetUserName(codeNameMap.get(targetUserCode));
                }
                if (billApprovalHistoryPO.getTaskType().compareTo(BillTaskType.SKIP.getValue()) != 0) continue;
                billApprovalHistoryPO.setUserName("\u81ea\u52a8\u8df3\u8fc7");
            }
        }
        List<BillApprovalHistoryPO> result = byBill.stream().sorted(Comparator.comparing(BillApprovalHistoryPO::getSort, (x, y) -> {
            if (x <= y) {
                return -1;
            }
            return 1;
        })).collect(Collectors.toList());
        return this.billBasicConvert.billApprovalHistoryPOToVO(result);
    }

    @Override
    public void recallFlow(BillActionParamDTO actionParam) {
        long billId = actionParam.getBillId();
        String taskId = actionParam.getTaskId();
        String opinion = actionParam.getOpinion();
        String userCode = actionParam.getUserCode();
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        if (bill == null) {
            throw new RbException((ErrorCode)BillCode.BILL_NOT_FOUND);
        }
        if (bill.getStatus().intValue() != BillStatus.APPROVAL.getStatus()) {
            throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
        }
        this.billBpmnLogic.recall(bill, taskId, opinion, userCode);
    }

    private void refuseApproval(String taskId, String opinion, ToaBillEntity bill, String userCode, BillTaskEntity task) {
        Long processId = bill.getProcessId();
        String taskNodeKey = task.getTaskNodeKey();
        Optional<ProcessNodeExtendEntity> nodeExtendOpt = this.nodeExtendService.findByNodeIdAndProcessId(processId, taskNodeKey);
        if (nodeExtendOpt.isPresent()) {
            ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOpt.get());
            String linkType = nodeExtend.getLinkType();
            NodeLinkType nodeLinkType = NodeLinkType.valueOf(linkType);
            switch (nodeLinkType) {
                case submit: {
                    throw new RbException((ErrorCode)BillCode.SUMIT_STATUS_REFUSE);
                }
                case create: {
                    throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
                }
                case archive: {
                    throw new RbException((ErrorCode)BillCode.ARCHIVE_STATUS_REFUSE);
                }
                case approvl: {
                    int dateline = DateTimeUtil.unixTime();
                    task.setNodeStatus(BillTaskStatus.REFUSE.getStatus());
                    task.setUpdateTime(LocalDateTime.now());
                    task.setOpinion(opinion);
                    task.setDateline(dateline);
                    task.setAction(BillAction.refuse.name());
                    ArrayList sends = Lists.newArrayList();
                    sends.add(task);
                    this.flowMsgLogic.sendMsg(sends);
                    this.billTaskService.updateById((Object)task);
                    this.billReadRecordService.deleteByBillAndEmployeeId(bill.getId(), userCode);
                    this.billBpmnLogic.refuse(bill, taskId, opinion, userCode);
                    break;
                }
            }
        } else {
            throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
        }
    }

    @Override
    public boolean agreeIsGoOn(BillTaskEntity billTask) {
        Long id = billTask.getId();
        String taskId = billTask.getTaskId();
        Long billId = billTask.getBillId();
        Long nodeApproverId = billTask.getNodeApproverId();
        ProcessNodeApproverEntity nodeApprover = (ProcessNodeApproverEntity)((Object)this.nodeApproverService.getById(nodeApproverId));
        if (Objects.isNull((Object)nodeApprover)) {
            BigDecimal val4;
            BigDecimal val2;
            int percentage = 100;
            int countActive = this.billTaskService.findActiveExcludeSelf(billId, taskId, id);
            int total = this.billTaskService.findTotalCount(billId, taskId, billTask.getTaskType());
            BigDecimal val1 = BigDecimal.valueOf(countActive + 1);
            BigDecimal val3 = val1.divide(val2 = BigDecimal.valueOf(total), 4, 1).multiply(BigDecimal.valueOf(100L));
            return val3.compareTo(val4 = BigDecimal.valueOf(100L)) >= 0;
        }
        String countersign = nodeApprover.getCountersign();
        CountersignVO countersignVO = (CountersignVO)JSON.parseObject((String)countersign, CountersignVO.class);
        if (CountersignType.ONE_PASS.getVal() == countersignVO.getType()) {
            return true;
        }
        if (CountersignType.ONE_REJECT.getVal() == countersignVO.getType()) {
            int countActive = this.billTaskService.findActiveExcludeSelf(billId, taskId, id);
            return countActive == 0;
        }
        if (CountersignType.COUNT_PASS.getVal() == countersignVO.getType()) {
            int count = countersignVO.getCount();
            int countActive = this.billTaskService.findActiveExcludeSelf(billId, taskId, id);
            return countActive + 1 >= count;
        }
        if (CountersignType.PERCENTAGE_PASS.getVal() == countersignVO.getType()) {
            BigDecimal val4;
            BigDecimal val2;
            int percentage = countersignVO.getCount();
            int countActive = this.billTaskService.findActiveExcludeSelf(billId, taskId, id);
            int total = this.billTaskService.findTotalCount(billId, taskId, billTask.getTaskType());
            BigDecimal val1 = BigDecimal.valueOf(countActive + 1);
            BigDecimal val3 = val1.divide(val2 = BigDecimal.valueOf(total), 4, 1).multiply(BigDecimal.valueOf(100L));
            return val3.compareTo(val4 = BigDecimal.valueOf(percentage)) >= 0;
        }
        return false;
    }

    private Page<BillItemVO> toItemVOList(Page page, List<BillItemPO> billDatas, String userCode) {
        Page resultPage = new Page(page.getCurrent(), page.getSize());
        resultPage.setTotal(page.getTotal());
        if (CollectionUtil.isNotEmpty(billDatas)) {
            Set<String> userCodes = billDatas.stream().map(BillItemPO::getSender).collect(Collectors.toSet());
            List<UserInfoDTO> userInfoDTOS = this.userCenterlogic.getUserByCodes(userCodes);
            Map<String, String> codeNameMap = userInfoDTOS.stream().collect(Collectors.toMap(UserInfoDTO::getCode, a -> a.getNickname()));
            if (CollectionUtil.isNotEmpty(userInfoDTOS)) {
                for (BillItemPO billData : billDatas) {
                    String sender = billData.getSender();
                    String name = codeNameMap.get(sender);
                    if (Strings.isNullOrEmpty((String)name)) continue;
                    billData.setSenderName(name);
                }
            }
            ArrayList billAppItemVOS = Lists.newArrayListWithCapacity((int)billDatas.size());
            for (BillItemPO billItemDto : billDatas) {
                billAppItemVOS.add(billItemDto.toVO(userCode));
            }
            resultPage.setRecords((List)billAppItemVOS);
        }
        return resultPage;
    }

    private ToaBillEntity createBill(ProcessDetailPO processDetail, BillStatus billStatus, BillDataContext billDataValue, UserInfoDTO userInfoDTO) {
        String username;
        String processName;
        String day;
        ToaBillEntity bill = new ToaBillEntity();
        bill.setId(billDataValue.getId());
        bill.setProcessId(processDetail.getId());
        bill.setCreationTime(LocalDateTime.now());
        List<UserOrgDTO> orgs = userInfoDTO.getOrgs();
        if (CollectionUtil.isNotEmpty(orgs)) {
            bill.setDepartmentCode(orgs.get(0).getOrgCode());
        }
        bill.setAttachmentFlag(billDataValue.isAttachment() ? 1 : 0);
        String title = billDataValue.getTitle();
        String code = billDataValue.getCode();
        if (Strings.isNullOrEmpty((String)title)) {
            day = DateToStringUtil.yyyymmdashNow();
            processName = processDetail.getName();
            username = userInfoDTO.getNickname();
            String titleText = StrUtil.format((CharSequence)"{}-{}-{}", (Object[])new Object[]{processName, username, day});
            bill.setTitle(titleText);
        } else {
            bill.setTitle(title);
        }
        if (Strings.isNullOrEmpty((String)code)) {
            day = DateToStringUtil.yyyymmdashNow();
            processName = processDetail.getName();
            username = userInfoDTO.getNickname();
            String billCode = this.serialNumberLogic.dayPolling("bill_default_sn", 6);
            String codeText = StrUtil.format((CharSequence)"{}", (Object[])new Object[]{billCode});
            bill.setCode(codeText);
        } else {
            bill.setCode(code);
        }
        bill.setStatus(billStatus.getStatus());
        bill.setSender(userInfoDTO.getCode());
        return bill;
    }

    @Override
    public BillDataContext resolveFormData(long billId, ProcessDetailPO processDetail, Map<String, Object> formDataMap) {
        long newBillId;
        long processId = processDetail.getId();
        List<FormFieldPO> formFieldVOS = this.formFieldService.findVoByProcessId(processId);
        HashMap formFieldVOMap = Maps.newHashMap();
        for (FormFieldPO formFieldVO : formFieldVOS) {
            formFieldVOMap.put(formFieldVO.getWidgetName(), formFieldVO);
        }
        BillDataContext.BillDataContextBuilder dataValueBuilder = BillDataContext.builder();
        if (billId <= 0L) {
            newBillId = IdWorker.getId();
            dataValueBuilder.created(true);
        } else {
            newBillId = billId;
        }
        dataValueBuilder.id(newBillId);
        dataValueBuilder.processId(processId);
        dataValueBuilder.formDataMap(formDataMap);
        ArrayList associateds = Lists.newArrayList();
        ArrayList bizDataList = Lists.newArrayList();
        for (String widgetName : formDataMap.keySet()) {
            String fieldType;
            FormFieldPO formFieldVO = (FormFieldPO)formFieldVOMap.get(widgetName);
            if (formFieldVO == null || Strings.isNullOrEmpty((String)(fieldType = formFieldVO.getType()))) continue;
            FormXtype formXtype = FormXtype.valueOf(fieldType);
            switch (formXtype) {
                case triggerselect: {
                    Pair<List<BillAssociatedVO>, List<BillBizDataEntity>> selectVal = this.billItemLogic.formTriggerselectValue(formDataMap, formFieldVO, newBillId);
                    associateds.addAll((Collection)selectVal.getKey());
                    bizDataList.addAll((Collection)selectVal.getValue());
                    break;
                }
                case imageupload: 
                case fileupload: {
                    Pair<String, String> uploadValue = this.billItemLogic.formUploadValue(formDataMap, formFieldVO);
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)uploadValue.getKey()))) break;
                    dataValueBuilder.attachment(true);
                    break;
                }
                case biz: {
                    Pair<String, String> bizPair = this.billItemLogic.formBizValue(formDataMap, formFieldVO);
                    String code = (String)bizPair.getKey();
                    String title = (String)bizPair.getValue();
                    if (StringUtils.isNotEmpty((CharSequence)code)) {
                        dataValueBuilder.code(code);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)title)) break;
                    dataValueBuilder.title(title);
                    break;
                }
                case detailgroup: {
                    List billBizDatas;
                    List associatedList;
                    List<FormFieldPO> detailFields;
                    String detailgroupName = formFieldVO.getWidgetName();
                    JSONArray detailgroupDatas = (JSONArray)formDataMap.get(detailgroupName);
                    if (CollectionUtil.isEmpty((Collection)detailgroupDatas) || CollectionUtil.isEmpty(detailFields = formFieldVO.getDetailFields())) break;
                    Triple<Boolean, List<BillAssociatedVO>, List<BillBizDataEntity>> detailItemTriple = this.billItemLogic.detailFormFileds(newBillId, detailgroupDatas, detailFields);
                    Boolean attachment = (Boolean)detailItemTriple.getLeft();
                    if (attachment.booleanValue()) {
                        dataValueBuilder.attachment(true);
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(associatedList = (List)detailItemTriple.getMiddle()))) {
                        associateds.addAll(associatedList);
                    }
                    if (!CollectionUtil.isNotEmpty((Collection)(billBizDatas = (List)detailItemTriple.getRight()))) break;
                    bizDataList.addAll(billBizDatas);
                    break;
                }
            }
        }
        dataValueBuilder.associated(JSON.toJSONString((Object)associateds));
        dataValueBuilder.bizDataList(bizDataList);
        return dataValueBuilder.build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void endorse(BillActionParamDTO actionParam) {
        String endorseApprover = actionParam.getEndorseApprover();
        String opinion = actionParam.getOpinion();
        String taskId = actionParam.getTaskId();
        long billId = actionParam.getBillId();
        String userCode = actionParam.getUserCode();
        List<BillTaskEntity> billTaskEntities = this.billTaskService.findApprovingByBillAndTaskId(billId, taskId);
        Set collect = billTaskEntities.stream().map(BillTaskEntity::getUserCode).collect(Collectors.toSet());
        if (collect.contains(actionParam.getEndorseApprover())) {
            throw new RbException((ErrorCode)BillCode.ENDORSE_CANNOT_IN_NODE);
        }
        Optional<BillTaskEntity> taskOpt = this.billBpmnLogic.findTaskBybillAndEmployeeAndTaskId(billId, taskId, userCode);
        if (!taskOpt.isPresent()) {
            throw new RbException("", (ErrorCode)ProcessCode.PROCESS_ACTIVITI_ERROR);
        }
        BillTaskEntity task = (BillTaskEntity)((Object)taskOpt.get());
        int taskNodeStatus = task.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(taskNodeStatus);
        switch (billTaskStatus) {
            case APPROVAL: {
                String formData = actionParam.getFormData();
                if (Strings.isNullOrEmpty((String)formData) || StringUtils.equals((CharSequence)"{}", (CharSequence)formData)) break;
                this.billItemLogic.updateByFormDataByBill(billId, formData);
                break;
            }
            case AGREE: 
            case REFUSE: {
                throw new RbException((ErrorCode)BillCode.BILL_TASK_HAS_APPROVED);
            }
            default: {
                throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
            }
        }
        BillTaskEntity newBillTask = (BillTaskEntity)((Object)BeanUtil.sourceToTarget((Object)((Object)task), BillTaskEntity.class));
        task.setNodeStatus(BillTaskStatus.ENDORSE.getStatus());
        task.setOpinion(opinion);
        task.setDateline(DateTimeUtil.unixTime());
        this.billTaskService.upldate(task);
        newBillTask.setId(IdWorker.getId());
        newBillTask.setSourceTaskId(task.getId());
        newBillTask.setUserCode(endorseApprover);
        newBillTask.setSourceUserCode(userCode);
        newBillTask.setSort(System.currentTimeMillis());
        newBillTask.setTaskType(BillTaskType.ENDORSE.getValue());
        this.billTaskService.insert(newBillTask);
        ArrayList sends = Lists.newArrayList();
        sends.add(task);
        sends.add(newBillTask);
        this.flowMsgLogic.sendMsg(sends);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repulseFlow(BillActionParamDTO actionParam) {
        String opinion = actionParam.getOpinion();
        String taskId = actionParam.getTaskId();
        long billId = actionParam.getBillId();
        String userCode = actionParam.getUserCode();
        String targetTaskId = actionParam.getTargetTaskId();
        Optional<BillTaskEntity> taskOpt = this.billBpmnLogic.findTaskBybillAndEmployeeAndTaskId(billId, taskId, userCode);
        if (!taskOpt.isPresent()) {
            throw new RbException("", (ErrorCode)ProcessCode.PROCESS_ACTIVITI_ERROR);
        }
        BillTaskEntity task = (BillTaskEntity)((Object)taskOpt.get());
        int taskNodeStatus = task.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(taskNodeStatus);
        switch (billTaskStatus) {
            case APPROVAL: {
                String formData = actionParam.getFormData();
                if (Strings.isNullOrEmpty((String)formData) || StringUtils.equals((CharSequence)"{}", (CharSequence)formData)) break;
                this.billItemLogic.updateByFormDataByBill(billId, formData);
                break;
            }
            case AGREE: 
            case REFUSE: {
                throw new RbException((ErrorCode)BillCode.BILL_TASK_HAS_APPROVED);
            }
            default: {
                throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
            }
        }
        ToaBillEntity byId = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
        task.setNodeStatus(BillTaskStatus.REPULSE.getStatus());
        task.setOpinion(opinion);
        task.setDateline(DateTimeUtil.unixTime());
        this.billTaskService.upldate(task);
        BillTaskEntity targetTask = (BillTaskEntity)((Object)this.billTaskService.getOne((Wrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BaseEntity::getId, (Object)targetTaskId)));
        if (Objects.isNull((Object)targetTask)) {
            throw new RbException((ErrorCode)BillCode.TARGET_TASK_NULL);
        }
        String taskNodeKey = targetTask.getTaskNodeKey();
        ProcessNodeExtendEntity extendEntity = (ProcessNodeExtendEntity)((Object)this.nodeExtendService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProcessNodeExtendEntity.class).eq(ProcessNodeExtendEntity::getProcessId, (Object)byId.getProcessId())).eq(ProcessNodeExtendEntity::getNodeId, (Object)taskNodeKey)));
        ArrayList sends = Lists.newArrayList();
        if (!extendEntity.getLinkType().equals(NodeLinkType.create.name())) {
            this.billBpmnLogic.returnToTargetTask(task, targetTask, userCode, opinion, actionParam.getNextApprover());
        } else {
            this.billService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ToaBillEntity.class).set(ToaBillEntity::getStatus, (Object)BillStatus.REPULSE.getStatus())).eq(BaseEntity::getId, (Object)billId));
            BillTaskEntity createTask = this.billTaskService.findCreateTaskByBill(billId);
            if (Objects.isNull((Object)createTask)) {
                throw new RbException("", (ErrorCode)ProcessCode.PROCESS_ACTIVITI_ERROR);
            }
            BillTaskEntity newBillTask = (BillTaskEntity)((Object)BeanUtil.sourceToTarget((Object)((Object)createTask), BillTaskEntity.class));
            newBillTask.setId(IdWorker.getId());
            newBillTask.setSourceTaskId(task.getId());
            newBillTask.setSourceUserCode(userCode);
            newBillTask.setSort(System.currentTimeMillis());
            newBillTask.setDateline(null);
            newBillTask.setTaskType(BillTaskType.DEFAULT.getValue());
            newBillTask.setNodeStatus(BillTaskStatus.REFUSE_FILL_IN.getStatus());
            this.billTaskService.insert(newBillTask);
            sends.add(newBillTask);
            BillRepulseEvent billRefuseEvent = new BillRepulseEvent();
            billRefuseEvent.setBillId(billId);
            billRefuseEvent.setProcessId(byId.getProcessId());
            this.eventBus.post((Object)billRefuseEvent);
        }
        sends.add(task);
        this.flowMsgLogic.sendMsg(sends);
    }

    @Override
    public void turnUser(long billId, String taskId, String turnUser, String userCode, String opinion) {
        List<BillTaskEntity> billTaskEntities = this.billTaskService.findApprovingByBillAndTaskId(billId, taskId);
        Set collect = billTaskEntities.stream().map(BillTaskEntity::getUserCode).collect(Collectors.toSet());
        List split = StrUtil.split((CharSequence)turnUser, (char)',');
        HashSet hashSet = new HashSet(split);
        collect.retainAll(hashSet);
        if (CollectionUtil.isNotEmpty(collect)) {
            throw new RbException((ErrorCode)BillCode.TURN_CANNOT_IN_NODE);
        }
        Optional<BillTaskEntity> taskOpt = this.billBpmnLogic.findTaskBybillAndEmployeeAndTaskId(billId, taskId, userCode);
        if (!taskOpt.isPresent()) {
            throw new RbException("", (ErrorCode)ProcessCode.PROCESS_ACTIVITI_ERROR);
        }
        BillTaskEntity task = (BillTaskEntity)((Object)taskOpt.get());
        int taskNodeStatus = task.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(taskNodeStatus);
        switch (billTaskStatus) {
            case APPROVAL: {
                ArrayList insertLists = Lists.newArrayList();
                for (String s : hashSet) {
                    BillTaskEntity turnTask = (BillTaskEntity)((Object)BeanUtil.sourceToTarget((Object)((Object)task), BillTaskEntity.class));
                    turnTask.setSourceTaskId(task.getId());
                    turnTask.setSourceUserCode(userCode);
                    turnTask.setTaskType(BillTaskType.TURN.getValue());
                    turnTask.setUserCode(s);
                    turnTask.setId(null);
                    insertLists.add(turnTask);
                }
                this.billTaskService.saveBatch(insertLists);
                task.setNodeStatus(BillTaskStatus.TURN.getStatus());
                task.setOpinion(Strings.isNullOrEmpty((String)opinion) ? "\u79fb\u4ea4" : opinion);
                task.setDateline(DateTimeUtil.unixTime());
                this.billTaskService.upldate(task);
                ArrayList sends = Lists.newArrayList();
                sends.addAll(insertLists);
                sends.add(task);
                this.flowMsgLogic.sendMsg(sends);
                break;
            }
            case AGREE: 
            case REFUSE: {
                throw new RbException((ErrorCode)BillCode.BILL_TASK_HAS_APPROVED);
            }
            default: {
                throw new RbException((ErrorCode)BillCode.APPROVAL_STATUS_ERROR);
            }
        }
    }

    @Override
    public BillDetailVO<List<FormFieldVO>> createByApp(long processId) {
        ProcessDetailDTO process = this.checkProcess(processId);
        List<FormFieldVO> fieldVOS = this.formBasicConvert.FormFieldPOToVO(this.formFieldService.findVoByProcessId(processId));
        ArrayList opinionVOS = Lists.newArrayList();
        String firstNodeId = this.nodeExtendService.findTaskNodeIdByProcessAndLinkType(processId, NodeLinkType.create);
        List<FormPermissionVO> permissionVOS = this.billBpmnLogic.nodeFieldPermission(processId, firstNodeId);
        String userCode = this.loginUserHolder.getUserCode();
        UserInfoDTO userInfoByCode = this.userCenterlogic.getUserInfoByCode(userCode);
        String title = this.billTitleLogic.getTitle(processId, userInfoByCode.getNickname());
        Map<String, Object> formData = this.bizFormData(process, userInfoByCode, title);
        List<String> btns = this.billBtnLogic.findBtnsOnCreateBill(process);
        return BillDetailVO.builder().form(fieldVOS).processId(processId).formData(formData).opinions(opinionVOS).permission(permissionVOS).btns(btns).mode("create").build();
    }

    @Override
    public ValidationResultDTO validation(long processId, long billId, String formDataJson, String userCode) {
        Map dataMap = (Map)JSON.parseObject((String)formDataJson, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        ProcessDetailPO processDetail = this.processService.findDetailById(processId);
        BillDataContext billDataValue = this.resolveFormDataByValidation(billId, processDetail, dataMap);
        BillValidationLogic validationService = this.getValidationService(processDetail.getId());
        return this.validataionWithResult(billDataValue, userCode, validationService);
    }

    @Override
    public List<String> getNodeCondition(long processId, long billId, String taskId) {
        List list = this.billTaskService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId)).eq(BillTaskEntity::getTaskId, (Object)taskId));
        Set nodeKeys = list.stream().map(BillTaskEntity::getTaskNodeKey).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(nodeKeys)) {
            return Collections.emptyList();
        }
        List list1 = this.nodeApproverService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProcessNodeApproverEntity.class).eq(ProcessNodeApproverEntity::getProcessId, (Object)processId)).in(ProcessNodeApproverEntity::getNodeId, nodeKeys));
        List params = list1.stream().filter(a -> !Strings.isNullOrEmpty((String)a.getExpress()) && a.getExpress().indexOf("implication") != -1).map(ProcessNodeApproverEntity::getExpressParams).collect(Collectors.toList());
        ArrayList result = Lists.newArrayList();
        for (String param : params) {
            JSONObject jsonObject = JSON.parseObject((String)param);
            for (String s : jsonObject.keySet()) {
                if (!s.startsWith("fd_")) continue;
                JSONArray jsonArray = jsonObject.getJSONArray(s);
                for (Object o : jsonArray) {
                    result.add(o.toString());
                }
            }
        }
        return result;
    }

    @Override
    public String findTodoSize() {
        ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{BillStatus.APPROVAL.getStatus(), BillStatus.REFUSE.getStatus()});
        String userCode = this.loginUserHolder.getUserCode();
        String todoSize = this.billService.findTodoSizeByStatus(userCode, statusList);
        return todoSize;
    }

    @Override
    public Pair<List<BillItemVO>, Long> findAllByQuery(Integer pageNo, Integer pageSize, DraftBillQuery query) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<BillItemPO> billDatas = this.billService.findAllByQuery(page, query);
        Page<BillItemVO> billItemVOPage = this.toItemVOList(page, billDatas, null);
        return Pair.of((Object)billItemVOPage.getRecords(), (Object)billItemVOPage.getTotal());
    }

    private ValidationResultDTO validataionWithResult(BillDataContext billDataValue, String userCode, BillValidationLogic validationService) {
        if (null != validationService) {
            return validationService.validation(billDataValue, userCode);
        }
        ValidationResultDTO validation = new ValidationResultDTO();
        validation.setAllowGoOnFlag(true);
        validation.setPassedFlag(true);
        return validation;
    }

    private BillValidationLogic getValidationService(long processId) {
        FormValidationEntity formValidation = this.formValidationService.findByProcessId(processId);
        if (null == formValidation) {
            return null;
        }
        String exp = formValidation.getExpression();
        return (BillValidationLogic)SpringContextHolder.getBean(exp);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BillDataContext resolveFormDataByValidation(long billId, ProcessDetailPO processDetail, Map<String, Object> formDataMap) {
        long newBillId;
        long processId = processDetail.getId();
        List<FormFieldPO> formFieldVOS = this.formFieldService.findVoByProcessId(processId);
        HashMap formFieldVOMap = Maps.newHashMap();
        for (FormFieldPO formFieldVO : formFieldVOS) {
            formFieldVOMap.put(formFieldVO.getWidgetName(), formFieldVO);
        }
        BillDataContext.BillDataContextBuilder dataValueBuilder = BillDataContext.builder();
        if (billId <= 0L) {
            newBillId = IdWorker.getId();
            dataValueBuilder.created(true);
        } else {
            newBillId = billId;
        }
        dataValueBuilder.id(newBillId);
        dataValueBuilder.processId(processId);
        dataValueBuilder.formDataMap(formDataMap);
        for (String widgetName : formDataMap.keySet()) {
            String fieldType;
            FormFieldPO formFieldVO = (FormFieldPO)formFieldVOMap.get(widgetName);
            if (formFieldVO == null || Strings.isNullOrEmpty((String)(fieldType = formFieldVO.getType()))) continue;
            FormXtype formXtype = FormXtype.valueOf(fieldType);
            switch (formXtype) {
                case imageupload: 
                case fileupload: {
                    Pair<String, String> uploadValue = this.billItemLogic.formUploadValue(formDataMap, formFieldVO);
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)uploadValue.getKey()))) break;
                    dataValueBuilder.attachment(true);
                    break;
                }
                case biz: {
                    Pair<String, String> bizPair = this.billItemLogic.formBizValue(formDataMap, formFieldVO);
                    String code = (String)bizPair.getKey();
                    String title = (String)bizPair.getValue();
                    if (StringUtils.isNotEmpty((CharSequence)title)) {
                        dataValueBuilder.title(title);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)code)) break;
                    dataValueBuilder.code(code);
                    break;
                }
                case detailgroup: {
                    Triple<Boolean, List<BillAssociatedVO>, List<BillBizDataEntity>> detailItemTriple;
                    Boolean attachment;
                    List<FormFieldPO> detailFields;
                    String detailgroupName = formFieldVO.getWidgetName();
                    JSONArray detailgroupDatas = (JSONArray)formDataMap.get(detailgroupName);
                    if (CollectionUtil.isEmpty((Collection)detailgroupDatas) || CollectionUtil.isEmpty(detailFields = formFieldVO.getDetailFields()) || !(attachment = (Boolean)(detailItemTriple = this.billItemLogic.detailFormFileds(newBillId, detailgroupDatas, detailFields)).getLeft()).booleanValue()) break;
                    dataValueBuilder.attachment(true);
                    break;
                }
            }
        }
        return dataValueBuilder.build();
    }

    private List<BillOpinionVO> billOpinions(ToaBillEntity bill) {
        long processId = (Long)MoreObjects.firstNonNull((Object)bill.getProcessId(), (Object)0L);
        ArrayList opinionVOS = Lists.newArrayList();
        List<ProcessNodeExtendEntity> taskNodes = this.nodeExtendService.findTaskNodeByProcess(processId);
        if (CollectionUtil.isNotEmpty(taskNodes)) {
            for (ProcessNodeExtendEntity taskNode : taskNodes) {
                String linkType = taskNode.getLinkType();
                if (!StringUtils.equals((CharSequence)linkType, (CharSequence)NodeLinkType.approvl.name())) continue;
                BillOpinionVO billOpinionVO = new BillOpinionVO();
                billOpinionVO.setTitle(taskNode.getNodeName());
                opinionVOS.add(billOpinionVO);
            }
        }
        return opinionVOS;
    }

    private <T> BillDetailVO.BillDetailVOBuilder<T> billDetailBuilder(BillDataJsonEntity billDataJson, ToaBillEntity bill) {
        return this.billDetailBuilder(billDataJson, bill, "");
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> BillDetailVO.BillDetailVOBuilder<T> billDetailBuilder(BillDataJsonEntity billDataJson, ToaBillEntity bill, String page) {
        ToaProcessEntity byId;
        Integer assistant;
        List<FormPermissionVO> permissions;
        List<String> btns;
        BillTaskEntity billTask;
        BillDetailVO.BillDetailVOBuilder detailBuilder;
        long processId;
        long billId;
        block17: {
            BillStatus billStatus;
            String userCode;
            block18: {
                BillTaskStatus taskStatus;
                billId = bill.getId();
                processId = bill.getProcessId();
                userCode = this.loginUserHolder.getUserCode();
                String sender = bill.getSender();
                if (!sender.equals(userCode)) {
                    this.billReadRecordService.readBillByUserCode(billId, userCode);
                }
                int dbBillStatus = (Integer)MoreObjects.firstNonNull((Object)bill.getStatus(), (Object)0);
                billStatus = BillStatus.valueTo(dbBillStatus);
                detailBuilder = BillDetailVO.builder();
                billTask = null;
                List<BillTaskEntity> tasks = this.billTaskService.findTaskByBillAndUserCode(billId, userCode);
                for (BillTaskEntity task : tasks) {
                    taskStatus = BillTaskStatus.valueTo(task.getNodeStatus());
                    if (taskStatus != BillTaskStatus.APPROVAL) continue;
                    billTask = task;
                }
                if (Objects.isNull(billTask) && CollectionUtil.isNotEmpty(tasks)) {
                    billTask = tasks.get(0);
                }
                if (Objects.isNull(billTask)) break block18;
                btns = this.billBtnLogic.findBtnsOnTaskAction(userCode, bill, billTask);
                String taskId = (String)MoreObjects.firstNonNull((Object)billTask.getTaskId(), (Object)"");
                detailBuilder.taskId(taskId);
                int nodeStatus = billTask.getNodeStatus();
                taskStatus = BillTaskStatus.valueTo(nodeStatus);
                switch (taskStatus) {
                    case CANCEL: {
                        permissions = this.billBpmnLogic.findPermissionByProcessStartNode(processId);
                        break;
                    }
                    case APPROVAL: 
                    case AGREE: 
                    case REFUSE: 
                    case ARCHIVED: 
                    case APPLY_CANCEL: 
                    case FILL_IN: 
                    case OTHER_APPROVAL: {
                        String taskNodeKey = billTask.getTaskNodeKey();
                        permissions = this.billBpmnLogic.nodeFieldPermission(processId, taskNodeKey);
                        if (!CollectionUtil.isNotEmpty(permissions)) break;
                        if (billStatus == BillStatus.COMPLETE) {
                            for (FormPermissionVO permission : permissions) {
                                permission.setEdit(false);
                            }
                            break block17;
                        } else {
                            if (Strings.isNullOrEmpty((String)page) || !StringUtils.equalsAny((CharSequence)page, (CharSequence[])new CharSequence[]{"cc", "approved"})) break;
                            for (FormPermissionVO permission : permissions) {
                                permission.setEdit(false);
                            }
                        }
                        break block17;
                    }
                    case REFUSE_FILL_IN: {
                        permissions = this.billBpmnLogic.findPermissionByProcessStartNode(processId);
                        if (!CollectionUtil.isNotEmpty(permissions) || billStatus != BillStatus.COMPLETE) break;
                        for (FormPermissionVO permission : permissions) {
                            permission.setEdit(false);
                        }
                        break;
                    }
                    default: {
                        permissions = Collections.emptyList();
                        break;
                    }
                }
                break block17;
            }
            btns = this.billBtnLogic.findBtnsOnViewBill(userCode, bill);
            detailBuilder.taskId("");
            permissions = this.billBpmnLogic.findPermissionByBill(bill, userCode);
            if (CollectionUtil.isNotEmpty(permissions) && billStatus == BillStatus.COMPLETE) {
                for (FormPermissionVO permission : permissions) {
                    permission.setEdit(false);
                }
            }
        }
        Map formData = (Map)JSON.parseObject((String)billDataJson.getFormData(), FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        String title = "";
        if (!Strings.isNullOrEmpty((String)bill.getTitle())) {
            title = bill.getTitle();
        }
        if ((assistant = (byId = (ToaProcessEntity)((Object)this.processService.getById(bill.getProcessId()))).getAssistant()) == 0) {
            btns.remove("btn-submit");
        }
        List<String> newBtns = this.billBtnLogic.filterByNode(billTask, btns);
        detailBuilder.title(title).formData(formData).processId(processId).billId(billId).permission(permissions).btns(newBtns);
        return detailBuilder;
    }

    private ProcessDetailDTO checkProcess(long processId) {
        ProcessDetailPO process = this.processService.findDetailById(processId);
        if (process == null) {
            throw new RbException("", (ErrorCode)ProcessCode.BILL_SAVE_PROCESS_NIL);
        }
        if (process.getStatus() != 1) {
            throw new RbException("", (ErrorCode)ProcessCode.BILL_PROCESS_NOT_USED);
        }
        return this.billBasicConvert.billPOToDTO(process);
    }

    private Map<String, Object> bizFormData(ProcessDetailDTO process, UserInfoDTO userInfoDTO, String title) {
        long processId = process.getId();
        long processCodeId = Objects.isNull(process.getCodeId()) ? 0L : process.getCodeId();
        List<FormFieldEntity> bizFields = this.formFieldService.findBizFiled(processId, FormXtype.biz);
        if (CollectionUtil.isEmpty(bizFields)) {
            return Collections.emptyMap();
        }
        HashMap formData = Maps.newHashMap();
        for (FormFieldEntity bizField : bizFields) {
            String bizTypeStr = bizField.getBizType();
            if (Strings.isNullOrEmpty((String)bizTypeStr)) continue;
            BizType bizType = BizType.valueOf(bizTypeStr);
            String widgetName = bizField.getWidgetName();
            switch (bizType) {
                case billTitle: {
                    formData.put(widgetName, title);
                    break;
                }
                case loginUser: {
                    if (!Objects.isNull(userInfoDTO)) {
                        formData.put(widgetName, userInfoDTO.getNickname());
                        break;
                    }
                    formData.put(widgetName, "\u65e0");
                    break;
                }
                case department: {
                    List<UserOrgDTO> orgs;
                    String organizationName = "";
                    if (!Objects.isNull(userInfoDTO) && CollectionUtil.isNotEmpty(orgs = userInfoDTO.getOrgs())) {
                        List orgNames = orgs.stream().map(UserOrgDTO::getOrgName).collect(Collectors.toList());
                        organizationName = StrUtil.join((CharSequence)",", (Object[])new Object[]{orgNames});
                    }
                    formData.put(widgetName, organizationName);
                    break;
                }
                case billCode: {
                    String billCode = this.serialNumberLogic.dayPolling("bill_default_sn", 6);
                    log.debug("the bill code is {}", (Object)billCode);
                    formData.put(widgetName, billCode);
                    break;
                }
            }
        }
        return formData;
    }

    public BillLogicImpl(ToaProcessService processService, ProcessNodeExtendService nodeExtendService, FormDesingerService formDesingerService, ProcessNodeFormFieldService nodeFieldPermission, FormFieldService formFieldService, UserCenterlogic userCenterlogic, BillBtnLogic billBtnLogic, ToaBillService billService, BillDataJsonService billDataJsonService, BillTaskService billTaskService, BillReadRecordService billReadRecordService, BillBizDataService billBizDataService, BillBpmnLogic billBpmnLogic, BillDataJsonLogic billDataJsonLogic, BillItemLogic billItemLogic, EventBus eventBus, ProcessNodeApproverService nodeApproverService, LoginUserHolder loginUserHolder, FlowMsgLogic flowMsgLogic, BillTitleLogic billTitleLogic, SerialNumberLogic serialNumberLogic, FormValidationService formValidationService, FormSettingService formSettingService, CallBackLogic callBackLogic, FormBasicConvert formBasicConvert, BillBasicConvert billBasicConvert) {
        this.processService = processService;
        this.nodeExtendService = nodeExtendService;
        this.formDesingerService = formDesingerService;
        this.nodeFieldPermission = nodeFieldPermission;
        this.formFieldService = formFieldService;
        this.userCenterlogic = userCenterlogic;
        this.billBtnLogic = billBtnLogic;
        this.billService = billService;
        this.billDataJsonService = billDataJsonService;
        this.billTaskService = billTaskService;
        this.billReadRecordService = billReadRecordService;
        this.billBizDataService = billBizDataService;
        this.billBpmnLogic = billBpmnLogic;
        this.billDataJsonLogic = billDataJsonLogic;
        this.billItemLogic = billItemLogic;
        this.eventBus = eventBus;
        this.nodeApproverService = nodeApproverService;
        this.loginUserHolder = loginUserHolder;
        this.flowMsgLogic = flowMsgLogic;
        this.billTitleLogic = billTitleLogic;
        this.serialNumberLogic = serialNumberLogic;
        this.formValidationService = formValidationService;
        this.formSettingService = formSettingService;
        this.callBackLogic = callBackLogic;
        this.formBasicConvert = formBasicConvert;
        this.billBasicConvert = billBasicConvert;
    }
}

