/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.googlecode.aviator.AviatorEvaluator;
import com.jingtong.bpm.infra.entity.BillDataJsonEntity;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeConnectionEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.po.ProcessDetailPO;
import com.jingtong.bpm.infra.service.BillDataJsonService;
import com.jingtong.bpm.infra.service.BillTaskService;
import com.jingtong.bpm.infra.service.ProcessNodeConnectionService;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.infra.service.ToaBillService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.constant.BillTaskStatus;
import com.jingtong.bpm.logic.constant.BillTaskType;
import com.jingtong.bpm.logic.constant.FastJsonType;
import com.jingtong.bpm.logic.context.BillDataContext;
import com.jingtong.bpm.logic.context.BpmnBillContext;
import com.jingtong.bpm.logic.service.BillBpmnLogic;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.service.BillNextNodeLogic;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BillNextNodeLogicImpl
implements BillNextNodeLogic {
    private static final Logger log = LoggerFactory.getLogger(BillNextNodeLogicImpl.class);
    private final ToaProcessService processService;
    private final RepositoryService repositoryService;
    private final BillBpmnLogic billBpmnLogic;
    private final ToaBillService billService;
    private final BillTaskService billTaskService;
    private final BillDataJsonService billDataJsonService;
    private final BillLogic billLogic;
    private final TaskService taskService;
    private final ProcessNodeConnectionService connectionService;
    private final ProcessNodeExtendService nodeExtendService;
    private final LoginUserHolder loginUserHolder;

    @Override
    public Pair<Integer, String> submitNextManualFlag(Long processId, String employeeId, String formData) {
        ToaProcessEntity process = (ToaProcessEntity)((Object)this.processService.getById(processId));
        String processKey = process.getFlowId();
        ProcessDefinition processDefinition = this.findLastVersionByFlowId(processKey);
        String definitionId = processDefinition.getId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(definitionId);
        BpmnBillContext bpmnBillContext = this.billBpmnLogic.createBpmnContext(employeeId, null);
        Map formDataMap = (Map)JSON.parseObject((String)formData, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        List<FlowElement> firstTaskNode = this.findFirstTaskNode(bpmnModel);
        return this.getCorrespondConnection(firstTaskNode.get(0), formDataMap, bpmnBillContext);
    }

    private List<FlowElement> findFirstTaskNode(BpmnModel bpmnModel) {
        if (bpmnModel != null) {
            ArrayList nodes = Lists.newArrayList();
            Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
            if (CollectionUtil.isNotEmpty((Collection)flowElements)) {
                for (FlowElement flowElement : flowElements) {
                    if (!(flowElement instanceof StartEvent)) continue;
                    List outgoingFlows = ((StartEvent)flowElement).getOutgoingFlows();
                    for (SequenceFlow outgoingFlow : outgoingFlows) {
                        FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
                        nodes.add(targetFlowElement);
                    }
                }
            }
            return nodes;
        }
        return Collections.emptyList();
    }

    private ProcessDefinition findLastVersionByFlowId(String flowId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(flowId).latestVersion().singleResult();
    }

    @Override
    public Pair<Integer, String> approvalNextManualFlag(String taskId, Long billId, String formData) {
        String userId = this.loginUserHolder.getUserCode();
        ToaBillEntity bill = (ToaBillEntity)((Object)this.billService.getById(billId));
        BillTaskEntity billTask = (BillTaskEntity)((Object)this.billTaskService.unique((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getTaskId, (Object)taskId)).eq(BillTaskEntity::getUserCode, (Object)userId)).eq(BillTaskEntity::getNodeStatus, (Object)BillTaskStatus.APPROVAL.getStatus())).get());
        if (billTask.getTaskType().equals(BillTaskType.ENDORSE.getValue())) {
            return Pair.of((Object)0, (Object)"");
        }
        Long processId = bill.getProcessId();
        String processInstanceId = bill.getProcessInstanceId();
        String employeeId = bill.getSender();
        ProcessDetailPO processDetailDTO = this.processService.findDetailById(processId);
        BillDataJsonEntity billDataJson = (BillDataJsonEntity)((Object)this.billDataJsonService.getOne((Wrapper)Wrappers.lambdaQuery(BillDataJsonEntity.class).eq(BillDataJsonEntity::getBillId, (Object)billId)));
        Map billFormDataMap = Maps.newHashMap();
        if (billDataJson != null) {
            String billformData = billDataJson.getFormData();
            billFormDataMap = (Map)JSON.parseObject((String)billformData, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
        }
        HashMap formDataMap = Maps.newHashMap();
        formDataMap.putAll(billFormDataMap);
        if (!Strings.isNullOrEmpty((String)formData) && !formData.equals("null")) {
            formDataMap.putAll((Map)JSON.parseObject((String)formData, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]));
        }
        BillDataContext billDataValue = this.billLogic.resolveFormData(billId, processDetailDTO, formDataMap);
        BpmnBillContext bpmnBillContext = this.billBpmnLogic.createBpmnContext(employeeId, billDataValue);
        String nodeKey = billTask.getTaskNodeKey();
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKey(nodeKey)).processInstanceId(processInstanceId)).singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        List processes = bpmnModel.getProcesses();
        Process process = (Process)processes.get(0);
        FlowElement flowElement = process.getFlowElement(nodeKey);
        return this.getCorrespondConnection(flowElement, formDataMap, bpmnBillContext);
    }

    private Pair<Integer, String> getCorrespondConnection(FlowElement flowElement, Map<String, Object> formDataMap, BpmnBillContext bpmnBillContext) {
        UserTask userTask = (UserTask)flowElement;
        List outgoingFlows = userTask.getOutgoingFlows();
        for (SequenceFlow next : outgoingFlows) {
            if (!Strings.isNullOrEmpty((String)next.getConditionExpression()) && !next.getConditionExpression().equals("${var_action=='refuse'}")) continue;
        }
        if (CollectionUtil.isEmpty((Collection)outgoingFlows)) {
            return Pair.of((Object)0, (Object)"");
        }
        Map<String, String> connectionToNodeMap = outgoingFlows.parallelStream().collect(Collectors.toMap(BaseElement::getId, a -> a.getTargetRef()));
        List collect = outgoingFlows.parallelStream().map(BaseElement::getId).collect(Collectors.toList());
        List allConnection = this.connectionService.list((Wrapper)Wrappers.lambdaUpdate(ProcessNodeConnectionEntity.class).in(ProcessNodeConnectionEntity::getNodeId, collect));
        HashSet correspondConnection = Sets.newHashSet();
        for (Object nodeConnection : allConnection) {
            String express = nodeConnection.getExpress();
            if (!Strings.isNullOrEmpty((String)express)) {
                Boolean conditionResult;
                String expressParams = nodeConnection.getExpressParams();
                HashMap env = Maps.newHashMap();
                if (StringUtils.contains((CharSequence)express, (CharSequence)"var_formData")) {
                    env.put("var_formData", formDataMap);
                }
                env.putAll(bpmnBillContext.toEnvParam(express));
                if (!Strings.isNullOrEmpty((String)expressParams)) {
                    Map expressParamMap = (Map)JSON.parseObject((String)expressParams, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
                    env.putAll(expressParamMap);
                }
                try {
                    conditionResult = (Boolean)AviatorEvaluator.execute((String)express, (Map)env);
                }
                catch (Exception e) {
                    log.error("Express exec has error ! express is \n {} \n ---- param is \n {}", (Object)express, JSON.toJSON((Object)env));
                    conditionResult = false;
                }
                if (!conditionResult.booleanValue()) continue;
                correspondConnection.add(nodeConnection.getNodeId());
                continue;
            }
            correspondConnection.add(nodeConnection.getNodeId());
        }
        HashSet nextNode = Sets.newHashSet();
        for (String s : correspondConnection) {
            String node = connectionToNodeMap.get(s);
            nextNode.add(node);
        }
        log.info("{}", (Object)nextNode);
        if (CollectionUtil.isEmpty((Collection)nextNode)) {
            return Pair.of((Object)0, (Object)"");
        }
        List manual = this.nodeExtendService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProcessNodeExtendEntity.class).in(ProcessNodeExtendEntity::getNodeId, (Collection)nextNode)).eq(ProcessNodeExtendEntity::getSelectApproval, (Object)1));
        if (CollectionUtil.isNotEmpty((Collection)manual)) {
            return Pair.of((Object)1, (Object)((ProcessNodeExtendEntity)((Object)manual.get(0))).getNodeName());
        }
        return Pair.of((Object)0, (Object)"");
    }

    public BillNextNodeLogicImpl(ToaProcessService processService, RepositoryService repositoryService, BillBpmnLogic billBpmnLogic, ToaBillService billService, BillTaskService billTaskService, BillDataJsonService billDataJsonService, BillLogic billLogic, TaskService taskService, ProcessNodeConnectionService connectionService, ProcessNodeExtendService nodeExtendService, LoginUserHolder loginUserHolder) {
        this.processService = processService;
        this.repositoryService = repositoryService;
        this.billBpmnLogic = billBpmnLogic;
        this.billService = billService;
        this.billTaskService = billTaskService;
        this.billDataJsonService = billDataJsonService;
        this.billLogic = billLogic;
        this.taskService = taskService;
        this.connectionService = connectionService;
        this.nodeExtendService = nodeExtendService;
        this.loginUserHolder = loginUserHolder;
    }
}

