/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelXorHtmlUtil;
import cn.afterturn.easypoi.excel.entity.ExcelToHtmlParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.collection.CollectionUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jingtong.bpm.infra.entity.FormSettingEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.entity.ToaFormEntity;
import com.jingtong.bpm.infra.service.FormSettingService;
import com.jingtong.bpm.infra.service.FormTableService;
import com.jingtong.bpm.infra.service.ToaBillService;
import com.jingtong.bpm.infra.service.ToaFormService;
import com.jingtong.bpm.logic.service.BillPrintLogic;
import com.jingtong.config.BpmConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BillPrintLogicImpl
implements BillPrintLogic {
    private static final Logger log = LoggerFactory.getLogger(BillPrintLogicImpl.class);
    private final ToaBillService billService;
    private final ToaFormService formService;
    private final FormSettingService formSettingService;
    private final FormTableService formTableService;
    private final BpmConfig bpmConfig;
    private static final String FIREFOX_AGENT = "firefox";
    private static final String IE_AGENT = "msie";
    private static final String SAFARI_AGENT = "safari";

    @Override
    public void download(Long billId, HttpServletResponse resp, HttpServletRequest request) {
        ToaBillEntity byId = (ToaBillEntity)((Object)this.billService.getById(billId));
        String title = byId.getTitle();
        XSSFWorkbook workbook = this.getExcel(billId, title);
        if (Objects.isNull(workbook)) {
            return;
        }
        try {
            BillPrintLogicImpl.downloadNewExcel(resp, request, title, workbook);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private XSSFWorkbook getExcel(Long billId, String title) {
        FormSettingEntity formSettingEntity;
        String printTemplatePath;
        Long id;
        Optional<FormSettingEntity> byFormId;
        ToaFormEntity byBillId = this.formService.findByBillId(billId);
        if (!Objects.isNull((Object)byBillId) && (byFormId = this.formSettingService.findByFormId(id = byBillId.getId())).isPresent() && !Strings.isNullOrEmpty((String)(printTemplatePath = (formSettingEntity = byFormId.get()).getPrintTemplatePath()))) {
            String tableName = byBillId.getTableName();
            String mainSql = "select * from TABLE where id_=#{id}";
            HashMap params = Maps.newHashMap();
            params.put("id", billId);
            int byTableSize = this.formTableService.findByTableSize(tableName + "_dt");
            List<Map<String, Object>> mainData = this.formTableService.executeSelectSql(mainSql.replace("TABLE", tableName), params);
            log.info("{}", mainData);
            TemplateExportParams exportParams = new TemplateExportParams(this.bpmConfig.getFilePath() + File.separator + printTemplatePath, new Integer[0]);
            HashMap map = Maps.newHashMap();
            map.put("title", title);
            if (CollectionUtil.isNotEmpty(mainData)) {
                map.put("main", mainData.get(0));
            }
            for (int i = 1; i <= byTableSize; ++i) {
                String detailSql = "select * from TABLE where main_id_=#{sql.id}";
                List<Map<String, Object>> list = this.formTableService.executeSelectSql(detailSql.replace("TABLE", tableName + "_dt" + i), params);
                log.info("{}", list);
                map.put("detail" + i, list);
            }
            XSSFWorkbook workbook = (XSSFWorkbook)ExcelExportUtil.exportExcel((TemplateExportParams)exportParams, (Map)map);
            return workbook;
        }
        return null;
    }

    @Override
    public String print(Long billId) {
        ToaBillEntity byId = (ToaBillEntity)((Object)this.billService.getById(billId));
        String title = byId.getTitle();
        XSSFWorkbook workbook = this.getExcel(billId, title);
        String html = ExcelXorHtmlUtil.excelToHtml((ExcelToHtmlParams)new ExcelToHtmlParams((Workbook)workbook, true, 0, "yes"));
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadNewExcel(HttpServletResponse response, HttpServletRequest request, String title, XSSFWorkbook workbook) throws IOException {
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        String exportTitle = title + ".xlsx";
        ServletOutputStream os = null;
        try {
            String agent = request.getHeader("User-Agent");
            String enableFileName = BillPrintLogicImpl.parseAgentDownloadFIleName(exportTitle, agent);
            response.addHeader("Content-Disposition", "attachment;fileName=" + enableFileName);
            os = response.getOutputStream();
            workbook.write((OutputStream)os);
            os.flush();
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (UnsupportedEncodingException e) {
            log.error("file name encoding has error!" + e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    private static String parseAgentDownloadFIleName(String exportTitle, String agent) {
        String enableFileName;
        try {
            enableFileName = agent != null && StringUtils.containsIgnoreCase((CharSequence)agent, (CharSequence)FIREFOX_AGENT) ? "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])exportTitle.getBytes("UTF-8"))) + "?=" : (agent != null && StringUtils.containsIgnoreCase((CharSequence)agent, (CharSequence)SAFARI_AGENT) ? new String(exportTitle.getBytes("UTF-8"), "ISO-8859-1") : URLEncoder.encode(exportTitle, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u751f\u6210\u4e0b\u8f7d\u6587\u4ef6\u540d\u79f0\u5904\u7406\u89e3\u6790\u5931\u8d25\uff0c\u6587\u4ef6\u540d\u79f0\u4e3a {} ", (Object)exportTitle, (Object)e);
            enableFileName = exportTitle;
        }
        return enableFileName;
    }

    public BillPrintLogicImpl(ToaBillService billService, ToaFormService formService, FormSettingService formSettingService, FormTableService formTableService, BpmConfig bpmConfig) {
        this.billService = billService;
        this.formService = formService;
        this.formSettingService = formSettingService;
        this.formTableService = formTableService;
        this.bpmConfig = bpmConfig;
    }
}

