/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jingtong.bpm.infra.entity.BillReplyEntity;
import com.jingtong.bpm.infra.service.BillReplyService;
import com.jingtong.bpm.logic.dto.BillReplyDTO;
import com.jingtong.bpm.logic.dto.UserInfoDTO;
import com.jingtong.bpm.logic.service.BillReplyLogic;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.util.datetime.DateTimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BillReplyLogicImpl
implements BillReplyLogic {
    private final BillReplyService billReplyService;
    private final UserCenterlogic userCenterlogic;
    private final LoginUserHolder loginUserHolder;

    @Override
    public Pair<List<BillReplyDTO>, Long> findByBillId(Integer page, Integer pageSize, Long billId) {
        Page pag = new Page((long)page.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper eq = (LambdaQueryWrapper)Wrappers.lambdaQuery(BillReplyEntity.class).eq(BillReplyEntity::getBillId, (Object)billId);
        Page page1 = (Page)this.billReplyService.page((IPage)pag, (Wrapper)eq);
        List records = page1.getRecords();
        Set<String> userCodes = records.stream().map(BillReplyEntity::getUserCode).collect(Collectors.toSet());
        ConcurrentMap codeNameMap = Maps.newConcurrentMap();
        if (CollectionUtil.isNotEmpty(this.userCenterlogic.getUserByCodes(userCodes))) {
            List<UserInfoDTO> data = this.userCenterlogic.getUserByCodes(userCodes);
            codeNameMap.putAll(data.stream().collect(Collectors.toMap(UserInfoDTO::getCode, UserInfoDTO::getNickname)));
        }
        String userCode = this.loginUserHolder.getUserCode();
        ArrayList result = Lists.newArrayList();
        for (BillReplyEntity record : records) {
            BillReplyDTO billReplyDTO = new BillReplyDTO();
            billReplyDTO.setId(record.getId());
            billReplyDTO.setContent(record.getContent());
            billReplyDTO.setDateline(record.getDateline());
            String recordUserCode = record.getUserCode();
            billReplyDTO.setSelf(recordUserCode.equals(userCode));
            String replyName = (String)codeNameMap.get(recordUserCode);
            if (!Strings.isNullOrEmpty((String)replyName)) {
                billReplyDTO.setUserName(replyName);
            }
            result.add(billReplyDTO);
        }
        return Pair.of((Object)result, (Object)page1.getTotal());
    }

    @Override
    public boolean deleteByBillId(long billId, long replyId) {
        return this.billReplyService.removeById(Long.valueOf(replyId));
    }

    @Override
    public BillReplyDTO submit(Long billId, String content) {
        int unixTime = DateTimeUtil.unixTime();
        BillReplyEntity reply = new BillReplyEntity();
        reply.setBillId(billId);
        reply.setContent(content);
        reply.setDateline(unixTime);
        String userCode = this.loginUserHolder.getUserCode();
        reply.setUserCode(userCode);
        boolean insert = this.billReplyService.insert(reply);
        if (insert) {
            BillReplyDTO replyDto = new BillReplyDTO();
            replyDto.setContent(content);
            replyDto.setDateline(unixTime);
            if (CollectionUtil.isNotEmpty(this.userCenterlogic.getUserByCodes(Sets.newHashSet((Object[])new String[]{userCode})))) {
                replyDto.setUserName(this.userCenterlogic.getUserByCodes(Sets.newHashSet((Object[])new String[]{userCode})).get(0).getNickname());
            }
            replyDto.setId(reply.getId());
            return replyDto;
        }
        return null;
    }

    public BillReplyLogicImpl(BillReplyService billReplyService, UserCenterlogic userCenterlogic, LoginUserHolder loginUserHolder) {
        this.billReplyService = billReplyService;
        this.userCenterlogic = userCenterlogic;
        this.loginUserHolder = loginUserHolder;
    }
}

