/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.jingtong.base.infra.entity.BaseEntity;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.service.BillTaskService;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.infra.service.ToaBillService;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.BillTaskStatus;
import com.jingtong.bpm.logic.constant.BillTaskType;
import com.jingtong.bpm.logic.constant.NoApprovalOperation;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.converts.BillBasicConvert;
import com.jingtong.bpm.logic.dto.BillTaskDTO;
import com.jingtong.bpm.logic.dto.TransferUserDTO;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.event.BillRefuseEvent;
import com.jingtong.bpm.logic.service.BillBpmnLogic;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.service.BillTaskLogic;
import com.jingtong.bpm.logic.service.FlowMsgLogic;
import com.jingtong.bpm.logic.service.TransferUserLogic;
import com.jingtong.bpm.logic.vo.BillTaskVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.bean.BeanUtil;
import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.ErrorCode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillTaskLogicImpl
implements BillTaskLogic {
    private static final Logger log = LoggerFactory.getLogger(BillTaskLogicImpl.class);
    private final EventBus eventBus;
    private final BillTaskService billTaskService;
    private final ProcessNodeExtendService nodeExtendService;
    private final BillBpmnLogic billBpmnLogic;
    private final ToaBillService billService;
    private final BillLogic billLogic;
    private final TransferUserLogic transferUserLogic;
    private final FlowMsgLogic msgLogic;
    private final BillBasicConvert billBasicConvert;

    @Override
    public void saveBillApprover(HashSet<String> approvers, long billId, DelegateTask task) {
        String taskNodeId = task.getTaskDefinitionKey();
        String processDefinitionId = task.getProcessDefinitionId();
        String processFlowId = StrUtil.split((CharSequence)processDefinitionId, (CharSequence)":")[0];
        Optional<ProcessNodeExtendEntity> nodeExtendOpt = this.nodeExtendService.findByFlowIdAndNodeId(taskNodeId, processFlowId);
        String action = (String)task.getVariable("var_action", String.class);
        BillAction billAction = BillAction.valueOf(action);
        if (nodeExtendOpt.isPresent()) {
            ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOpt.get());
            String linkType = nodeExtend.getLinkType();
            NodeLinkType nodeLinkType = NodeLinkType.valueOf(linkType);
            block0 : switch (nodeLinkType) {
                case archive: {
                    break;
                }
                case create: {
                    switch (billAction) {
                        case submit: {
                            break block0;
                        }
                        case refuse: {
                            BillRefuseEvent billRefuseEvent = new BillRefuseEvent();
                            billRefuseEvent.setBillId(billId);
                            billRefuseEvent.setProcessId(nodeExtend.getProcessId());
                            this.eventBus.post((Object)billRefuseEvent);
                            break block0;
                        }
                    }
                    break;
                }
            }
        } else {
            throw new RbException((ErrorCode)BillCode.PROCESS_NODE_NOT_FOUND);
        }
        if (CollectionUtil.isNotEmpty(approvers)) {
            ArrayList billTasks = Lists.newArrayListWithCapacity((int)approvers.size());
            for (String approver : approvers) {
                if (Strings.isNullOrEmpty((String)approver)) continue;
                BillTaskEntity billTask = new BillTaskEntity();
                billTask.setAction(BillAction.fill.name());
                billTask.setOpinion("\u63d0\u4ea4\u5ba1\u6279\u5355");
                billTask.setDateline(DateTimeUtil.unixTime());
                billTask.setSort(System.currentTimeMillis());
                billTask.setTaskNodeKey(taskNodeId);
                billTask.setUserCode(approver);
                billTask.setBillId(billId);
                billTask.setNodeStatus(BillTaskStatus.REFUSE_FILL_IN.getStatus());
                billTask.setNodeName(task.getName());
                billTask.setTaskId(task.getId());
                billTask.setCreationTime(LocalDateTime.now());
                billTasks.add(billTask);
            }
            if (CollectionUtil.isNotEmpty((Collection)billTasks)) {
                this.billTaskService.saveBatch(billTasks, 300);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<BillTaskEntity> saveBillApprover(Map<Long, Set<String>> approvers, long billId, DelegateTask task) {
        String taskNodeId = task.getTaskDefinitionKey();
        String processDefinitionId = task.getProcessDefinitionId();
        String processFlowId = StrUtil.split((CharSequence)processDefinitionId, (CharSequence)":")[0];
        Optional<ProcessNodeExtendEntity> nodeExtendOpt = this.nodeExtendService.findByFlowIdAndNodeId(taskNodeId, processFlowId);
        String action = (String)task.getVariable("var_action", String.class);
        String lastNodeKey = (String)task.getVariable("var_last_node_key", String.class);
        String lastTaskId = (String)task.getVariable("var_last_task_id", String.class);
        BillAction billAction = BillAction.valueOf(action);
        BillTaskStatus taskStatus = BillTaskStatus.APPROVAL;
        if (!nodeExtendOpt.isPresent()) throw new RbException((ErrorCode)BillCode.PROCESS_NODE_NOT_FOUND);
        ProcessNodeExtendEntity nodeExtend = (ProcessNodeExtendEntity)((Object)nodeExtendOpt.get());
        String linkType = nodeExtend.getLinkType();
        NodeLinkType nodeLinkType = NodeLinkType.valueOf(linkType);
        block0 : switch (nodeLinkType) {
            case archive: {
                break;
            }
            case create: {
                switch (billAction) {
                    case submit: {
                        taskStatus = BillTaskStatus.FILL_IN;
                        break block0;
                    }
                    case refuse: {
                        taskStatus = BillTaskStatus.REFUSE_FILL_IN;
                        break block0;
                    }
                }
                break;
            }
        }
        NoApprovalOperation operation = NoApprovalOperation.forValue(nodeExtend.getNoApprovalOperation());
        String taskId = task.getId();
        switch (operation) {
            case SUPERADMIN: {
                if (!CollectionUtil.isEmpty((Map)approvers)) break;
                approvers = Maps.newConcurrentMap();
                approvers.put(0L, Sets.newHashSet((Object[])new String[]{"1"}));
                break;
            }
            case SKIP: {
                if (!CollectionUtil.isEmpty((Map)approvers)) break;
                Map formDataMap = (Map)task.getVariable("var_formData");
                this.billTaskService.saveSkipTask(taskNodeId, billId, taskId, task.getName(), lastNodeKey, lastTaskId);
                this.billBpmnLogic.complete((ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId))), taskId, "\u81ea\u52a8\u8df3\u8fc7", "", "", JSON.toJSONString((Object)formDataMap), taskNodeId, lastTaskId);
                break;
            }
            case CANNOTGO: {
                if (!CollectionUtil.isEmpty((Map)approvers)) break;
                throw new RbException((ErrorCode)BillCode.NO_APPROVER);
            }
        }
        if (!CollectionUtil.isNotEmpty((Map)approvers)) return Collections.emptyList();
        ArrayList billTasks = Lists.newArrayList();
        Iterator iterator = approvers.keySet().iterator();
        block13: while (true) {
            if (!iterator.hasNext()) {
                if (!CollectionUtil.isNotEmpty((Collection)billTasks)) return Collections.emptyList();
                this.billTaskService.saveBatch(billTasks, 300);
                BillTaskEntity billTaskEntity = this.autoAgree(nodeExtend, billTasks, lastTaskId, billId);
                if (Objects.isNull((Object)billTaskEntity)) {
                    this.transfer(billTasks, billId);
                    List<BillTaskEntity> approvingByBillAndTaskId = this.billTaskService.findApprovingByBillAndTaskId(billId, taskId);
                    this.msgLogic.sendMsg(approvingByBillAndTaskId);
                    return approvingByBillAndTaskId;
                }
                boolean goFlag = this.billLogic.agreeIsGoOn(billTaskEntity);
                if (goFlag) {
                    this.billBpmnLogic.complete((ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId))), billTaskEntity.getTaskId(), "\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7", billTaskEntity.getUserCode(), "", "", billTaskEntity.getTaskNodeKey(), billTaskEntity.getTaskId());
                    this.billTaskService.deleteApproval(billId, billTaskEntity.getTaskId(), BillTaskStatus.APPROVAL.getStatus());
                    return Collections.emptyList();
                }
                this.transfer(billTasks, billId);
                List<BillTaskEntity> approvingByBillAndTaskId = this.billTaskService.findApprovingByBillAndTaskId(billId, taskId);
                this.msgLogic.sendMsg(approvingByBillAndTaskId);
                return approvingByBillAndTaskId;
            }
            Long approverSettingId = (Long)iterator.next();
            Set approversStr = (Set)approvers.get(approverSettingId);
            Iterator iterator2 = approversStr.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block13;
                String approver = (String)iterator2.next();
                if (Strings.isNullOrEmpty((String)approver)) continue;
                BillTaskEntity billTask = new BillTaskEntity();
                if (taskStatus == BillTaskStatus.FILL_IN) {
                    billTask.setAction(BillAction.fill.name());
                    billTask.setDateline(DateTimeUtil.unixTime());
                } else {
                    billTask.setAction(BillAction.none.name());
                }
                billTask.setSort(System.currentTimeMillis());
                billTask.setTaskNodeKey(taskNodeId);
                billTask.setUserCode(approver);
                billTask.setBillId(billId);
                billTask.setNodeStatus(taskStatus.getStatus());
                billTask.setNodeName(task.getName());
                billTask.setTaskId(taskId);
                billTask.setLastTaskId(lastTaskId);
                billTask.setCreationTime(LocalDateTime.now());
                billTask.setNodeApproverId(approverSettingId);
                billTask.setLastNodeKey(lastNodeKey);
                billTask.setTaskType(BillTaskType.DEFAULT.getValue());
                billTasks.add(billTask);
            }
            break;
        }
    }

    private void transfer(List<BillTaskEntity> billTaskEntities, Long billId) {
        Map<String, List<BillTaskEntity>> listMap = billTaskEntities.stream().filter(a -> a.getNodeStatus().compareTo(BillTaskStatus.APPROVAL.getStatus()) == 0).collect(Collectors.groupingBy(BillTaskEntity::getUserCode));
        List<TransferUserDTO> transferUserDTOS = this.transferUserLogic.getByProcess(listMap.keySet(), billId, LocalDateTime.now());
        Map<String, TransferUserDTO> transferUserMap = transferUserDTOS.stream().collect(Collectors.toMap(TransferUserDTO::getUserCode, a -> a, (a, b) -> a));
        Set userCodes = listMap.keySet().stream().filter(a -> transferUserMap.keySet().contains(a)).collect(Collectors.toSet());
        ArrayList updates = Lists.newArrayList();
        ArrayList inserts = Lists.newArrayList();
        for (String userCode : userCodes) {
            List<BillTaskEntity> billTaskEntities1 = listMap.get(userCode);
            if (!CollectionUtil.isNotEmpty(billTaskEntities1)) continue;
            TransferUserDTO transferUserDTO = transferUserMap.get(userCode);
            BillTaskEntity billTaskEntity = (BillTaskEntity)((Object)BeanUtil.sourceToTarget((Object)((Object)billTaskEntities1.get(0)), BillTaskEntity.class));
            billTaskEntity.setTaskType(BillTaskType.TRANSFER.getValue());
            billTaskEntity.setNodeStatus(BillTaskStatus.APPROVAL.getStatus());
            billTaskEntity.setUserCode(transferUserDTO.getTargetUserCode());
            billTaskEntity.setSourceUserCode(userCode);
            billTaskEntity.setSourceTaskId(billTaskEntity.getId());
            billTaskEntity.setId(null);
            billTaskEntity.setCreationTime(LocalDateTime.now());
            inserts.add(billTaskEntity);
            billTaskEntities1.forEach(a -> {
                a.setNodeStatus(BillTaskStatus.TRANSFER.getStatus());
                a.setUpdateTime(LocalDateTime.now());
                a.setDateline(DateTimeUtil.unixTime());
            });
            updates.addAll(billTaskEntities1);
        }
        if (CollectionUtil.isNotEmpty((Collection)updates)) {
            this.billTaskService.updateBatchById(updates);
            this.msgLogic.sendMsg(updates);
        }
        if (CollectionUtil.isNotEmpty((Collection)inserts)) {
            this.billTaskService.saveBatch(inserts);
            this.msgLogic.sendMsg(inserts);
        }
    }

    @Override
    public BillTaskEntity autoAgree(ProcessNodeExtendEntity nodeExtend, List<BillTaskEntity> billTasks, String lastTaskId, long billId) {
        List<BillTaskEntity> billTaskEntities;
        String autoAgree = nodeExtend.getAutoAgree();
        if (Strings.isNullOrEmpty((String)autoAgree)) {
            return null;
        }
        ArrayList updateLists = Lists.newArrayList();
        if (autoAgree.contains("1")) {
            ToaBillEntity billEntity = (ToaBillEntity)((Object)this.billService.getById(Long.valueOf(billId)));
            String sender = billEntity.getSender();
            List collect = billTasks.stream().filter(a -> a.getUserCode().equals(sender)).collect(Collectors.toList());
            updateLists.addAll(collect);
        }
        if (autoAgree.contains("2")) {
            billTaskEntities = this.approverHasAgree(billTasks, lastTaskId, billId);
            updateLists.addAll(billTaskEntities);
        }
        if (autoAgree.contains("3")) {
            billTaskEntities = this.approverHasAgree(billTasks, null, billId);
            updateLists.addAll(billTaskEntities);
        }
        Map<Long, BillTaskEntity> collect = updateLists.stream().collect(Collectors.toMap(BaseEntity::getId, a -> a, (a1, a2) -> a1));
        ArrayList<BillTaskEntity> collect1 = new ArrayList<BillTaskEntity>(collect.values());
        return this.autoAgree(billId, collect1);
    }

    @Override
    public List<BillTaskVO> getHistoryTasks(Long billid) {
        List<BillTaskDTO> billTaskDTOS = this.billTaskService.getHistoryTasks(billid);
        return this.billBasicConvert.billTasksDTOToVO(billTaskDTOS);
    }

    private List<BillTaskEntity> approverHasAgree(List<BillTaskEntity> billTasks, String lastTaskId, long billId) {
        Set userCodes = billTasks.stream().map(BillTaskEntity::getUserCode).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(userCodes)) {
            List list;
            Set agreeUserCode;
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillTaskEntity.class).eq(BillTaskEntity::getBillId, (Object)billId)).eq(BillTaskEntity::getNodeStatus, (Object)BillTaskStatus.AGREE.getStatus())).in(BillTaskEntity::getUserCode, userCodes);
            if (!Strings.isNullOrEmpty((String)lastTaskId)) {
                wrapper.eq(BillTaskEntity::getTaskId, (Object)lastTaskId);
            }
            if (CollectionUtil.isNotEmpty(agreeUserCode = (list = this.billTaskService.list((Wrapper)wrapper)).stream().map(BillTaskEntity::getUserCode).collect(Collectors.toSet()))) {
                List<BillTaskEntity> autoAgreeTasks = billTasks.stream().filter(a -> agreeUserCode.contains(a.getUserCode())).collect(Collectors.toList());
                return autoAgreeTasks;
            }
        }
        return Collections.emptyList();
    }

    private BillTaskEntity autoAgree(long billId, List<BillTaskEntity> autoAgreeTasks) {
        if (CollectionUtil.isNotEmpty(autoAgreeTasks)) {
            autoAgreeTasks.forEach(a -> {
                a.setDateline(DateTimeUtil.unixTime());
                a.setUpdateTime(LocalDateTime.now());
                a.setOpinion("\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7");
                a.setNodeStatus(BillTaskStatus.AGREE.getStatus());
            });
            BillTaskEntity billTaskEntity = autoAgreeTasks.get(0);
            if (CollectionUtil.isNotEmpty(autoAgreeTasks)) {
                this.billTaskService.updateBatchById(autoAgreeTasks, 300);
            }
            this.msgLogic.sendMsg(autoAgreeTasks);
            return billTaskEntity;
        }
        return null;
    }

    public BillTaskLogicImpl(EventBus eventBus, BillTaskService billTaskService, ProcessNodeExtendService nodeExtendService, BillBpmnLogic billBpmnLogic, ToaBillService billService, BillLogic billLogic, TransferUserLogic transferUserLogic, FlowMsgLogic msgLogic, BillBasicConvert billBasicConvert) {
        this.eventBus = eventBus;
        this.billTaskService = billTaskService;
        this.nodeExtendService = nodeExtendService;
        this.billBpmnLogic = billBpmnLogic;
        this.billService = billService;
        this.billLogic = billLogic;
        this.transferUserLogic = transferUserLogic;
        this.msgLogic = msgLogic;
        this.billBasicConvert = billBasicConvert;
    }
}

