/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import com.google.common.base.Strings;
import com.jingtong.bpm.infra.po.BillTitlePO;
import com.jingtong.bpm.infra.service.ProcessBillTitleService;
import com.jingtong.bpm.logic.service.BillTitleLogic;
import com.jingtong.bpm.logic.util.DateToStringUtil;
import com.jingtong.bpm.logic.vo.BillTItleFormulaVo;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;

@Service
public class BillTitleLogicImpl
implements BillTitleLogic {
    private static final Logger log = LoggerFactory.getLogger(BillTitleLogicImpl.class);
    private final ProcessBillTitleService billTitleService;

    @Override
    public String getTitle(long processId, String nickname) {
        BillTitlePO billTitle = this.billTitleService.findByProcessId(processId);
        LocalDateTime todayDate = LocalDateTime.now();
        if (billTitle == null) {
            return DateToStringUtil.yyyymmdashNow();
        }
        BillTItleFormulaVo formulaParams = new BillTItleFormulaVo();
        formulaParams.setProcessCreater(nickname);
        String formula = billTitle.getFormula();
        boolean timeFlag = billTitle.isTimeFlag();
        String day = timeFlag ? DateToStringUtil.yyyymmdash(todayDate) : DateToStringUtil.yyyymmdashNow();
        formulaParams.setToday(day);
        formulaParams.setProcessTypeName(billTitle.getProcessTypeName());
        formulaParams.setProcessName(billTitle.getProcessName());
        if (!Strings.isNullOrEmpty((String)formula)) {
            formula = "#{processName}-#{processCreater}-#{today}";
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression formulaExp = parser.parseExpression(formula, ParserContext.TEMPLATE_EXPRESSION);
        StandardEvaluationContext context = new StandardEvaluationContext((Object)formulaParams);
        return (String)formulaExp.getValue((EvaluationContext)context, String.class);
    }

    public BillTitleLogicImpl(ProcessBillTitleService billTitleService) {
        this.billTitleService = billTitleService;
    }
}

