/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jingtong.base.infra.entity.BaseEntity;
import com.jingtong.bpm.facde.dto.DatasourceDTO;
import com.jingtong.bpm.infra.entity.DatasourceComboEntity;
import com.jingtong.bpm.infra.entity.DatasourceConditionsEntity;
import com.jingtong.bpm.infra.entity.DatasourceFiledEntity;
import com.jingtong.bpm.infra.entity.DatasourcePopoverEntity;
import com.jingtong.bpm.infra.entity.ToaDatasourceEntity;
import com.jingtong.bpm.infra.po.TableFieldPO;
import com.jingtong.bpm.infra.service.DatasourceComboService;
import com.jingtong.bpm.infra.service.DatasourceConditionsService;
import com.jingtong.bpm.infra.service.DatasourceFiledService;
import com.jingtong.bpm.infra.service.DatasourcePopoverService;
import com.jingtong.bpm.infra.service.FormTableService;
import com.jingtong.bpm.infra.service.ToaDatasourceService;
import com.jingtong.bpm.logic.constant.ProcessCode;
import com.jingtong.bpm.logic.converts.DataSourceBasicConvert;
import com.jingtong.bpm.logic.dto.DataSourceFormDTO;
import com.jingtong.bpm.logic.dto.DatasourceComboDTO;
import com.jingtong.bpm.logic.dto.DatasourceConditionDTO;
import com.jingtong.bpm.logic.dto.DatasourcePagingDto;
import com.jingtong.bpm.logic.dto.DatasourcePopoverDTO;
import com.jingtong.bpm.logic.dto.ZZTableField;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.DataSourceLogic;
import com.jingtong.bpm.logic.vo.DatasourceComboPropVO;
import com.jingtong.bpm.logic.vo.DatasourceFieldVO;
import com.jingtong.bpm.logic.vo.DatasourcePopoverVO;
import com.jingtong.bpm.logic.vo.DatasourceVO;
import com.jingtong.bpm.logic.vo.LabelFieldVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.error.ErrorCode;
import com.jingtong.util.serialize.JsonMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSourceLogicImpl
implements DataSourceLogic {
    private final DatasourceComboService datasourceComboService;
    private final DatasourceConditionsService datasourceConditionsService;
    private final DatasourcePopoverService datasourcePopoverService;
    private final FormTableService formTableService;
    private final DatasourceFiledService dataSourceFiledService;
    private final ToaDatasourceService toaDatasourceService;
    private final DataSourceBasicConvert dataSourceBasicConvert;

    @Override
    public DatasourceComboDTO getComboByDatasourceId(long id) {
        DatasourceComboEntity comboEntity = (DatasourceComboEntity)((Object)this.datasourceComboService.getOne((Wrapper)Wrappers.lambdaQuery(DatasourceComboEntity.class).eq(DatasourceComboEntity::getDatasourceId, (Object)id)));
        return this.dataSourceBasicConvert.datasourceComboEntityToDTO(comboEntity);
    }

    @Override
    public List<DatasourceConditionDTO> getConditionByDataSourceId(long id) {
        List conditionsEntities = this.datasourceConditionsService.list((Wrapper)Wrappers.lambdaQuery(DatasourceConditionsEntity.class).eq(DatasourceConditionsEntity::getDatasourceId, (Object)id));
        return this.dataSourceBasicConvert.datasourceConditionsEntityToDTO(conditionsEntities);
    }

    @Override
    public DatasourcePopoverDTO getPopoverByDataSourceId(long id) {
        DatasourcePopoverEntity popoverServiceOne = (DatasourcePopoverEntity)((Object)this.datasourcePopoverService.getOne((Wrapper)Wrappers.lambdaQuery(DatasourcePopoverEntity.class).eq(DatasourcePopoverEntity::getDatasourceId, (Object)id)));
        return this.dataSourceBasicConvert.datasourcePopoverEntityToDTO(popoverServiceOne);
    }

    @Override
    public List<Map<String, Object>> executeSql(String sql, String field, String keyword) {
        String sql_script;
        String replace = StringUtils.replace((String)sql, (String)"##USERID##", (String)"1");
        HashMap param = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)field)) {
            HashMap tplParam = Maps.newHashMap();
            tplParam.put("sql", replace);
            tplParam.put("field", field);
            sql_script = StrUtil.format((CharSequence)"{sql} AND {field} LIKE #{{field}}", (Map)tplParam);
            param.put(field, SqlUtils.concatLike((Object)keyword, (SqlLike)SqlLike.DEFAULT));
        } else {
            sql_script = replace;
        }
        param.put("_sql", sql_script);
        try {
            return this.formTableService.executeSelectSql(sql_script, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RbException("", (ErrorCode)ProcessCode.SQL_SCRIPT_EXCUTE_ERROR);
        }
    }

    @Override
    public List<ZZTableField> getSqlSelectColumns(String sqlscript, long dataSourceId) {
        String replace2 = StringUtils.replace((String)sqlscript, (String)"##USERID##", (String)"1");
        HashMap fieldMap = Maps.newHashMap();
        if (dataSourceId > 0L) {
            List fileds = this.dataSourceFiledService.list((Wrapper)Wrappers.lambdaQuery(DatasourceFiledEntity.class).eq(DatasourceFiledEntity::getDatasourceId, (Object)dataSourceId));
            for (DatasourceFiledEntity filed : fileds) {
                fieldMap.put(filed.getFiledCode(), filed);
            }
        }
        ArrayList fieldOptionDtos = Lists.newArrayList();
        MySqlSelectParser selectParser = new MySqlSelectParser(replace2);
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)selectParser.query();
        List selectList = query.getSelectList();
        for (SQLSelectItem select : selectList) {
            ZZTableField tableField = new ZZTableField();
            SQLExpr sqlExpr = select.getExpr();
            String columnName = sqlExpr.getParent().toString();
            if (StringUtils.containsIgnoreCase((CharSequence)columnName, (CharSequence)"as")) {
                String lowerColomn = StringUtils.replace((String)columnName, (String)"AS", (String)"as");
                String fieldName = sqlExpr.toString();
                String replace = StringUtils.replace((String)lowerColomn, (String)fieldName, (String)"");
                String newColumnName = StringUtils.replace((String)replace, (String)"as", (String)"");
                tableField.setFieldName(fieldName);
                tableField.setColumnName(StringUtils.trim((String)newColumnName));
            } else {
                String[] columnAss = StringUtils.split((String)columnName, (String)".");
                if (columnAss.length > 1) {
                    tableField.setColumnName(columnAss[1]);
                    tableField.setFieldName(columnName);
                } else {
                    tableField.setColumnName(columnName);
                    tableField.setFieldName(columnName);
                }
            }
            DatasourceFiledEntity _field = (DatasourceFiledEntity)((Object)fieldMap.get(tableField.getColumnName()));
            if (_field != null) {
                tableField.setDisplayName(_field.getFiledName());
                tableField.setDataType(_field.getFiledType());
                tableField.setSort(_field.getSort());
            }
            fieldOptionDtos.add(tableField);
        }
        return fieldOptionDtos;
    }

    @Override
    public Pair<List<DatasourceDTO>, Long> getDatasourceByPage(Integer pageNo, Integer pageSize) {
        Page page = (Page)this.toaDatasourceService.page((IPage)new Page((long)pageNo.intValue(), (long)pageSize.intValue()));
        List records = page.getRecords();
        List<DatasourceDTO> list = this.dataSourceBasicConvert.datasourcesEntityToDTO(records);
        return new Pair(list, (Object)page.getTotal());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveDataSource(DataSourceFormDTO dataSourceFormDTO, String userCode) {
        ToaDatasourceEntity one;
        ToaDatasourceEntity dataSource = this.dataSourceBasicConvert.datasourceDTOToEntity(dataSourceFormDTO.getDataSource());
        List<DatasourceFiledEntity> fileds = this.dataSourceBasicConvert.datasourceFiledDTOToEntity(dataSourceFormDTO.getFileds());
        List<DatasourceConditionsEntity> conditions = this.dataSourceBasicConvert.datasourceConditionDTOToEntity(dataSourceFormDTO.getConditions());
        DatasourceComboEntity combo = this.dataSourceBasicConvert.datasourceComboDTOToEntity(dataSourceFormDTO.getCombo());
        DatasourcePopoverEntity popover = this.dataSourceBasicConvert.datasourcePopoverDTOToEntity(dataSourceFormDTO.getPopover());
        LocalDateTime now = LocalDateTime.now();
        Integer dsType = dataSource.getDsType();
        boolean isOk = true;
        if (ObjectUtil.isNotNull((Object)dsType)) {
            String sqlScript;
            if (dsType == 1 && CollectionUtil.isNotEmpty(fileds)) {
                StringBuilder sqlBuild = new StringBuilder("SELECT ");
                ArrayList cloumns = Lists.newArrayList();
                for (DatasourceFiledEntity filed : fileds) {
                    cloumns.add(filed.getFiledCode());
                }
                sqlBuild.append(StrUtil.join((CharSequence)",", (Object[])new Object[]{cloumns})).append(" ").append("FROM").append(" ").append(dataSource.getTableName());
                sqlScript = this.sqlAddConditions(sqlBuild, conditions);
                dataSource.setSqlScript(sqlScript);
            }
            if (dsType == 2) {
                String replace;
                sqlScript = dataSource.getSqlScript();
                String replace2 = StringUtils.replace((String)sqlScript, (String)"##USERID##", (String)"1");
                MySqlSelectParser selectParser = new MySqlSelectParser(replace2);
                MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)selectParser.query();
                SQLExpr queryWhere = query.getWhere();
                SQLOrderBy orderBy = query.getOrderBy();
                String maskWhereSql = "${WHERE_PARAMS}";
                maskWhereSql = maskWhereSql.replace("$", "\\$");
                maskWhereSql = maskWhereSql.replace("{", "\\{");
                maskWhereSql = maskWhereSql.replace("}", "\\}");
                if (queryWhere == null) {
                    if (orderBy != null) {
                        replace = "WHERE 1=1" + maskWhereSql + " " + "ORDER";
                        sqlScript = sqlScript.replaceAll("(?i)ORDER", replace);
                    } else {
                        StringBuilder sqlBuild = new StringBuilder(sqlScript);
                        sqlScript = sqlBuild.append(" ").append("WHERE").append(" ").append("1").append("=").append("1").append(" ").append("${WHERE_PARAMS}").toString();
                    }
                } else if (orderBy != null) {
                    replace = maskWhereSql + " " + "ORDER";
                    sqlScript = sqlScript.replaceAll("(?i)ORDER", replace);
                } else {
                    sqlScript = sqlScript + " ${WHERE_PARAMS}";
                }
                dataSource.setSqlScript(sqlScript);
            }
        }
        long dsId = (Long)MoreObjects.firstNonNull((Object)dataSource.getId(), (Object)0L);
        LambdaQueryWrapper datasourceLambdaQueryWrapper = Wrappers.lambdaQuery(ToaDatasourceEntity.class);
        if (dsId > 0L) {
            ((LambdaQueryWrapper)datasourceLambdaQueryWrapper.eq(ToaDatasourceEntity::getCode, (Object)dataSource.getCode())).ne(BaseEntity::getId, (Object)dsId);
            one = (ToaDatasourceEntity)((Object)this.toaDatasourceService.getOne((Wrapper)datasourceLambdaQueryWrapper));
            if (!Objects.isNull((Object)one)) {
                throw new RbException("\u7f16\u7801\u5df2\u5b58\u5728");
            }
            dataSource.setUpdateTime(now);
            this.deleteRefInfo(Lists.newArrayList((Object[])new String[]{dsId + ""}));
            isOk = this.toaDatasourceService.upldate(dataSource);
            if (!isOk) {
                throw new RbException("\u66f4\u65b0\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            dataSource.setCode(IdWorker.get32UUID());
            datasourceLambdaQueryWrapper.eq(ToaDatasourceEntity::getCode, (Object)dataSource.getCode());
            one = (ToaDatasourceEntity)((Object)this.toaDatasourceService.getOne((Wrapper)datasourceLambdaQueryWrapper));
            if (!Objects.isNull((Object)one)) {
                throw new RbException((ErrorCode)BillCode.DATASOURCE_CODE_EXIST);
            }
            dataSource.setCreationTime(now);
            isOk = this.toaDatasourceService.insert(dataSource);
        }
        long dataSourceId = dataSource.getId();
        if (CollectionUtil.isNotEmpty(fileds) && isOk) {
            for (DatasourceFiledEntity filed : fileds) {
                filed.setDatasourceId(dataSourceId);
                filed.setCreationTime(now);
            }
            boolean b = this.dataSourceFiledService.saveBatch(fileds);
            if (!b) {
                throw new RbException((ErrorCode)BillCode.DATASOURCE_FIELD_SAVE_ERROR);
            }
        }
        if (CollectionUtil.isNotEmpty(conditions) && isOk) {
            for (DatasourceConditionsEntity condition : conditions) {
                condition.setId(null);
                condition.setDatasourceId(dataSourceId);
                condition.setCreationTime(now);
            }
            boolean res = this.datasourceConditionsService.saveBatch(conditions);
            if (!res) {
                throw new RbException((ErrorCode)BillCode.DATASOURCE_CONDITION_SAVE_ERROR);
            }
        }
        if (combo != null) {
            combo.setId(null);
            combo.setDatasourceId(dataSourceId);
            combo.setCreationTime(now);
            boolean res = this.datasourceComboService.save((Object)combo);
            if (!res) {
                throw new RbException((ErrorCode)BillCode.DATASOURCE_SELECT_SAVE_ERROR);
            }
        }
        if (popover != null) {
            String searchFields;
            String tableHeadFields = popover.getTableHeadFields();
            if (!Strings.isNullOrEmpty((String)tableHeadFields)) {
                String tableHeadFieldsParseRes = this.parseField(tableHeadFields, fileds);
                popover.setTableHeadFields(tableHeadFieldsParseRes);
            }
            if (!Strings.isNullOrEmpty((String)(searchFields = popover.getSearchFields()))) {
                String searchFieldsParseRes = this.parseField(searchFields, fileds);
                popover.setSearchFields(searchFieldsParseRes);
            }
            popover.setDatasourceId(dataSourceId);
            popover.setCreationTime(now);
            popover.setId(null);
            boolean res = this.datasourcePopoverService.insert(popover);
            if (!res) {
                throw new RbException((ErrorCode)BillCode.DATASOURCE_EJECT_SAVE_ERROR);
            }
        }
        return isOk;
    }

    private void deleteRefInfo(List<String> dsId) {
        boolean removeState;
        boolean removeState2;
        boolean removeState3;
        boolean removeState4;
        LambdaQueryWrapper datasourceFiledLambdaQueryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(DatasourceFiledEntity.class).in(DatasourceFiledEntity::getDatasourceId, dsId);
        List datasourceFileds = this.dataSourceFiledService.list((Wrapper)datasourceFiledLambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)datasourceFileds) && !(removeState4 = this.dataSourceFiledService.remove((Wrapper)datasourceFiledLambdaQueryWrapper))) {
            throw new RbException((ErrorCode)BillCode.DATASOURCE_FILED_DEL_ERROR);
        }
        LambdaQueryWrapper conditionsLambdaQueryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(DatasourceConditionsEntity.class).in(DatasourceConditionsEntity::getDatasourceId, dsId);
        List datasourceConditionss = this.datasourceConditionsService.list((Wrapper)conditionsLambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)datasourceConditionss) && !(removeState3 = this.datasourceConditionsService.remove((Wrapper)conditionsLambdaQueryWrapper))) {
            throw new RbException((ErrorCode)BillCode.DATASOURCE_CONDITION_DEL_ERROR);
        }
        LambdaQueryWrapper datasourceComboLambdaQueryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(DatasourceComboEntity.class).in(DatasourceComboEntity::getDatasourceId, dsId);
        DatasourceComboEntity datasourceCombo = (DatasourceComboEntity)((Object)this.datasourceComboService.getOne((Wrapper)datasourceComboLambdaQueryWrapper));
        if (datasourceCombo != null && !(removeState2 = this.datasourceComboService.remove((Wrapper)datasourceComboLambdaQueryWrapper))) {
            throw new RbException((ErrorCode)BillCode.DATASOURCE_SELECT_DEL_ERROR);
        }
        LambdaQueryWrapper datasourcePopoverLambdaQueryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(DatasourcePopoverEntity.class).in(DatasourcePopoverEntity::getDatasourceId, dsId);
        DatasourcePopoverEntity datasourcePopover = (DatasourcePopoverEntity)((Object)this.datasourcePopoverService.getOne((Wrapper)datasourcePopoverLambdaQueryWrapper));
        if (datasourcePopover != null && !(removeState = this.datasourcePopoverService.remove((Wrapper)datasourcePopoverLambdaQueryWrapper))) {
            throw new RbException((ErrorCode)BillCode.DATASOURCE_EJECT_DEL_ERROR);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchDeleteDatasource(List<String> datasourceIds) {
        this.deleteRefInfo(datasourceIds);
        return this.toaDatasourceService.removeByIds(datasourceIds);
    }

    @Override
    public List<String> mysqlQueryTables() {
        return this.formTableService.mysqlQueryTables();
    }

    @Override
    public List<ZZTableField> ganerateTableFields(String tableName, long dataSourceId) {
        List<TableFieldPO> fieldPOS = this.formTableService.findColumnByTableName(tableName);
        List<ZZTableField> zzTableFields = this.dataSourceBasicConvert.tableFieldPOToField(fieldPOS);
        this.ganerateTableFields(dataSourceId, zzTableFields);
        return zzTableFields;
    }

    @Override
    public DataSourceFormDTO getDetailById(Long datasourceId) {
        ToaDatasourceEntity datasource = (ToaDatasourceEntity)((Object)this.toaDatasourceService.getById(datasourceId));
        DatasourcePopoverEntity datasourcePopoverEntity = (DatasourcePopoverEntity)((Object)this.datasourcePopoverService.getOne((Wrapper)Wrappers.lambdaQuery(DatasourcePopoverEntity.class).eq(DatasourcePopoverEntity::getDatasourceId, (Object)datasourceId)));
        DatasourceComboEntity datasourceComboEntity = (DatasourceComboEntity)((Object)this.datasourceComboService.getOne((Wrapper)Wrappers.lambdaQuery(DatasourceComboEntity.class).eq(DatasourceComboEntity::getDatasourceId, (Object)datasourceId)));
        DataSourceFormDTO dataSourceFormDTO = this.convertToDTO(datasource, datasourcePopoverEntity, datasourceComboEntity);
        return dataSourceFormDTO;
    }

    public DataSourceFormDTO convertToDTO(ToaDatasourceEntity datasourceEntity, DatasourcePopoverEntity datasourcePopoverEntity, DatasourceComboEntity datasourceComboEntity) {
        DataSourceFormDTO dataSourceFormDTO = new DataSourceFormDTO();
        if (!Objects.isNull((Object)datasourceEntity)) {
            dataSourceFormDTO.setDataSource(this.dataSourceBasicConvert.datasourceEntityToDTO(datasourceEntity));
        }
        if (!Objects.isNull((Object)datasourceEntity)) {
            dataSourceFormDTO.setPopover(this.dataSourceBasicConvert.datasourcePopoverEntityToDTO(datasourcePopoverEntity));
        }
        if (!Objects.isNull((Object)datasourceComboEntity)) {
            dataSourceFormDTO.setCombo(this.dataSourceBasicConvert.datasourceComboEntityToDTO(datasourceComboEntity));
        }
        return dataSourceFormDTO;
    }

    @Override
    public List<DatasourceVO> getAllWithForm() {
        List dataSources = this.toaDatasourceService.list((Wrapper)Wrappers.lambdaQuery(ToaDatasourceEntity.class).orderBy(true, true, (Object[])new SFunction[]{ToaDatasourceEntity::getSort}));
        if (CollectionUtil.isEmpty((Collection)dataSources)) {
            return Collections.emptyList();
        }
        List dataSourceFileds = this.dataSourceFiledService.list((Wrapper)Wrappers.lambdaQuery(DatasourceFiledEntity.class).orderBy(true, true, (Object[])new SFunction[]{DatasourceFiledEntity::getSort}));
        if (CollectionUtil.isEmpty((Collection)dataSourceFileds)) {
            return Collections.emptyList();
        }
        List comboList = this.datasourceComboService.list((Wrapper)Wrappers.lambdaQuery(DatasourceComboEntity.class).orderBy(true, true, (Object[])new SFunction[]{DatasourceComboEntity::getSort}));
        List popoverList = this.datasourcePopoverService.list();
        Map<Long, List<DatasourceFiledEntity>> groupResultMap = dataSourceFileds.stream().collect(Collectors.groupingBy(DatasourceFiledEntity::getDatasourceId));
        Map<Long, List<DatasourceComboEntity>> comboGroupResultMap = comboList.stream().collect(Collectors.groupingBy(DatasourceComboEntity::getDatasourceId));
        Map<Long, List<DatasourcePopoverEntity>> popoversGroupResultMap = popoverList.stream().collect(Collectors.groupingBy(DatasourcePopoverEntity::getDatasourceId));
        ArrayList datasourceVOList = Lists.newArrayListWithCapacity((int)dataSources.size());
        for (ToaDatasourceEntity dataSource : dataSources) {
            Collection datasourceCombos;
            DatasourceVO datasourceVO = new DatasourceVO();
            datasourceVO.setTable(dataSource.getCode());
            datasourceVO.setName(dataSource.getName());
            long dataSourceId = (Long)MoreObjects.firstNonNull((Object)dataSource.getId(), (Object)0L);
            List<DatasourceFiledEntity> fileds = groupResultMap.get(dataSourceId);
            if (CollectionUtil.isEmpty(fileds)) continue;
            ArrayList fieldVOS = Lists.newArrayList();
            HashMap filedTmpMap = Maps.newHashMap();
            for (DatasourceFiledEntity filed : fileds) {
                DatasourceFieldVO datasourceFieldVO = new DatasourceFieldVO();
                datasourceFieldVO.setField(filed.getFiledCode());
                datasourceFieldVO.setName(filed.getFiledName());
                datasourceFieldVO.setVtype(filed.getFiledType());
                datasourceFieldVO.setFieldAs(filed.getFiledAs());
                fieldVOS.add(datasourceFieldVO);
                filedTmpMap.put(filed.getFiledCode(), datasourceFieldVO);
            }
            datasourceVO.setFields(fieldVOS);
            Collection datasourcePopovers = popoversGroupResultMap.get(dataSourceId);
            if (CollectionUtil.isNotEmpty((Collection)datasourcePopovers)) {
                int idex = 0;
                for (DatasourcePopoverEntity datasourcePopover : datasourcePopovers) {
                    if (idex > 0) break;
                    DatasourcePopoverVO popoverVO = this.parseGenPopover(datasourcePopover);
                    datasourceVO.setPopover(popoverVO);
                    idex = 1;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(datasourceCombos = (Collection)comboGroupResultMap.get(dataSourceId)))) {
                int ci = 0;
                for (DatasourceComboEntity datasourceCombo : datasourceCombos) {
                    if (ci > 0) break;
                    DatasourceComboPropVO comboPropVO = this.parseGenCombo(filedTmpMap, datasourceCombo);
                    datasourceVO.setCombo(comboPropVO);
                    ci = 1;
                }
            }
            datasourceVOList.add(datasourceVO);
            filedTmpMap = null;
        }
        return datasourceVOList;
    }

    @Override
    public List<Map<String, Object>> execWithSelect(String table, Map<String, Object> queryMap, Page<Map<String, Object>> paging, String userCode) {
        ToaDatasourceEntity datasource;
        HashMap sqlParams = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(queryMap) && CollectionUtil.isNotEmpty(queryMap)) {
            for (String queryField : queryMap.keySet()) {
                String value = String.valueOf(queryMap.get(queryField));
                sqlParams.put(queryField, value);
            }
        }
        if ((datasource = (ToaDatasourceEntity)((Object)this.toaDatasourceService.getOne((Wrapper)Wrappers.lambdaQuery(ToaDatasourceEntity.class).eq(ToaDatasourceEntity::getCode, (Object)table)))) == null) {
            throw new RbException("", (ErrorCode)ProcessCode.DS_NOT_FOUND);
        }
        int dsType = (Integer)MoreObjects.firstNonNull((Object)datasource.getDsType(), (Object)0);
        switch (dsType) {
            case 1: 
            case 2: {
                String sql = datasource.getSqlScript();
                if (sql.contains("##USERID##")) {
                    sql = StringUtils.replace((String)sql, (String)"##USERID##", (String)userCode);
                }
                List<Map<String, Object>> datas = this.executeSqlWithLike(sql, sqlParams, paging);
                Long datasourceId = datasource.getId();
                List<String> fields = this.dataSourceFiledService.selectFieldsByDatasourceId(datasourceId);
                for (Map<String, Object> resultMapList : datas) {
                    for (String field : fields) {
                        if (resultMapList.containsKey(field)) continue;
                        resultMapList.put(field, "");
                    }
                }
                paging.setRecords(datas);
                return datas;
            }
        }
        paging.setRecords(Collections.emptyList());
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> execLinkquery(String table, String field, String query, String userCode) {
        ToaDatasourceEntity datasource = this.toaDatasourceService.findByCode(table);
        if (datasource == null) {
            throw new RbException("", (ErrorCode)ProcessCode.DS_NOT_FOUND);
        }
        int dsType = (Integer)MoreObjects.firstNonNull((Object)datasource.getDsType(), (Object)0);
        switch (dsType) {
            case 1: 
            case 2: {
                String sql = datasource.getSqlScript();
                sql = sql.replace("##EMPLOYEEID##", String.valueOf(userCode));
                return this.executeSqlByQuery(sql, field, query);
            }
        }
        return null;
    }

    private Map<String, Object> executeSqlByQuery(String sql, String field, String keyword) {
        HashMap sqlParams = Maps.newHashMap();
        sqlParams.put(field, keyword);
        Pair<String, Map<String, Object>> sqlAndParam = this.resoleEqualSqlAndParams(sql, sqlParams);
        String runSql = (String)sqlAndParam.getKey();
        Map params = (Map)sqlAndParam.getValue();
        List<Map<String, Object>> resultSets = this.formTableService.executeSelectSql(runSql, params);
        if (CollectionUtil.isNotEmpty(resultSets)) {
            return resultSets.get(0);
        }
        return Collections.emptyMap();
    }

    private Pair<String, Map<String, Object>> resoleEqualSqlAndParams(String sql, Map<String, String> sqlParams) {
        return this.resoleSqlAndParams(sql, sqlParams, "=");
    }

    private List<Map<String, Object>> executeSqlWithLike(String sql, Map<String, String> sqlParams, Page<Map<String, Object>> paging) {
        Pair<String, Map<String, Object>> sqlAndParam = this.resoleLikeSqlAndParams(sql, sqlParams);
        String runSql = (String)sqlAndParam.getKey();
        Map params = (Map)sqlAndParam.getValue();
        return this.formTableService.executePagingSql(paging, runSql, params);
    }

    private Pair<String, Map<String, Object>> resoleLikeSqlAndParams(String sql, Map<String, String> sqlParams) {
        return this.resoleSqlAndParams(sql, sqlParams, "LIKE");
    }

    private Pair<String, Map<String, Object>> resoleSqlAndParams(String sql, Map<String, String> sqlParams, String condition) {
        String sql_script;
        HashMap param = Maps.newHashMap();
        if (StringUtils.isEmpty((CharSequence)condition)) {
            condition = "=";
        }
        if (CollectionUtil.isNotEmpty(sqlParams)) {
            StringBuilder sqlWhereBuilder = new StringBuilder();
            for (String queryField : sqlParams.keySet()) {
                String queryValue = sqlParams.get(queryField);
                if (Strings.isNullOrEmpty((String)queryValue)) continue;
                HashMap tplParam = Maps.newHashMap();
                String filedMask = StringUtils.replace((String)queryField, (String)".", (String)"-");
                tplParam.put("field", queryField);
                tplParam.put("field_mask", filedMask);
                tplParam.put("condition", condition);
                String conditionSql = StrUtil.format((CharSequence)" AND {field} {condition} #{sql.{field_mask}}", (Map)tplParam);
                sqlWhereBuilder.append(conditionSql);
                if (StringUtils.equals((CharSequence)condition, (CharSequence)"=")) {
                    param.put(filedMask, queryValue);
                    continue;
                }
                param.put(filedMask, SqlUtils.concatLike((Object)queryValue, (SqlLike)SqlLike.DEFAULT));
            }
            sql_script = StringUtils.contains((CharSequence)sql, (CharSequence)"${WHERE_PARAMS}") ? StringUtils.replace((String)sql, (String)"${WHERE_PARAMS}", (String)sqlWhereBuilder.toString()) : sql + sqlWhereBuilder.toString();
        } else {
            sql_script = StringUtils.contains((CharSequence)sql, (CharSequence)"${WHERE_PARAMS}") ? StringUtils.replace((String)sql, (String)"${WHERE_PARAMS}", (String)"") : sql;
        }
        return Pair.of((Object)sql_script, (Object)param);
    }

    private DatasourceComboPropVO parseGenCombo(Map<String, DatasourceFieldVO> filedTmpMap, DatasourceComboEntity datasourceCombo) {
        DatasourceComboPropVO propVO = new DatasourceComboPropVO();
        if (datasourceCombo != null) {
            String valueField;
            String displayField = datasourceCombo.getDisplayField();
            if (!Strings.isNullOrEmpty((String)displayField)) {
                DatasourceFieldVO displayFieldVO = filedTmpMap.get(displayField);
                propVO.setDisplayField(displayFieldVO);
            }
            if (!Strings.isNullOrEmpty((String)(valueField = datasourceCombo.getValueField()))) {
                DatasourceFieldVO valueFieldVO = filedTmpMap.get(valueField);
                propVO.setValueField(valueFieldVO);
            }
        }
        return propVO;
    }

    private DatasourcePopoverVO parseGenPopover(DatasourcePopoverEntity datasourcePopover) {
        List headFields;
        String tableHeadFields;
        List searchFieldList;
        DatasourcePopoverVO popoverVO = new DatasourcePopoverVO();
        DatasourcePagingDto pagingVO = new DatasourcePagingDto();
        pagingVO.setEnable(datasourcePopover.getPageFlag() == 1);
        Integer pageSize = datasourcePopover.getPageSize();
        pagingVO.setPageSize((Integer)MoreObjects.firstNonNull((Object)pageSize, (Object)0));
        popoverVO.setPaging(pagingVO);
        String searchFields = datasourcePopover.getSearchFields();
        if (!Strings.isNullOrEmpty((String)searchFields) && CollectionUtil.isNotEmpty((Collection)(searchFieldList = JSON.parseArray((String)searchFields, LabelFieldVO.class)))) {
            ArrayList searchFieldVOS = Lists.newArrayListWithCapacity((int)searchFieldList.size());
            for (LabelFieldVO vo : searchFieldList) {
                searchFieldVOS.add(vo.toFieldVO());
            }
            popoverVO.setSearchItems(searchFieldVOS);
        }
        if (!Strings.isNullOrEmpty((String)(tableHeadFields = datasourcePopover.getTableHeadFields())) && CollectionUtil.isNotEmpty((Collection)(headFields = JSON.parseArray((String)tableHeadFields, LabelFieldVO.class)))) {
            ArrayList headFieldList = Lists.newArrayListWithCapacity((int)headFields.size());
            for (LabelFieldVO vo : headFields) {
                headFieldList.add(vo.toFieldVO());
            }
            popoverVO.setTableColumns(headFieldList);
        }
        return popoverVO;
    }

    private void ganerateTableFields(long dataSourceId, List<ZZTableField> tableFields) {
        if (dataSourceId > 0L) {
            List fileds = this.dataSourceFiledService.list((Wrapper)Wrappers.lambdaQuery(DatasourceFiledEntity.class).eq(DatasourceFiledEntity::getDatasourceId, (Object)dataSourceId));
            HashMap fieldMap = Maps.newHashMap();
            for (DatasourceFiledEntity filed : fileds) {
                fieldMap.put(filed.getFiledCode(), filed);
            }
            for (ZZTableField tableField : tableFields) {
                String columnName = tableField.getColumnName();
                if (!fieldMap.containsKey(columnName)) continue;
                DatasourceFiledEntity _field = (DatasourceFiledEntity)((Object)fieldMap.get(columnName));
                tableField.setDisplayName(_field.getFiledName());
                tableField.setDataType(_field.getFiledType());
                tableField.setSort(_field.getSort());
            }
        }
    }

    private String parseField(String fields, List<DatasourceFiledEntity> datasourceFileds) {
        ArrayList fieldList = Lists.newArrayList();
        List fieldStrs = JSON.parseArray((String)fields, String.class);
        for (String fieldStr : fieldStrs) {
            for (DatasourceFiledEntity datasourceFiled : datasourceFileds) {
                if (!fieldStr.contains(datasourceFiled.getFiledCode())) continue;
                HashMap fieldTemp = Maps.newHashMap();
                fieldTemp.put("label", datasourceFiled.getFiledName());
                fieldTemp.put("field", fieldStr);
                fieldList.add(fieldTemp);
            }
        }
        return JsonMapper.toJson((Object)fieldList);
    }

    private String sqlAddConditions(StringBuilder sqlBuild, List<DatasourceConditionsEntity> conditions) {
        sqlBuild.append(" ").append("WHERE").append(" ");
        if (CollectionUtil.isNotEmpty(conditions)) {
            for (DatasourceConditionsEntity condition : conditions) {
                if (Objects.isNull(condition.getInputFlag()) || condition.getInputFlag() != 1) {
                    sqlBuild.append(condition.getConditionCode()).append("=").append(condition.getInputValue()).append(" ").append("AND").append(" ");
                    continue;
                }
                sqlBuild.append(condition.getConditionCode()).append("=").append("?").append(" ").append("AND").append(" ");
            }
        }
        return sqlBuild.append(1).append("=").append(1).append(" ").toString();
    }

    public DataSourceLogicImpl(DatasourceComboService datasourceComboService, DatasourceConditionsService datasourceConditionsService, DatasourcePopoverService datasourcePopoverService, FormTableService formTableService, DatasourceFiledService dataSourceFiledService, ToaDatasourceService toaDatasourceService, DataSourceBasicConvert dataSourceBasicConvert) {
        this.datasourceComboService = datasourceComboService;
        this.datasourceConditionsService = datasourceConditionsService;
        this.datasourcePopoverService = datasourcePopoverService;
        this.formTableService = formTableService;
        this.dataSourceFiledService = dataSourceFiledService;
        this.toaDatasourceService = toaDatasourceService;
        this.dataSourceBasicConvert = dataSourceBasicConvert;
    }
}

