/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jingtong.bpm.infra.entity.BillTaskEntity;
import com.jingtong.bpm.infra.entity.ToaBillEntity;
import com.jingtong.bpm.infra.service.ToaBillService;
import com.jingtong.bpm.logic.constant.BillTaskStatus;
import com.jingtong.bpm.logic.constant.BillTaskType;
import com.jingtong.bpm.logic.dto.FlowMsgDTO;
import com.jingtong.bpm.logic.service.FlowMsgLogic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FlowMsgLogicImpl
implements FlowMsgLogic {
    private static final Logger log = LoggerFactory.getLogger(FlowMsgLogicImpl.class);
    private final ToaBillService billService;

    @Override
    public void sendMsg(List<BillTaskEntity> billTaskEntities) {
        BillTaskEntity billTaskEntity;
        Long billId;
        Optional billOpt;
        if (CollectionUtil.isNotEmpty(billTaskEntities) && (billOpt = this.billService.unique(billId = (billTaskEntity = billTaskEntities.get(0)).getBillId())).isPresent()) {
            ToaBillEntity toaBillEntity = (ToaBillEntity)((Object)billOpt.get());
            String title = toaBillEntity.getTitle();
            String createUserCode = toaBillEntity.getSender();
            ArrayList allMsg = Lists.newArrayList();
            for (BillTaskEntity taskEntity : billTaskEntities) {
                Integer taskType = taskEntity.getTaskType();
                BillTaskType billTaskType = BillTaskType.forValue(taskType);
                List<Object> flowMsgDTOS = Lists.newArrayList();
                switch (billTaskType) {
                    case DEFAULT: {
                        flowMsgDTOS = this.defaultNodeType(taskEntity, createUserCode, title);
                        break;
                    }
                    case SKIP: {
                        flowMsgDTOS = this.skipNodeType(taskEntity, createUserCode, title);
                        break;
                    }
                    case ENDORSE: {
                        flowMsgDTOS = this.endorseNodeType(taskEntity, createUserCode, title);
                        break;
                    }
                    case TRANSFER: {
                        flowMsgDTOS = this.transferNodeType(taskEntity, createUserCode, title);
                        break;
                    }
                    case TURN: {
                        flowMsgDTOS = this.turnNodeType(taskEntity, createUserCode, title);
                    }
                }
                allMsg.addAll(flowMsgDTOS);
            }
            log.info("\u63a8\u9001\u7684\u6d88\u606f\u662f:{}", (Object)allMsg);
        }
    }

    private List<FlowMsgDTO> turnNodeType(BillTaskEntity taskEntity, String createUser, String title) {
        Integer nodeStatus = taskEntity.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(nodeStatus);
        Set receivers = Sets.newConcurrentHashSet();
        String approver = taskEntity.getUserCode();
        String content = "\u79fb\u4ea4" + this.getContent(createUser, billTaskStatus, receivers, approver);
        ArrayList msgDTOS = Lists.newArrayListWithExpectedSize((int)receivers.size());
        receivers.forEach(a -> {
            FlowMsgDTO flowMsgDTO = FlowMsgDTO.build(a, createUser, content, title, taskEntity.getNodeName(), taskEntity.getOpinion());
            msgDTOS.add(flowMsgDTO);
        });
        return msgDTOS;
    }

    private List<FlowMsgDTO> transferNodeType(BillTaskEntity taskEntity, String createUser, String title) {
        Integer nodeStatus = taskEntity.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(nodeStatus);
        Set receivers = Sets.newConcurrentHashSet();
        String approver = taskEntity.getUserCode();
        String content = "\u8f6c\u529e" + this.getContent(createUser, billTaskStatus, receivers, approver);
        ArrayList msgDTOS = Lists.newArrayListWithExpectedSize((int)receivers.size());
        receivers.forEach(a -> {
            FlowMsgDTO flowMsgDTO = FlowMsgDTO.build(a, createUser, content, title, taskEntity.getNodeName(), taskEntity.getOpinion());
            msgDTOS.add(flowMsgDTO);
        });
        return msgDTOS;
    }

    private List<FlowMsgDTO> endorseNodeType(BillTaskEntity taskEntity, String createUser, String title) {
        Integer nodeStatus = taskEntity.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(nodeStatus);
        Set receivers = Sets.newConcurrentHashSet();
        String approver = taskEntity.getUserCode();
        String content = "\u52a0\u7b7e" + this.getContent(createUser, billTaskStatus, receivers, approver);
        ArrayList msgDTOS = Lists.newArrayListWithExpectedSize((int)receivers.size());
        receivers.forEach(a -> {
            FlowMsgDTO flowMsgDTO = FlowMsgDTO.build(a, createUser, content, title, taskEntity.getNodeName(), taskEntity.getOpinion());
            msgDTOS.add(flowMsgDTO);
        });
        return msgDTOS;
    }

    private List<FlowMsgDTO> skipNodeType(BillTaskEntity taskEntity, String createUser, String title) {
        Integer nodeStatus = taskEntity.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(nodeStatus);
        Set receivers = Sets.newConcurrentHashSet();
        String approver = taskEntity.getUserCode();
        String content = this.getContent(createUser, billTaskStatus, receivers, approver);
        ArrayList msgDTOS = Lists.newArrayListWithExpectedSize((int)receivers.size());
        receivers.forEach(a -> {
            if (!a.equals("0")) {
                FlowMsgDTO flowMsgDTO = FlowMsgDTO.build(a, createUser, content, title, taskEntity.getNodeName(), taskEntity.getOpinion());
                msgDTOS.add(flowMsgDTO);
            }
        });
        return msgDTOS;
    }

    private List<FlowMsgDTO> defaultNodeType(BillTaskEntity taskEntity, String createUser, String title) {
        Integer nodeStatus = taskEntity.getNodeStatus();
        BillTaskStatus billTaskStatus = BillTaskStatus.valueTo(nodeStatus);
        Set receivers = Sets.newConcurrentHashSet();
        String approver = taskEntity.getUserCode();
        String content = this.getContent(createUser, billTaskStatus, receivers, approver);
        ArrayList msgDTOS = Lists.newArrayListWithExpectedSize((int)receivers.size());
        receivers.forEach(a -> {
            FlowMsgDTO flowMsgDTO = FlowMsgDTO.build(a, createUser, content, title, taskEntity.getNodeName(), taskEntity.getOpinion());
            msgDTOS.add(flowMsgDTO);
        });
        return msgDTOS;
    }

    @NotNull
    private String getContent(String createUser, BillTaskStatus billTaskStatus, Set<String> receivers, String approver) {
        String content;
        switch (billTaskStatus) {
            case APPROVAL: {
                content = "\u5ba1\u6279\u4e2d";
                receivers.add(approver);
                break;
            }
            case SKIP: {
                content = "\u81ea\u52a8\u8df3\u8fc7";
                break;
            }
            case ENDORSE: {
                content = "\u52a0\u7b7e";
                receivers.add(approver);
                break;
            }
            case AGREE: {
                content = "\u5df2\u540c\u610f";
                receivers.add(approver);
                receivers.add(createUser);
                break;
            }
            case REFUSE: {
                content = "\u5df2\u62d2\u7edd";
                receivers.add(approver);
                receivers.add(createUser);
                break;
            }
            case REPULSE: {
                content = "\u5df2\u9000\u56de";
                receivers.add(approver);
                receivers.add(createUser);
                break;
            }
            case TRANSFER: {
                content = "\u5df2\u8f6c\u529e";
                receivers.add(approver);
                break;
            }
            case TURN: {
                content = "\u5df2\u79fb\u4ea4";
                receivers.add(approver);
                break;
            }
            case REFUSE_FILL_IN: {
                content = "\u91cd\u65b0\u586b\u5199";
                receivers.add(createUser);
                break;
            }
            default: {
                content = "";
            }
        }
        return content;
    }

    public FlowMsgLogicImpl(ToaBillService billService) {
        this.billService = billService;
    }
}

