/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.io.Files;
import com.jingtong.base.infra.entity.BaseEntity;
import com.jingtong.bpm.infra.entity.FormSettingEntity;
import com.jingtong.bpm.infra.entity.ToaFormEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.service.FormSettingService;
import com.jingtong.bpm.infra.service.ToaFormService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.service.FormSettingLogic;
import com.jingtong.bpm.logic.util.DateToStringUtil;
import com.jingtong.config.BpmConfig;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FormSettingLogicImpl
implements FormSettingLogic {
    private final ToaFormService formService;
    private final FormSettingService formSettingService;
    private final BpmConfig bpmConfig;
    private final ToaProcessService processService;

    @Override
    public boolean updatePrintTemp(Long processId, MultipartFile file) {
        String fileType = Files.getFileExtension((String)file.getOriginalFilename());
        String newFileName = IdWorker.get32UUID() + "." + fileType;
        String dateStr = DateToStringUtil.yyyymmdashNow();
        String replace = dateStr.replace("-", File.separator);
        String relativePath = replace + File.separator + newFileName;
        String resultPath = this.bpmConfig.getFilePath() + File.separator + relativePath;
        File tempFile = new File(resultPath);
        try {
            Files.createParentDirs((File)tempFile);
            file.transferTo(tempFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Optional unique = this.formService.unique((LambdaQueryWrapper)Wrappers.lambdaQuery(ToaFormEntity.class).eq(ToaFormEntity::getProcessId, (Object)processId));
        if (unique.isPresent()) {
            FormSettingEntity formSettingEntity;
            ToaFormEntity toaFormEntity = (ToaFormEntity)((Object)unique.get());
            Optional<FormSettingEntity> unique1 = this.formSettingService.findByFormId(toaFormEntity.getId());
            if (unique1.isPresent()) {
                formSettingEntity = unique1.get();
                formSettingEntity.setUpdateTime(LocalDateTime.now());
            } else {
                formSettingEntity = new FormSettingEntity();
                formSettingEntity.setCreationTime(LocalDateTime.now());
                formSettingEntity.setFormId(toaFormEntity.getId());
            }
            formSettingEntity.setPrintTemplatePath(relativePath);
            formSettingEntity.setPrintTemplateUrl(relativePath);
            return this.formSettingService.saveOrUpdate((Object)formSettingEntity);
        }
        return false;
    }

    @Override
    public boolean updateFormLink(long processId, String formLink, String approveLink, Integer manualStartFlag) {
        Optional unique = this.formService.unique((LambdaQueryWrapper)Wrappers.lambdaQuery(ToaFormEntity.class).eq(ToaFormEntity::getProcessId, (Object)processId));
        if (unique.isPresent()) {
            FormSettingEntity formSettingEntity;
            ToaFormEntity toaFormEntity = (ToaFormEntity)((Object)unique.get());
            Optional<FormSettingEntity> unique1 = this.formSettingService.findByFormId(toaFormEntity.getId());
            if (unique1.isPresent()) {
                formSettingEntity = unique1.get();
                formSettingEntity.setUpdateTime(LocalDateTime.now());
            } else {
                formSettingEntity = new FormSettingEntity();
                formSettingEntity.setCreationTime(LocalDateTime.now());
                formSettingEntity.setFormId(toaFormEntity.getId());
            }
            formSettingEntity.setFormLink(formLink);
            formSettingEntity.setApproveLink(approveLink);
            this.processService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ToaProcessEntity.class).set(ToaProcessEntity::getAssistant, (Object)manualStartFlag)).eq(BaseEntity::getId, (Object)processId));
            return this.formSettingService.saveOrUpdate((Object)formSettingEntity);
        }
        return false;
    }

    public FormSettingLogicImpl(ToaFormService formService, FormSettingService formSettingService, BpmConfig bpmConfig, ToaProcessService processService) {
        this.formService = formService;
        this.formSettingService = formSettingService;
        this.bpmConfig = bpmConfig;
        this.processService = processService;
    }
}

