/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.googlecode.aviator.AviatorEvaluator;
import com.jingtong.bpm.infra.entity.ProcessNodeApproverEntity;
import com.jingtong.bpm.infra.service.ProcessNodeApproverService;
import com.jingtong.bpm.logic.constant.FastJsonType;
import com.jingtong.bpm.logic.context.BpmnBillContext;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.service.NodeApproverLogic;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.bpm.logic.vo.FieldVO;
import com.jingtong.bpm.logic.vo.NodeSubjectVO;
import com.jingtong.bpm.logic.vo.TreeDataVO;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.activiti.engine.delegate.DelegateTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NodeApproverLogicImpl
implements NodeApproverLogic {
    private static final Logger log = LoggerFactory.getLogger(NodeApproverLogicImpl.class);
    private final ProcessNodeApproverService processNodeApproverService;
    private final UserCenterlogic userCenterlogic;
    private final LoginUserHolder loginUserHolder;

    @Override
    public Map<Long, Set<String>> resolve(String flowId, String nodeId, DelegateTask delegateTask) {
        ConcurrentMap result = Maps.newConcurrentMap();
        String nextApprover = (String)delegateTask.getVariable("var_next_approver");
        log.info("\u624b\u52a8\u9009\u62e9\u5ba1\u6279\u4eba\u4fe1\u606f:{}", (Object)nextApprover);
        if (!Strings.isNullOrEmpty((String)nextApprover) && !nextApprover.equals("0")) {
            List split = StrUtil.split((CharSequence)nextApprover, (char)',');
            HashSet approvers = new HashSet(split);
            result.put(0L, approvers);
            return result;
        }
        log.info("\u6ca1\u6709\u624b\u52a8\u8bbe\u7f6e\u5ba1\u6279\u4eba");
        String businessKey = delegateTask.getExecution().getProcessInstanceBusinessKey();
        List<ProcessNodeApproverEntity> nodeApprovers = this.processNodeApproverService.findByFlowIdAndNodeId(flowId, nodeId);
        if (CollectionUtil.isEmpty(nodeApprovers)) {
            log.warn("the node {} and billId {} has not approvers!!!", (Object)nodeId, (Object)businessKey);
            return Collections.emptyMap();
        }
        Map formDataMap = (Map)delegateTask.getVariable("var_formData");
        String applyEmployeeJSON = (String)delegateTask.getVariable("var_bill_context");
        BpmnBillContext billContext = (BpmnBillContext)JSON.parseObject((String)applyEmployeeJSON, BpmnBillContext.class);
        HashSet employeeApprovers = Sets.newHashSet();
        for (ProcessNodeApproverEntity nodeApprover : nodeApprovers) {
            String approver = nodeApprover.getApprover();
            if (Strings.isNullOrEmpty((String)approver)) continue;
            String express = nodeApprover.getExpress();
            if (!Strings.isNullOrEmpty((String)express)) {
                Boolean conditionResult;
                String expressParams = nodeApprover.getExpressParams();
                HashMap env = Maps.newHashMap();
                if (StringUtils.contains((CharSequence)express, (CharSequence)"var_formData")) {
                    env.put("var_formData", formDataMap);
                }
                if (StringUtils.contains((CharSequence)express, (CharSequence)"var_apply_employee")) {
                    env.put("var_apply_employee", String.valueOf(billContext.getId()));
                }
                env.putAll(billContext.toEnvParam(express));
                if (!Strings.isNullOrEmpty((String)expressParams)) {
                    Map expressParamMap = (Map)JSON.parseObject((String)expressParams, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]);
                    env.putAll(expressParamMap);
                }
                try {
                    conditionResult = (Boolean)AviatorEvaluator.execute((String)express, (Map)env);
                }
                catch (Exception e) {
                    log.error("Express exec has error ! express is \n {} \n ---- param is \n {}", (Object)express, JSON.toJSON((Object)env));
                    conditionResult = false;
                }
                if (!conditionResult.booleanValue()) continue;
                List nodeSubjectVOS = JSON.parseArray((String)approver, NodeSubjectVO.class);
                for (NodeSubjectVO nodeSubjectVO : nodeSubjectVOS) {
                    Set<String> employees = this.resolveSubject(nodeSubjectVO, billContext, formDataMap);
                    employeeApprovers.addAll(employees);
                }
                result.put(nodeApprover.getId(), employeeApprovers);
                break;
            }
            List nodeSubjectVOS = JSON.parseArray((String)approver, NodeSubjectVO.class);
            for (NodeSubjectVO nodeSubjectVO : nodeSubjectVOS) {
                Set<String> employees = this.resolveSubject(nodeSubjectVO, billContext, formDataMap);
                employeeApprovers.addAll(employees);
            }
            result.put(nodeApprover.getId(), employeeApprovers);
            break;
        }
        return result;
    }

    private Set<String> resolveSubject(NodeSubjectVO nodeSubject, BpmnBillContext billContext, Map<String, Object> formDataMap) {
        int type = nodeSubject.getType();
        switch (type) {
            case 1: {
                int hrType = nodeSubject.getHrType();
                switch (hrType) {
                    case 1: {
                        return nodeSubject.assignEmployee();
                    }
                    case 2: {
                        return this.assignOrganizationApply(nodeSubject, billContext);
                    }
                    case 3: {
                        List<TreeDataVO> positions = nodeSubject.getPositions();
                        HashSet employeeIds = Sets.newHashSet();
                        for (TreeDataVO position : positions) {
                            long positionId = (Long)MoreObjects.firstNonNull((Object)position.getId(), (Object)0L);
                            Set<String> userIdSet = this.userCenterlogic.getOrgPositionUser(positionId, this.loginUserHolder.getBloc());
                            if (!CollectionUtil.isNotEmpty(userIdSet)) continue;
                            employeeIds.addAll(userIdSet);
                        }
                        return employeeIds;
                    }
                    case 4: {
                        return Sets.newHashSet((Object[])new String[]{String.valueOf(0L)});
                    }
                }
                break;
            }
            case 5: {
                List strings;
                FieldVO field = nodeSubject.getField();
                String widgetName = field.getWidgetName();
                Object o = formDataMap.get(widgetName);
                String s = o.toString();
                HashSet tmpUserIds = Sets.newHashSet();
                if (s.indexOf(",") != -1) {
                    strings = StrUtil.split((CharSequence)s, (char)',');
                    tmpUserIds.addAll(new HashSet(strings));
                } else if (!s.startsWith("[")) {
                    tmpUserIds.addAll(Sets.newHashSet((Object[])new String[]{s}));
                } else {
                    strings = JSON.parseArray((String)s, String.class);
                    tmpUserIds.addAll(new HashSet(strings));
                }
                HashSet userIds = Sets.newHashSet();
                tmpUserIds.forEach(a -> {
                    if (a.indexOf(".") != -1) {
                        a = (String)StrUtil.split((CharSequence)a, (char)'.').get(0);
                    }
                    userIds.add(a);
                });
                return userIds;
            }
        }
        return Collections.emptySet();
    }

    private Set<String> assignOrganizationApply(NodeSubjectVO nodeSubject, BpmnBillContext applyEmployee) {
        int orgType = nodeSubject.getOrgType();
        switch (orgType) {
            case 1: {
                return Sets.newHashSet((Object[])new String[]{String.valueOf(0L)});
            }
            case 2: {
                String orgId = applyEmployee.getOrg().getCode();
                List<TreeDataVO> positions = nodeSubject.getPositions();
                HashSet employeeIds = Sets.newHashSet();
                for (TreeDataVO position : positions) {
                    long positionId = (Long)MoreObjects.firstNonNull((Object)position.getId(), (Object)0L);
                    Set<String> userIdsSet = this.userCenterlogic.getOrgPositionUser(positionId, orgId);
                    if (!CollectionUtil.isNotEmpty(userIdsSet)) continue;
                    employeeIds.addAll(userIdsSet);
                }
                return employeeIds;
            }
        }
        return Collections.emptySet();
    }

    public NodeApproverLogicImpl(ProcessNodeApproverService processNodeApproverService, UserCenterlogic userCenterlogic, LoginUserHolder loginUserHolder) {
        this.processNodeApproverService = processNodeApproverService;
        this.userCenterlogic = userCenterlogic;
        this.loginUserHolder = loginUserHolder;
    }
}

