/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.googlecode.aviator.AviatorEvaluator;
import com.jingtong.bpm.infra.entity.ProcessNodeCcEntity;
import com.jingtong.bpm.infra.service.ProcessNodeCcService;
import com.jingtong.bpm.logic.constant.FastJsonType;
import com.jingtong.bpm.logic.context.BpmnBillContext;
import com.jingtong.bpm.logic.service.NodeCcLogic;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.bpm.logic.vo.NodeSubjectVO;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.delegate.DelegateTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NodeCcLogicImpl
implements NodeCcLogic {
    private static final Logger log = LoggerFactory.getLogger(NodeCcLogicImpl.class);
    private final ProcessNodeCcService processNodeCcService;
    private final UserCenterlogic userCenterlogic;

    @Override
    public Set<String> resolve(String flowId, String nodeId, DelegateTask delegateTask, List<String> approverEmployeeIds) {
        String businessKey = delegateTask.getExecution().getProcessInstanceBusinessKey();
        List<ProcessNodeCcEntity> ccUsers = this.processNodeCcService.findByFlowIdAndNodeId(flowId, nodeId);
        if (CollectionUtil.isEmpty(ccUsers)) {
            log.warn("the node {} and billId {} has not ccUsers!!!", (Object)nodeId, (Object)businessKey);
            return Collections.emptySet();
        }
        Map formDataMap = (Map)delegateTask.getVariable("var_formData");
        String billContextJSON = (String)delegateTask.getVariable("var_bill_context");
        BpmnBillContext billContext = (BpmnBillContext)JSON.parseObject((String)billContextJSON, BpmnBillContext.class);
        HashSet employeeApprovers = Sets.newHashSet();
        for (ProcessNodeCcEntity ccUser : ccUsers) {
            Boolean conditionResult;
            String tmpCcUser = ccUser.getCc();
            if (Strings.isNullOrEmpty((String)tmpCcUser)) continue;
            String express = ccUser.getExpress();
            if (Strings.isNullOrEmpty((String)express)) {
                List nodeSubjectVOS = JSON.parseArray((String)tmpCcUser, NodeSubjectVO.class);
                for (NodeSubjectVO nodeSubjectVO : nodeSubjectVOS) {
                    Set<String> employees = this.resolveSubject(nodeSubjectVO, billContext, approverEmployeeIds);
                    employeeApprovers.addAll(employees);
                }
                continue;
            }
            String expressParams = ccUser.getExpressParams();
            HashMap env = Maps.newHashMap();
            if (StringUtils.contains((CharSequence)express, (CharSequence)"var_formData")) {
                env.put("var_formData", formDataMap);
            }
            env.putAll(billContext.toEnvParam(express));
            if (!Strings.isNullOrEmpty((String)expressParams)) {
                env.putAll((Map)JSON.parseObject((String)expressParams, FastJsonType.MAP_OBJECT_TR, (Feature[])new Feature[0]));
            }
            if (!(conditionResult = (Boolean)AviatorEvaluator.execute((String)express, (Map)env)).booleanValue()) continue;
            List nodeSubjectVOS = JSON.parseArray((String)tmpCcUser, NodeSubjectVO.class);
            for (NodeSubjectVO nodeSubjectVO : nodeSubjectVOS) {
                Set<String> employees = this.resolveSubject(nodeSubjectVO, billContext, approverEmployeeIds);
                employeeApprovers.addAll(employees);
            }
        }
        return employeeApprovers;
    }

    private Set<String> resolveSubject(NodeSubjectVO nodeSubject, BpmnBillContext applyEmployee, List<String> approvarEmployeeId) {
        HashSet userIdStrs = Sets.newHashSet();
        int type = nodeSubject.getType();
        switch (type) {
            case 1: {
                userIdStrs.addAll(nodeSubject.assignEmployee());
                break;
            }
            case 2: {
                String userId = applyEmployee.getId();
                Set<String> userIds = this.userCenterlogic.getLeaderIdByUserIds(Lists.newArrayList((Object[])new String[]{userId}));
                userIdStrs.addAll(userIds);
                break;
            }
            case 3: {
                Set<String> userIds = this.userCenterlogic.getLeaderIdByUserIds(approvarEmployeeId);
                userIdStrs.addAll(userIds);
                break;
            }
        }
        return userIdStrs;
    }

    public NodeCcLogicImpl(ProcessNodeCcService processNodeCcService, UserCenterlogic userCenterlogic) {
        this.processNodeCcService = processNodeCcService;
        this.userCenterlogic = userCenterlogic;
    }
}

