/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.jingtong.bpm.infra.entity.FormDesingerEntity;
import com.jingtong.bpm.infra.entity.ProcessDesingerEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeApproverEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeCcEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeConnectionEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeExtendEntity;
import com.jingtong.bpm.infra.entity.ProcessNodeFormFieldEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.service.FormDesingerService;
import com.jingtong.bpm.infra.service.ProcessDesingerService;
import com.jingtong.bpm.infra.service.ProcessNodeApproverService;
import com.jingtong.bpm.infra.service.ProcessNodeCcService;
import com.jingtong.bpm.infra.service.ProcessNodeConnectionService;
import com.jingtong.bpm.infra.service.ProcessNodeExtendService;
import com.jingtong.bpm.infra.service.ProcessNodeFormFieldService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.comparator.ConditionWeightComparator;
import com.jingtong.bpm.logic.comparator.NodeApproverComparator;
import com.jingtong.bpm.logic.comparator.NodeCcComparator;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.constant.ProcessAdminCode;
import com.jingtong.bpm.logic.converts.FormBasicConvert;
import com.jingtong.bpm.logic.converts.ProcessBasicConvert;
import com.jingtong.bpm.logic.dto.FormDesingerDTO;
import com.jingtong.bpm.logic.dto.ProcessDesingerDTO;
import com.jingtong.bpm.logic.dto.ProcessDetailDTO;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.exception.ListenerNotFoundException;
import com.jingtong.bpm.logic.service.ProcessDesingerLogic;
import com.jingtong.bpm.logic.vo.ConditionVo;
import com.jingtong.bpm.logic.vo.CountersignVO;
import com.jingtong.bpm.logic.vo.LineConditionVO;
import com.jingtong.bpm.logic.vo.NodeApproverVO;
import com.jingtong.bpm.logic.vo.NodeCcVO;
import com.jingtong.bpm.logic.vo.NodeSubjectVO;
import com.jingtong.bpm.logic.vo.ProcessDesingerVO;
import com.jingtong.bpm.logic.vo.ProcessNodeVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.ErrorCode;
import java.io.ByteArrayInputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessDesingerLogicImpl
implements ProcessDesingerLogic {
    private static final Logger log = LoggerFactory.getLogger(ProcessDesingerLogicImpl.class);
    private final ToaProcessService toaProcessService;
    private final FormDesingerService formDesingerService;
    private final ProcessDesingerService processDesingerService;
    private final ProcessNodeFormFieldService nodeFormFieldService;
    private final ProcessNodeExtendService nodeExtendService;
    private final ProcessNodeApproverService nodeApproverService;
    private final ProcessNodeConnectionService nodeConnectionService;
    private final ProcessNodeCcService nodeCcService;
    private final ProcessBasicConvert processBasicConvert;
    private final FormBasicConvert formBasicConvert;

    @Override
    public ProcessDetailDTO getByProecessId(long processId) {
        ToaProcessEntity processEntity = (ToaProcessEntity)((Object)this.toaProcessService.getById(Long.valueOf(processId)));
        return this.processBasicConvert.processDetailEntityToDTO(processEntity);
    }

    @Override
    public FormDesingerDTO getDesingerJSON(long processId) {
        FormDesingerEntity formDesingerEntity = this.formDesingerService.getByProcessId(processId);
        return this.formBasicConvert.formDesingerEntityToDTO(formDesingerEntity);
    }

    @Override
    public ProcessDesingerDTO getDesingerById(long processId) {
        ProcessDesingerEntity desingerEntity = (ProcessDesingerEntity)((Object)this.processDesingerService.getOne((Wrapper)Wrappers.lambdaQuery(ProcessDesingerEntity.class).eq(ProcessDesingerEntity::getProcessId, (Object)processId)));
        return this.processBasicConvert.processDesingerEntityToDTO(desingerEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveProcessAndSetting(String processDesingerJSON, long processId) {
        ProcessDesingerVO processDesingerVO;
        processDesingerJSON = processDesingerJSON.replace("exclusiveGateway", "parallelGateway");
        processDesingerJSON = processDesingerJSON.replace("Exclusive", "Parallel");
        try {
            processDesingerVO = (ProcessDesingerVO)JSON.parseObject((String)processDesingerJSON, ProcessDesingerVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RbException((ErrorCode)BillCode.PROCESS_DESIGN_FORMAT_ERROR);
        }
        String processXML = processDesingerVO.getXml();
        if (Strings.isNullOrEmpty((String)processXML)) {
            throw new RbException((ErrorCode)BillCode.PROCESS_DESIGN_FORMAT_ERROR);
        }
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        ByteArrayInputStream is = new ByteArrayInputStream(processXML.getBytes());
        XMLInputFactory factory = XMLInputFactory.newInstance();
        ConcurrentMap conditionTargetTask = Maps.newConcurrentMap();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            BpmnModel bpmnModel = bpmnXMLConverter.convertToBpmnModel(reader);
            Process pro = null;
            Iterator iterator = bpmnModel.getProcesses().iterator();
            while (iterator.hasNext()) {
                Process bpmnModelProcess;
                pro = bpmnModelProcess = (Process)iterator.next();
            }
            Map flowElementMap = pro.getFlowElementMap();
            for (String s : flowElementMap.keySet()) {
                if (!s.startsWith("SequenceFlow")) continue;
                SequenceFlow flowElement = (SequenceFlow)flowElementMap.get(s);
                String targetRef = flowElement.getTargetRef();
                conditionTargetTask.put(s, targetRef);
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        this.parseAndSave(processDesingerJSON, processId, processDesingerVO, conditionTargetTask);
    }

    private void parseAndSave(String processDesingerJSON, long processId, ProcessDesingerVO processDesingerVO, Map<String, String> flowElementMap) {
        List<ProcessNodeVO> nodeSettings = processDesingerVO.getNodeSettings();
        ArrayList nodeFormFields = Lists.newArrayList();
        ArrayList nodeExtends = Lists.newArrayList();
        ArrayList nodeConnections = Lists.newArrayList();
        ArrayList nodeApprovers = Lists.newArrayList();
        ArrayList nodeCcs = Lists.newArrayList();
        for (ProcessNodeVO nodeSetting : nodeSettings) {
            List<ProcessNodeFormFieldEntity> formFields;
            List<NodeCcVO> nodeSettingCc;
            BillAction actionType;
            List<String> listenerClses;
            String ntype = nodeSetting.getNtype();
            String nodeId = nodeSetting.getNodeId();
            String listeners = nodeSetting.getListeners();
            if (!Strings.isNullOrEmpty((String)listeners) && CollectionUtil.isNotEmpty(listenerClses = Arrays.asList(StrUtil.split((CharSequence)listeners, (CharSequence)",")))) {
                for (String listenerCls : listenerClses) {
                    try {
                        Class.forName(listenerCls);
                    }
                    catch (ClassNotFoundException e) {
                        log.error("the listener {}. not found", (Object)listenerCls);
                        throw new ListenerNotFoundException(ProcessAdminCode.LISTENER_NOT_FOUND, e);
                    }
                }
            }
            long nodeExtendId = IdWorker.getId();
            ProcessNodeExtendEntity nodeExtend = new ProcessNodeExtendEntity();
            nodeExtend.setProcessId(processId);
            nodeExtend.setId(nodeExtendId);
            nodeExtend.setNodeId(nodeId);
            nodeExtend.setBtns(nodeSetting.getBtns());
            nodeExtend.setNodeType(nodeSetting.getNtype());
            nodeExtend.setNodeName(nodeSetting.getTitle());
            nodeExtend.setAutoAgree(nodeSetting.getAutoAgree());
            nodeExtend.setAutoNextHours(nodeSetting.getAutoNextHours());
            nodeExtend.setCountersignFlag(nodeSetting.getCountersignFlag());
            nodeExtend.setBatchApproval(nodeSetting.getBatchApproval());
            nodeExtend.setNoApprovalOperation(nodeSetting.getNoApprovalOperation());
            nodeExtend.setSelectApproval(nodeSetting.getSelectApproval());
            NodeLinkType linkType = nodeSetting.getLinkType();
            if (linkType != null) {
                nodeExtend.setLinkType(linkType.name());
            }
            if ((actionType = nodeSetting.getActionType()) != null) {
                nodeExtend.setNodeAction(actionType.name());
            }
            nodeExtend.setCreationTime(LocalDateTime.now());
            nodeExtend.setNodeSetting("{}");
            if (StringUtils.equals((CharSequence)ntype, (CharSequence)"line")) {
                nodeExtends.add(nodeExtend);
                ProcessNodeConnectionEntity connection = this.parseLineNode(nodeSetting, nodeExtendId, processId, actionType, flowElementMap);
                nodeConnections.add(connection);
                continue;
            }
            if (!StringUtils.equals((CharSequence)ntype, (CharSequence)"task")) continue;
            nodeExtends.add(nodeExtend);
            List<NodeApproverVO> approver = nodeSetting.getApprover();
            List<NodeApproverVO> nodeSettingApprover = this.sortApprover(approver);
            if (CollectionUtil.isNotEmpty(nodeSettingApprover)) {
                for (int i = 0; i < nodeSettingApprover.size(); ++i) {
                    Map params;
                    NodeApproverVO approverVO = nodeSettingApprover.get(i);
                    ProcessNodeApproverEntity nodeApprover = new ProcessNodeApproverEntity();
                    nodeApprover.setDateline(DateTimeUtil.unixTime());
                    nodeApprover.setNodeId(nodeSetting.getNodeId());
                    nodeApprover.setNodeExtendId(nodeExtendId);
                    nodeApprover.setProcessId(processId);
                    nodeApprover.setWeight(approverVO.getWeight());
                    List<ConditionVo> conditionList = approverVO.getCondition();
                    Pair<List<String>, Map<String, Object>> expressConditionList = this.multiConditionParse(conditionList, i);
                    if (expressConditionList == null) continue;
                    List expressApprovalList = (List)expressConditionList.getFirst();
                    if (CollectionUtil.isNotEmpty((Collection)expressApprovalList)) {
                        String expressJoin = StrUtil.format((CharSequence)"({})", (Object[])new Object[]{StrUtil.join((CharSequence)"&&", (Object[])new Object[]{expressApprovalList})});
                        nodeApprover.setExpress(expressJoin);
                    }
                    if (CollectionUtil.isNotEmpty((Map)(params = (Map)expressConditionList.getSecond()))) {
                        nodeApprover.setExpressParams(JSON.toJSONString((Object)params));
                    } else {
                        nodeApprover.setExpressParams("{}");
                    }
                    List<NodeSubjectVO> subjects = approverVO.getSubject();
                    if (CollectionUtil.isEmpty(subjects)) {
                        nodeApprover.setApprover("[]");
                    } else {
                        nodeApprover.setApprover(JSON.toJSONString(subjects));
                    }
                    CountersignVO countersign = approverVO.getCountersign();
                    if (Objects.isNull(countersign)) {
                        nodeApprover.setApprover("{'type':1,'count':1}");
                    } else {
                        nodeApprover.setCountersign(JSON.toJSONString((Object)countersign));
                    }
                    nodeApprovers.add(nodeApprover);
                }
            }
            if (CollectionUtil.isNotEmpty(nodeSettingCc = this.sortCc(nodeSetting.getCc()))) {
                for (int i = 0; i < nodeSettingCc.size(); ++i) {
                    Map params;
                    NodeCcVO nodeCcVO = nodeSettingCc.get(i);
                    ProcessNodeCcEntity nodeCc = new ProcessNodeCcEntity();
                    nodeCc.setDateline(DateTimeUtil.unixTime());
                    nodeCc.setNodeId(nodeSetting.getNodeId());
                    nodeCc.setNodeExtendId(nodeExtendId);
                    nodeCc.setProcessId(processId);
                    List<ConditionVo> conditionList = nodeCcVO.getCondition();
                    Pair<List<String>, Map<String, Object>> expressConditionList = this.multiConditionParse(conditionList, i);
                    if (expressConditionList == null) continue;
                    List expressCondList = (List)expressConditionList.getFirst();
                    if (CollectionUtil.isNotEmpty((Collection)expressCondList)) {
                        String express = StrUtil.format((CharSequence)"({})", (Object[])new Object[]{StrUtil.join((CharSequence)"&&", (Object[])new Object[]{expressCondList})});
                        nodeCc.setExpress(express);
                    }
                    if (CollectionUtil.isNotEmpty((Map)(params = (Map)expressConditionList.getSecond()))) {
                        nodeCc.setExpressParams(JSON.toJSONString((Object)params));
                    } else {
                        nodeCc.setExpressParams("{}");
                    }
                    List<NodeSubjectVO> subjects = nodeCcVO.getSubject();
                    if (CollectionUtil.isEmpty(subjects)) {
                        nodeCc.setCc("[]");
                    } else {
                        nodeCc.setCc(JSON.toJSONString(subjects));
                    }
                    nodeCcs.add(nodeCc);
                }
            }
            if (!CollectionUtil.isNotEmpty(formFields = nodeSetting.toFormField(processId))) continue;
            nodeFormFields.addAll(formFields);
        }
        this.nodeFormFieldService.saveOrUpdate(nodeFormFields, processId);
        this.nodeExtendService.saveOrUpdate(nodeExtends, processId);
        this.nodeApproverService.saveOrUpdate(nodeApprovers, processId);
        this.nodeConnectionService.saveOrUpdate(nodeConnections, processId);
        this.nodeCcService.saveOrUpdate(nodeCcs, processId);
        this.processDesingerService.saveOrUpdateByProcess(processId, processDesingerJSON, processDesingerVO);
    }

    private ProcessNodeConnectionEntity parseLineNode(ProcessNodeVO nodeSetting, long nodeExtendId, long processId, BillAction actionType, Map<String, String> flowElementMap) {
        int unixTime = DateTimeUtil.unixTime();
        ProcessNodeConnectionEntity connection = new ProcessNodeConnectionEntity();
        connection.setProcessId(processId);
        connection.setNodeExtendId(nodeExtendId);
        connection.setNodeId(nodeSetting.getNodeId());
        connection.setDateline(unixTime);
        List<LineConditionVO> conditions = nodeSetting.getConditions();
        String lastTaskCode = "lastTaskCode";
        if (CollectionUtil.isEmpty(conditions)) {
            connection.setExpress("");
            connection.setExpressParams("{}");
            if (actionType.equals((Object)BillAction.refuse)) {
                connection.setExpress("(" + lastTaskCode + "=='" + flowElementMap.get(connection.getNodeId()) + "')");
            }
        } else {
            ArrayList expressList = Lists.newArrayList();
            HashMap expressParams = Maps.newHashMap();
            List<LineConditionVO> conditionVOS = this.sortCondition(conditions);
            for (int i = 0; i < conditionVOS.size(); ++i) {
                Pair<List<String>, Map<String, Object>> conditionParse;
                LineConditionVO conditionVO = conditionVOS.get(i);
                List<ConditionVo> conditionList = conditionVO.getCondition();
                if (CollectionUtil.isEmpty(conditionList) || (conditionParse = this.multiConditionParse(conditionList, i)) == null) continue;
                List expressConditionList = (List)conditionParse.getFirst();
                Map conditionParams = (Map)conditionParse.getSecond();
                if (CollectionUtil.isNotEmpty((Map)conditionParams)) {
                    expressParams.putAll(conditionParams);
                }
                if (actionType.equals((Object)BillAction.refuse)) {
                    expressConditionList.add(lastTaskCode + "=='" + flowElementMap.get(connection.getNodeId()) + "'");
                }
                if (!CollectionUtil.isNotEmpty((Collection)expressConditionList)) continue;
                expressList.add(StrUtil.format((CharSequence)"({})", (Object[])new Object[]{StrUtil.join((CharSequence)"&&", (Object[])new Object[]{expressConditionList})}));
            }
            if (CollectionUtil.isNotEmpty((Collection)expressList)) {
                String express = StrUtil.join((CharSequence)"||", (Object[])new Object[]{expressList});
                connection.setExpress(express);
                connection.setExpressParams(JSON.toJSONString((Object)expressParams));
            }
        }
        return connection;
    }

    private Pair<List<String>, Map<String, Object>> multiConditionParse(List<ConditionVo> conditionList, int index) {
        if (CollectionUtil.isEmpty(conditionList)) {
            return null;
        }
        HashMap expressParams = Maps.newHashMap();
        ArrayList expressConditionList = Lists.newArrayList();
        for (int i = 0; i < conditionList.size(); ++i) {
            ConditionVo conditionVo = conditionList.get(i);
            Pair<String, Map<String, Object>> expressAndParam = conditionVo.toExpress(i, index);
            if (expressAndParam == null) continue;
            String excepress = (String)expressAndParam.getFirst();
            expressConditionList.add(excepress);
            Map params = (Map)expressAndParam.getSecond();
            if (!CollectionUtil.isNotEmpty((Map)params)) continue;
            expressParams.putAll(params);
        }
        return Pair.of((Object)expressConditionList, (Object)expressParams);
    }

    private List<LineConditionVO> sortCondition(List<LineConditionVO> conditions) {
        List conditionVOS;
        int conditionSize = conditions.size();
        if (conditionSize > 1) {
            ConditionWeightComparator comparator = new ConditionWeightComparator();
            Ordering ordering = Ordering.from((Comparator)comparator);
            conditionVOS = ordering.sortedCopy(conditions);
        } else {
            conditionVOS = conditions;
        }
        return conditionVOS;
    }

    private List<NodeApproverVO> sortApprover(List<NodeApproverVO> approverVOS) {
        List conditionVOS;
        if (CollectionUtil.isEmpty(approverVOS)) {
            return Collections.emptyList();
        }
        int conditionSize = approverVOS.size();
        if (conditionSize > 1) {
            NodeApproverComparator comparator = new NodeApproverComparator();
            Ordering ordering = Ordering.from((Comparator)comparator);
            conditionVOS = ordering.sortedCopy(approverVOS);
        } else {
            conditionVOS = approverVOS;
        }
        return conditionVOS;
    }

    private List<NodeCcVO> sortCc(List<NodeCcVO> nodeCcVOS) {
        List conditionVOS;
        if (CollectionUtil.isEmpty(nodeCcVOS)) {
            return Collections.emptyList();
        }
        int conditionSize = nodeCcVOS.size();
        if (conditionSize > 1) {
            NodeCcComparator comparator = new NodeCcComparator();
            Ordering ordering = Ordering.from((Comparator)comparator);
            conditionVOS = ordering.sortedCopy(nodeCcVOS);
        } else {
            conditionVOS = nodeCcVOS;
        }
        return conditionVOS;
    }

    public ProcessDesingerLogicImpl(ToaProcessService toaProcessService, FormDesingerService formDesingerService, ProcessDesingerService processDesingerService, ProcessNodeFormFieldService nodeFormFieldService, ProcessNodeExtendService nodeExtendService, ProcessNodeApproverService nodeApproverService, ProcessNodeConnectionService nodeConnectionService, ProcessNodeCcService nodeCcService, ProcessBasicConvert processBasicConvert, FormBasicConvert formBasicConvert) {
        this.toaProcessService = toaProcessService;
        this.formDesingerService = formDesingerService;
        this.processDesingerService = processDesingerService;
        this.nodeFormFieldService = nodeFormFieldService;
        this.nodeExtendService = nodeExtendService;
        this.nodeApproverService = nodeApproverService;
        this.nodeConnectionService = nodeConnectionService;
        this.nodeCcService = nodeCcService;
        this.processBasicConvert = processBasicConvert;
        this.formBasicConvert = formBasicConvert;
    }
}

