/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.jingtong.bpm.facde.dto.BaseProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessGridDTO;
import com.jingtong.bpm.infra.entity.ProcessBillTitleEntity;
import com.jingtong.bpm.infra.entity.ProcessDesingerEntity;
import com.jingtong.bpm.infra.entity.ToaFormEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.po.ProcessGridPO;
import com.jingtong.bpm.infra.service.FormSettingService;
import com.jingtong.bpm.infra.service.ProcessBillTitleService;
import com.jingtong.bpm.infra.service.ProcessDesingerService;
import com.jingtong.bpm.infra.service.ToaFormService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.constant.ProcessCode;
import com.jingtong.bpm.logic.constant.ProcessConst;
import com.jingtong.bpm.logic.converts.ProcessBasicConvert;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.ProcessFlowLogic;
import com.jingtong.bpm.logic.util.BpmnXmlUtil;
import com.jingtong.bpm.logic.vo.ProcessDesingerVO;
import com.jingtong.bpm.logic.vo.ProcessNodeVO;
import com.jingtong.config.BpmConfig;
import com.jingtong.config.TenantProperties;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.ErrorCode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;

@Service
public class ProcessFlowLogicImpl
implements ProcessFlowLogic {
    private static final Logger log = LoggerFactory.getLogger(ProcessFlowLogicImpl.class);
    private final ToaProcessService toaProcessService;
    private final ToaFormService toaFormService;
    private final ProcessDesingerService processDesingerService;
    private final RepositoryService repositoryService;
    private final BpmConfig bpmConfig;
    private final TenantProperties tenantProperties;
    private final ProcessBillTitleService processBillTitleService;
    private final FormSettingService formSettingService;
    private final ProcessBasicConvert processBasicConvert;

    @Override
    public Pair<List<ProcessGridDTO>, Long> getProcessFlowByPage(Integer pageNo, Integer pageSize, Map<String, Object> params, String bloc) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        HashMap parm = Maps.newHashMap();
        if (!Objects.isNull(params.get("q"))) {
            String text = (String)params.get("q");
            String decode = "{}";
            try {
                decode = URLDecoder.decode(text, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            JSONObject q = JSON.parseObject((String)decode);
            for (String s : q.keySet()) {
                parm.put(s, q.get((Object)s));
            }
        }
        List<ProcessGridPO> list = this.toaProcessService.selectByPaging(page, parm, bloc, this.tenantProperties.getEnable());
        List<ProcessGridDTO> gridDTOS = this.processBasicConvert.processGridPOToDTO(list);
        return new Pair(gridDTOS, (Object)page.getTotal());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveProcess(BaseProcessDTO process, String bloc) {
        ProcessBillTitleEntity billTitle;
        boolean state;
        ToaProcessEntity processEntity = this.processBasicConvert.baseProcessDTOToEntity(process);
        if (this.tenantProperties.getEnable().booleanValue()) {
            processEntity.setBlocCode(bloc);
        }
        long processId = (Long)MoreObjects.firstNonNull((Object)process.getId(), (Object)0L);
        LocalDateTime now = LocalDateTime.now();
        if (processId > 0L) {
            processEntity.setUpdateTime(now);
            state = this.toaProcessService.upldate(processEntity);
        } else {
            processEntity.setId(IdWorker.getId());
            processEntity.setCode(IdWorker.get32UUID());
            processEntity.setCreationTime(now);
            processEntity.setStatus(0);
            state = this.toaProcessService.insert(processEntity);
            if (state) {
                ToaFormEntity form = new ToaFormEntity();
                form.setProcessId(process.getId());
                form.setProcessFlag(1);
                form.setName(process.getName());
                form.setCreationTime(now);
                String dateStr = DateTimeUtil.format((LocalDateTime)now, (String)"yyyyMMdd") + RandomUtil.randomNumbers((int)4);
                form.setCode(dateStr);
                state = this.toaFormService.insert(form);
            }
        }
        if (!state) {
            throw new RbException("update process has error!");
        }
        Optional unique = this.processBillTitleService.unique((LambdaQueryWrapper)Wrappers.lambdaQuery(ProcessBillTitleEntity.class).eq(ProcessBillTitleEntity::getProcessId, (Object)processEntity.getId()));
        if (unique.isPresent()) {
            billTitle = (ProcessBillTitleEntity)((Object)unique.get());
            billTitle.setCreationTime(LocalDateTime.now());
        } else {
            billTitle = new ProcessBillTitleEntity();
            billTitle.setUpdateTime(LocalDateTime.now());
            billTitle.setProcessId(processEntity.getId());
        }
        billTitle.setTimePattern("yyyy-MM-dd");
        billTitle.setTimeFlag(1);
        billTitle.setProcessTitle(1);
        billTitle.setProcessType(0);
        billTitle.setCreaterFlag(1);
        billTitle.setFormula("#{processName}-#{processCreater}-#{today}");
        this.processBillTitleService.saveOrUpdate((Object)billTitle);
        return state;
    }

    @Override
    public boolean removeProcess(long processId) {
        return this.toaProcessService.removeById(Long.valueOf(processId));
    }

    @Override
    public boolean cancelProcess(long processId) {
        return this.updateStatus(processId, 0);
    }

    @Override
    public boolean enableProcess(long processId) {
        return this.updateStatus(processId, 1);
    }

    @Override
    public boolean disableProcess(long processId) {
        return this.updateStatus(processId, 3);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean releaseProcess(long processId) {
        ToaProcessEntity process = (ToaProcessEntity)((Object)this.toaProcessService.getById(Long.valueOf(processId)));
        Preconditions.checkNotNull((Object)((Object)process));
        ProcessDesingerEntity processDesinger = (ProcessDesingerEntity)((Object)this.processDesingerService.getOne((Wrapper)Wrappers.lambdaQuery(ProcessDesingerEntity.class).eq(ProcessDesingerEntity::getProcessId, (Object)processId)));
        String processXml = processDesinger.getProcessXml();
        String desingerJson = processDesinger.getDesingerJson();
        ProcessDesingerVO desingerVO = (ProcessDesingerVO)JSON.parseObject((String)desingerJson, ProcessDesingerVO.class);
        List<ProcessNodeVO> nodeSettings = desingerVO.getNodeSettings();
        String bpmnXML = BpmnXmlUtil.destBpmnXml(processXml, processId, nodeSettings);
        String processKey = StrUtil.format((CharSequence)"Process_{}", (Object[])new Object[]{processId});
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        Deployment deployment = deploymentBuilder.addString(processKey + ".bpmn", bpmnXML).name(processKey).deploy();
        if (deployment == null) {
            throw new RbException("", (ErrorCode)ProcessCode.DEPLOYEE_FAILURE);
        }
        ProcessDefinitionQuery pdq = this.repositoryService.createProcessDefinitionQuery();
        long count = pdq.processDefinitionKey(processKey).deploymentId(deployment.getId()).count();
        if (count > 0L) {
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
            String diagramName = processDefinition.getDiagramResourceName();
            int version = processDefinition.getVersion();
            String diagramRelativeFilePath = StrUtil.format((CharSequence)ProcessConst.DIAGRAM_PATH, (Object[])new Object[]{processKey, version, diagramName});
            String diagramFilePath = this.bpmConfig.getFilePath() + File.separator + diagramRelativeFilePath;
            this.exportDiagramToFile(processDefinition, diagramFilePath);
            LocalDateTime now = LocalDateTime.now();
            process.setUpdateTime(now);
            process.setFlowId(processKey);
            process.setBpmVersion(version);
            process.setDiagramPath(diagramRelativeFilePath);
            process.setStatus(1);
            boolean updateState = this.toaProcessService.upldate(process);
            if (!updateState) {
                throw new RbException((ErrorCode)BillCode.PROCESS_PUBLISHING_ERROR);
            }
            return true;
        }
        throw new RbException("", (ErrorCode)ProcessCode.DEPLOYEE_FAILURE);
    }

    @Override
    public boolean openProcess(long processId) {
        return this.updateCLoseFlag(processId, false);
    }

    private boolean updateCLoseFlag(long processId, boolean closeFlag) {
        ToaProcessEntity byId = (ToaProcessEntity)((Object)this.toaProcessService.getById(Long.valueOf(processId)));
        byId.setCloseFlag(closeFlag ? 1 : 0);
        return this.toaProcessService.upldate(byId);
    }

    @Override
    public boolean closeProcess(long processId) {
        return this.updateCLoseFlag(processId, true);
    }

    @Override
    public BaseProcessDTO getBaseInfo(Long id) {
        ToaProcessEntity byId = (ToaProcessEntity)((Object)this.toaProcessService.getById(id));
        if (Objects.isNull((Object)byId)) {
            return null;
        }
        return this.processBasicConvert.processEntityToDTO(byId);
    }

    @Override
    public String getPrintTmp(Long processId) {
        String printTmp = this.formSettingService.getPrintTmp(processId);
        return Strings.isNullOrEmpty((String)printTmp) ? "" : printTmp;
    }

    private void exportDiagramToFile(ProcessDefinition processDefinition, String diagramFilePath) {
        String diagramName = processDefinition.getDiagramResourceName();
        File diagramFile = new File(diagramFilePath);
        if (!diagramFile.exists()) {
            try {
                Files.createParentDirs((File)diagramFile);
            }
            catch (IOException e) {
                log.error("\u521b\u5efa\u6d41\u7a0b\u56fe\u5931\u8d25!", (Throwable)e);
                throw new NullPointerException("\u6d41\u7a0b\u56fe\u521b\u5efa\u5931\u8d25");
            }
        }
        try {
            String deploymentId = processDefinition.getDeploymentId();
            InputStream resourceAsStream = this.repositoryService.getResourceAsStream(deploymentId, diagramName);
            FileCopyUtils.copy((InputStream)resourceAsStream, (OutputStream)new FileOutputStream(diagramFile));
        }
        catch (IOException e) {
            log.error("\u6d41\u7a0b\u56fe\u8f6c\u6362\u56fe\u7247\u53d1\u751f\u9519\u8bef!", (Throwable)e);
        }
    }

    private boolean updateStatus(long processId, int processStatusNormal) {
        ToaProcessEntity processEntity = (ToaProcessEntity)((Object)this.toaProcessService.getById(Long.valueOf(processId)));
        processEntity.setStatus(processStatusNormal);
        return this.toaProcessService.upldate(processEntity);
    }

    public ProcessFlowLogicImpl(ToaProcessService toaProcessService, ToaFormService toaFormService, ProcessDesingerService processDesingerService, RepositoryService repositoryService, BpmConfig bpmConfig, TenantProperties tenantProperties, ProcessBillTitleService processBillTitleService, FormSettingService formSettingService, ProcessBasicConvert processBasicConvert) {
        this.toaProcessService = toaProcessService;
        this.toaFormService = toaFormService;
        this.processDesingerService = processDesingerService;
        this.repositoryService = repositoryService;
        this.bpmConfig = bpmConfig;
        this.tenantProperties = tenantProperties;
        this.processBillTitleService = processBillTitleService;
        this.formSettingService = formSettingService;
        this.processBasicConvert = processBasicConvert;
    }
}

