/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jingtong.bpm.infra.entity.FormDesingerEntity;
import com.jingtong.bpm.infra.entity.FormFieldEntity;
import com.jingtong.bpm.infra.entity.ToaFormEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.service.FormDesingerService;
import com.jingtong.bpm.infra.service.FormDetailSettingService;
import com.jingtong.bpm.infra.service.FormFieldService;
import com.jingtong.bpm.infra.service.FormTableService;
import com.jingtong.bpm.infra.service.ToaFormService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.constant.ProcessAdminCode;
import com.jingtong.bpm.logic.constant.ProcessCode;
import com.jingtong.bpm.logic.define.FormXtype;
import com.jingtong.bpm.logic.define.WidgetOnlyType;
import com.jingtong.bpm.logic.define.widget.WidgetField;
import com.jingtong.bpm.logic.dto.FormAttrDto;
import com.jingtong.bpm.logic.dto.FormColumnDto;
import com.jingtong.bpm.logic.dto.FormDesignerSaveDto;
import com.jingtong.bpm.logic.dto.FormTableDto;
import com.jingtong.bpm.logic.dto.FormTableFieldDto;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.ProcessFormLogic;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.ErrorCode;
import com.jingtong.util.serialize.JsonMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcessFormLogicImpl
implements ProcessFormLogic {
    private static final Logger log = LoggerFactory.getLogger(ProcessFormLogicImpl.class);
    private static final String FORM_TABLE_NAME_PREFIX = "form_sheet_main_";
    private final ToaProcessService toaProcessService;
    private final ToaFormService toaFormService;
    private final FormDesingerService formDesingerService;
    private final FormTableService formTableService;
    private final FormFieldService formFieldService;
    private final FormDetailSettingService formDetailSettingService;

    @Override
    public boolean saveForm(String data) {
        FormDesignerSaveDto formDesignerDto = (FormDesignerSaveDto)JSON.parseObject((String)data, FormDesignerSaveDto.class);
        FormAttrDto formAttr = formDesignerDto.getAttr();
        List<List<FormColumnDto>> columnItems = formDesignerDto.getColumnItems();
        long processId = formAttr.getId();
        if (processId <= 0L) {
            log.error("\u6d41\u7a0bid\u4f20\u9012\u7a7a\u503c\u4e86\uff0c\u65e0\u6cd5\u8fdb\u884c\u5904\u7406");
            throw new RbException("", (ErrorCode)ProcessCode.PROCESS_ID_REQUIRED);
        }
        ToaProcessEntity process = (ToaProcessEntity)((Object)this.toaProcessService.getById(Long.valueOf(processId)));
        if (process == null) {
            throw new RbException("", (ErrorCode)ProcessCode.PROCESS_NOT_FOUND);
        }
        try {
            process.setIconId(formAttr.getIcon());
            this.toaProcessService.upldate(process);
            ToaFormEntity form = this.saveFormAttr(formDesignerDto, processId);
            this.saveFromColumn(columnItems, form);
            this.saveFrom(data, form);
            return true;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u8868\u5355 [{}] \u4fe1\u606f\u51fa\u73b0\u9519\u8bef", (Object)JsonMapper.toJson((Object)formDesignerDto), (Object)e);
            throw new RbException("", (ErrorCode)ProcessAdminCode.FORM_SAVE_ERROR);
        }
    }

    private void saveFrom(String formDesingerData, ToaFormEntity form) {
        boolean state;
        Preconditions.checkNotNull((Object)((Object)form), (Object)"\u8868\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Long formId = form.getId();
        Preconditions.checkNotNull((Object)formId, (Object)"\u8868\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        FormDesingerEntity formDesinger = (FormDesingerEntity)((Object)this.formDesingerService.getOne((Wrapper)Wrappers.lambdaQuery(FormDesingerEntity.class).eq(FormDesingerEntity::getFormId, (Object)formId)));
        if (formDesinger == null) {
            formDesinger = new FormDesingerEntity();
            formDesinger.setFormId(formId);
            formDesinger.setDesingerJson(formDesingerData);
            formDesinger.setColumns("{}");
            state = this.formDesingerService.insert(formDesinger);
        } else {
            formDesinger.setDesingerJson(formDesingerData);
            state = this.formDesingerService.upldate(formDesinger);
        }
        if (!state) {
            log.error("form desinger save error!");
            throw new RbException((ErrorCode)BillCode.FROM_DESIGN_SAVE_ERROR);
        }
    }

    private void saveFromColumn(List<List<FormColumnDto>> columnItems, ToaFormEntity form) {
        block22: {
            ArrayList tableFields;
            ArrayList details;
            String tableName;
            block21: {
                boolean fieldState;
                Long formId = form.getId();
                List formFieldList = this.formFieldService.list((Wrapper)Wrappers.lambdaQuery(FormFieldEntity.class).eq(FormFieldEntity::getFormId, (Object)formId));
                if (CollectionUtil.isNotEmpty((Collection)formFieldList)) {
                    ArrayList deleteIds = Lists.newArrayList();
                    for (FormFieldEntity formField : formFieldList) {
                        deleteIds.add(formField.getId());
                    }
                    boolean deleteState = this.formFieldService.removeByIds(deleteIds);
                    if (!deleteState) {
                        log.error("form {} from column save has error!", (Object)formId);
                        throw new RbException((ErrorCode)BillCode.FROM_DESIGN_FILED_SAVE_ERROR);
                    }
                }
                tableName = form.getTableName();
                details = Lists.newArrayList();
                FormTableDto mainTable = new FormTableDto();
                mainTable.setTableName(tableName);
                mainTable.setComment(form.getName());
                ArrayList formFields = Lists.newArrayList();
                tableFields = Lists.newArrayList();
                ArrayList detailFields = Lists.newArrayList();
                int sort = 1;
                int detailOrder = 1;
                for (List<FormColumnDto> columnItem : columnItems) {
                    for (FormColumnDto formColumnDto : columnItem) {
                        WidgetOnlyType widget;
                        WidgetField widgetFiled;
                        String widgetJSON = formColumnDto.getWidget();
                        if (Strings.isNullOrEmpty((String)widgetJSON) || (widgetFiled = (widget = (WidgetOnlyType)JSON.parseObject((String)widgetJSON, WidgetOnlyType.class)).getXtype().toField(widgetJSON)) == null) continue;
                        FormFieldEntity formField = widgetFiled.toField(formId, sort);
                        formFields.add(formField);
                        List<FormTableFieldDto> tableField = widgetFiled.toTableField();
                        tableFields.addAll(tableField);
                        FormXtype xtype = widget.getXtype();
                        switch (xtype) {
                            case detailgroup: {
                                long detailFiledId = IdWorker.getId();
                                formField.setId(detailFiledId);
                                List formItems = widgetFiled.items();
                                if (!CollectionUtil.isNotEmpty(formItems)) break;
                                FormTableDto detailTable = new FormTableDto();
                                detailTable.setTableName(tableName + "_dt" + detailOrder);
                                detailTable.setComment(form.getName() + widgetFiled.title());
                                ArrayList detailTableFields = Lists.newArrayList();
                                int detailSort = 1;
                                for (WidgetField detailWidget : formItems) {
                                    FormFieldEntity detailField = detailWidget.toField(formId, detailSort, detailFiledId);
                                    formFields.add(detailField);
                                    detailFields.add(detailField);
                                    List<FormTableFieldDto> detailTableField = detailWidget.toTableField();
                                    if (CollectionUtil.isNotEmpty(detailTableField)) {
                                        detailTableFields.addAll(detailTableField);
                                    }
                                    ++detailSort;
                                }
                                details.add(Pair.of((Object)detailTable, (Object)detailTableFields));
                                ++detailOrder;
                                break;
                            }
                        }
                    }
                    ++sort;
                }
                if (CollectionUtil.isEmpty((Collection)formFields)) {
                    return;
                }
                if (CollectionUtil.isNotEmpty((Collection)detailFields)) {
                    this.formDetailSettingService.createDetailSetting(detailFields, form);
                }
                if (!(fieldState = this.formFieldService.saveBatch(formFields))) {
                    log.error("form field save has error!");
                    throw new RbException((ErrorCode)BillCode.FROM_DESIGN_FILED_SAVE_ERROR);
                }
                String tableExistName = this.formTableService.isTargetTableExistInDB(tableName);
                if (!Strings.isNullOrEmpty((String)tableExistName)) break block21;
                this.formTableService.createMainTable(mainTable, tableFields);
                if (!CollectionUtil.isNotEmpty((Collection)details)) break block22;
                for (Pair tablePair : details) {
                    FormTableDto table = (FormTableDto)tablePair.getKey();
                    List fields = (List)tablePair.getValue();
                    this.formTableService.createDetailTable(table, fields);
                }
                break block22;
            }
            List<String> columns = this.formTableService.findColumnNameByTableName(tableName);
            ArrayList mainAddFields = Lists.newArrayList();
            for (FormTableFieldDto tableField : tableFields) {
                if (columns.contains(tableField.getFieldName())) continue;
                mainAddFields.add(tableField);
            }
            for (FormTableFieldDto mainAddField : mainAddFields) {
                this.formTableService.addColumn(tableName, mainAddField);
            }
            if (CollectionUtil.isNotEmpty((Collection)details)) {
                for (Pair detail : details) {
                    ArrayList detailAddColumns = Lists.newArrayList();
                    FormTableDto detailTable = (FormTableDto)detail.getKey();
                    String detailTableName = detailTable.getTableName();
                    List<String> detailTableColumns = this.formTableService.findColumnNameByTableName(detailTableName);
                    if (CollectionUtil.isEmpty(detailTableColumns)) {
                        this.formTableService.createDetailTable(detailTable, (List)detail.getValue());
                        continue;
                    }
                    for (FormTableFieldDto tableField : (List)detail.getValue()) {
                        if (detailTableColumns.contains(tableField.getFieldName())) continue;
                        detailAddColumns.add(tableField);
                    }
                    for (FormTableFieldDto addField : detailAddColumns) {
                        this.formTableService.addColumn(detailTableName, addField);
                    }
                }
            }
        }
    }

    private ToaFormEntity saveFormAttr(FormDesignerSaveDto formDesignerDto, long processId) {
        boolean state;
        FormAttrDto formAttr = formDesignerDto.getAttr();
        ToaFormEntity form = (ToaFormEntity)((Object)this.toaFormService.getOne((Wrapper)Wrappers.lambdaQuery(ToaFormEntity.class).eq(ToaFormEntity::getProcessId, (Object)processId)));
        List<List<FormColumnDto>> columnItems = formDesignerDto.getColumnItems();
        boolean detailFileldFlag = this.containsDetailFileldFlag(columnItems);
        if (form == null) {
            int size = this.formTableService.findByTableSize(FORM_TABLE_NAME_PREFIX);
            if (size <= 0) {
                size = 1;
            }
            form = new ToaFormEntity();
            form.setTableName(FORM_TABLE_NAME_PREFIX + size);
            form.setProcessFlag(1);
            form.setProcessId(processId);
            form.setClientAppFlag(0);
            form.setCode(DateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMdd") + RandomStringUtils.randomNumeric((int)4));
            form.setDescription(formAttr.getDescription());
            if (formAttr.getIcon() > 0L) {
                form.setIcon(String.valueOf(formAttr.getIcon()));
            }
            form.setLayout(formAttr.getLayout().getColgroup().size());
            form.setName(formAttr.getName());
            form.setSort(1);
            form.setDetailFieldFlag(detailFileldFlag ? 1 : 0);
            form.setDocumentation("");
            form.setStyle(JSON.toJSONString((Object)formAttr.getStyle()));
            state = this.toaFormService.insert(form);
        } else {
            if (StringUtils.isEmpty((CharSequence)form.getTableName())) {
                int size = this.formTableService.findByTableSize(FORM_TABLE_NAME_PREFIX);
                if (size <= 0) {
                    size = 1;
                }
                form.setTableName(FORM_TABLE_NAME_PREFIX + size);
            }
            form.setDetailFieldFlag(detailFileldFlag ? 1 : 0);
            form.setDescription(formAttr.getDescription());
            if (formAttr.getIcon() > 0L) {
                form.setIcon(String.valueOf(formAttr.getIcon()));
            }
            form.setLayout(formAttr.getLayout().getColgroup().size());
            form.setName(formAttr.getName());
            state = this.toaFormService.upldate(form);
        }
        if (!state) {
            log.error("process from save error!");
            throw new RbException((ErrorCode)BillCode.FROM_DESIGN_SAVE_ERROR);
        }
        return form;
    }

    private boolean containsDetailFileldFlag(List<List<FormColumnDto>> columnItems) {
        if (CollectionUtil.isNotEmpty(columnItems)) {
            for (List<FormColumnDto> formColumns : columnItems) {
                for (FormColumnDto formColumn : formColumns) {
                    String widgetJSON = formColumn.getWidget();
                    if (Strings.isNullOrEmpty((String)widgetJSON)) continue;
                    WidgetOnlyType widgetOnlyType = (WidgetOnlyType)JSON.parseObject((String)widgetJSON, WidgetOnlyType.class);
                    FormXtype xtype = widgetOnlyType.getXtype();
                    switch (xtype) {
                        case detailgroup: {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public ProcessFormLogicImpl(ToaProcessService toaProcessService, ToaFormService toaFormService, FormDesingerService formDesingerService, FormTableService formTableService, FormFieldService formFieldService, FormDetailSettingService formDetailSettingService) {
        this.toaProcessService = toaProcessService;
        this.toaFormService = toaFormService;
        this.formDesingerService = formDesingerService;
        this.formTableService = formTableService;
        this.formFieldService = formFieldService;
        this.formDetailSettingService = formDetailSettingService;
    }
}

