/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.jingtong.base.infra.entity.BaseEntity;
import com.jingtong.bpm.facde.dto.ProcessTypeDTO;
import com.jingtong.bpm.infra.entity.ProcessTypeEntity;
import com.jingtong.bpm.infra.po.ProcessGridPO;
import com.jingtong.bpm.infra.service.ProcessTypeService;
import com.jingtong.bpm.infra.service.ToaProcessService;
import com.jingtong.bpm.logic.converts.ProcessBasicConvert;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.ProcessTypeLogic;
import com.jingtong.bpm.logic.vo.ProcessTypeVO;
import com.jingtong.config.TenantProperties;
import com.jingtong.data.exception.RbException;
import com.jingtong.util.error.ErrorCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ProcessTypeLogicImpl
implements ProcessTypeLogic {
    private final TenantProperties tenantProperties;
    private final ProcessTypeService processTypeService;
    private final ToaProcessService processService;
    private final ProcessBasicConvert processBasicConvert;

    @Override
    public Pair<List<com.jingtong.bpm.logic.dto.ProcessTypeDTO>, Long> getProcessTypeByPage(Integer pageNo, Integer pageSize) {
        Page page = (Page)this.processTypeService.page((IPage)new Page((long)pageNo.intValue(), (long)pageSize.intValue()));
        List<com.jingtong.bpm.logic.dto.ProcessTypeDTO> list = this.processBasicConvert.processTypesEntityToDTO(page.getRecords());
        return new Pair(list, (Object)page.getTotal());
    }

    @Override
    public com.jingtong.bpm.logic.dto.ProcessTypeDTO getDetail(Long id) {
        ProcessTypeEntity typeEntity = (ProcessTypeEntity)((Object)this.processTypeService.getById(id));
        return this.processBasicConvert.processTypeEntityToDTO(typeEntity);
    }

    @Override
    public boolean batchDeleteByIds(List<String> idList) {
        return this.processTypeService.removeByIds(idList);
    }

    @Override
    public boolean save(com.jingtong.bpm.logic.dto.ProcessTypeDTO processType) {
        ProcessTypeEntity processTypeEntity = this.processBasicConvert.processTypeDTOToEntity(processType);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(ProcessTypeEntity.class);
        if (Objects.isNull(processType.getId()) || processType.getId().compareTo(0L) <= 0) {
            queryWrapper.eq(ProcessTypeEntity::getCode, (Object)processType.getCode());
            ProcessTypeEntity one = (ProcessTypeEntity)((Object)this.processTypeService.getOne((Wrapper)queryWrapper));
            if (!Objects.isNull((Object)one)) {
                throw new RbException((ErrorCode)BillCode.PROCESS_CATEGORY_CODE_EXIST);
            }
            queryWrapper.clear();
            queryWrapper.eq(ProcessTypeEntity::getName, (Object)processType.getName().trim());
            one = (ProcessTypeEntity)((Object)this.processTypeService.getOne((Wrapper)queryWrapper));
            if (!Objects.isNull((Object)one)) {
                throw new RbException((ErrorCode)BillCode.PROCESS_CATEGORY_NAME_EXIST);
            }
            processTypeEntity.setId(IdWorker.getId());
            return this.processTypeService.insert(processTypeEntity);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(ProcessTypeEntity::getCode, (Object)processType.getCode())).ne(BaseEntity::getId, (Object)processType.getId());
        ProcessTypeEntity one = (ProcessTypeEntity)((Object)this.processTypeService.getOne((Wrapper)queryWrapper));
        if (!Objects.isNull((Object)one)) {
            throw new RbException((ErrorCode)BillCode.PROCESS_CATEGORY_CODE_EXIST);
        }
        queryWrapper.clear();
        ((LambdaQueryWrapper)queryWrapper.eq(ProcessTypeEntity::getName, (Object)processType.getName().trim())).ne(BaseEntity::getId, (Object)processType.getId());
        one = (ProcessTypeEntity)((Object)this.processTypeService.getOne((Wrapper)queryWrapper));
        if (!Objects.isNull((Object)one)) {
            throw new RbException((ErrorCode)BillCode.PROCESS_CATEGORY_NAME_EXIST);
        }
        return this.processTypeService.upldate(processTypeEntity);
    }

    @Override
    public List<ProcessTypeVO> selectAllWithTypeGroup(String userCode, Set<String> orgs, String bloc, String name) {
        List processTypes;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ProcessTypeEntity.class);
        if (this.tenantProperties.getEnable().booleanValue()) {
            wrapper.eq(ProcessTypeEntity::getBlocCode, (Object)bloc);
        }
        if (CollectionUtil.isNotEmpty((Collection)(processTypes = this.processTypeService.list((Wrapper)wrapper)))) {
            int processTypeSize = processTypes.size();
            ArrayList types = Lists.newArrayListWithCapacity((int)processTypeSize);
            String likeName = SqlUtils.concatLike((Object)name, (SqlLike)SqlLike.DEFAULT);
            List<ProcessGridPO> processes = this.processService.findAllByUserCode(userCode, orgs, bloc, likeName);
            if (CollectionUtil.isNotEmpty(processes)) {
                Map<Long, List<ProcessGridPO>> groupTypeProcess = processes.stream().collect(Collectors.groupingBy(ProcessGridPO::getTypeId));
                for (ProcessTypeEntity processType : processTypes) {
                    long typeId = (Long)MoreObjects.firstNonNull((Object)processType.getId(), (Object)0L);
                    List<ProcessGridPO> elements = groupTypeProcess.get(typeId);
                    ArrayList processList = Lists.newArrayList();
                    if (CollectionUtil.isEmpty(elements)) continue;
                    processList.addAll(this.processBasicConvert.processGridPOToVO(elements));
                    ProcessTypeVO processTypeVO = this.voProcessType(processType, typeId);
                    processTypeVO.setFlows(processList);
                    types.add(processTypeVO);
                }
            } else {
                for (ProcessTypeEntity processType : processTypes) {
                    long typeId = (Long)MoreObjects.firstNonNull((Object)processType.getId(), (Object)0L);
                    ProcessTypeVO processTypeVO = this.voProcessType(processType, typeId);
                    types.add(processTypeVO);
                }
            }
            return types;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessTypeDTO> getAllType() {
        List list = this.processTypeService.list();
        return this.processBasicConvert.processTypeEntityToDTO(list);
    }

    private ProcessTypeVO voProcessType(ProcessTypeEntity processType, long typeId) {
        ProcessTypeVO processTypeVO;
        if (typeId <= 0L) {
            processTypeVO = new ProcessTypeVO();
            processTypeVO.setCode("0000");
            processTypeVO.setName("\u5176\u4ed6");
            processTypeVO.setId(0L);
        } else {
            processTypeVO = new ProcessTypeVO();
            processTypeVO.setCode(processType.getCode());
            processTypeVO.setName(processType.getName());
            processTypeVO.setId(processType.getId());
        }
        return processTypeVO;
    }

    public ProcessTypeLogicImpl(TenantProperties tenantProperties, ProcessTypeService processTypeService, ToaProcessService processService, ProcessBasicConvert processBasicConvert) {
        this.tenantProperties = tenantProperties;
        this.processTypeService = processTypeService;
        this.processService = processService;
        this.processBasicConvert = processBasicConvert;
    }
}

