/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.constant.ProcessAdminCode;
import com.jingtong.bpm.logic.exception.ListenerNotFoundException;
import com.jingtong.bpm.logic.vo.LineConditionVO;
import com.jingtong.bpm.logic.vo.ProcessNodeVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnXmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnXmlUtil.class);
    private static final Map<String, String> NAMESPACECONTEXT = Maps.newHashMap();
    private static final String CREATE_TASK_LISTENER = "com.jingtong.bpm.logic.listener.CreateTaskListener";
    private static final String COMPLATE_TASK_LISTENER = "com.jingtong.bpm.logic.listener.ComplateTaskListener";
    private static final String ASSIGNEE_TASK_LISTENER = "com.jingtong.bpm.logic.listener.AssigneeTaskListener";
    private static final String GATEWAY_TASK_LISTENER = "com.jingtong.bpm.logic.listener.GatewayListener";
    private static final String BILL_PROCESS_LISTENER = "com.jingtong.bpm.logic.listener.ProcessBillListener";

    private BpmnXmlUtil() {
    }

    public static String destBpmnXml(String bpmnXml, long processId, List<ProcessNodeVO> nodeVOS) {
        Preconditions.checkNotNull((Object)bpmnXml, (Object)"xml \u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        bpmnXml = StrUtil.replace((CharSequence)bpmnXml, (CharSequence)"targetNamespace=\"http://bpmn.io/bpmn\"", (CharSequence)"typeLanguage=\"http://www.w3.org/2001/XMLSchema\"  expressionLanguage=\"http://www.w3.org/1999/XPath\" targetNamespace=\"http://jtech.oa/bpmn\"");
        bpmnXml = StrUtil.replace((CharSequence)bpmnXml, (CharSequence)"exporter=\"http://bpmn.io\"", (CharSequence)" xmlns:activiti=\"http://activiti.org/bpmn\"");
        bpmnXml = StrUtil.replace((CharSequence)bpmnXml, (CharSequence)"exporterVersion=\"0.10.1\"", (CharSequence)"");
        bpmnXml = StrUtil.replace((CharSequence)bpmnXml, (CharSequence)"<task ", (CharSequence)"<userTask ");
        bpmnXml = StrUtil.replace((CharSequence)bpmnXml, (CharSequence)"</task>", (CharSequence)"</userTask>");
        try {
            Document document = DocumentHelper.parseText((String)bpmnXml);
            BpmnXmlUtil.clearNodes(document);
            Object endEventObjs = BpmnXmlUtil.select("//bpmn:endEvent", (Branch)document);
            if (endEventObjs != null) {
                Class<?> nodeCls = endEventObjs.getClass();
                if (Collection.class.isAssignableFrom(nodeCls)) {
                    List endEventNodes = (List)endEventObjs;
                    for (Element endEventNode : endEventNodes) {
                        BpmnXmlUtil.addExecutionListener(endEventNode, "end", BILL_PROCESS_LISTENER);
                    }
                } else {
                    Element endEventEle = (Element)endEventObjs;
                    BpmnXmlUtil.addExecutionListener(endEventEle, "end", BILL_PROCESS_LISTENER);
                }
            }
            for (ProcessNodeVO nodeVO : nodeVOS) {
                String parallelGatewayXPath;
                Element taskNode;
                String nodeId;
                String ntype = nodeVO.getNtype();
                if (Strings.isNullOrEmpty((String)ntype)) continue;
                if (StrUtil.equals((CharSequence)"task", (CharSequence)ntype)) {
                    String[] listenerClses;
                    String listeners;
                    nodeId = nodeVO.getNodeId();
                    String userTaskXPath = StrUtil.format((CharSequence)"//bpmn:userTask[@id='{}']", (Object[])new Object[]{nodeId});
                    taskNode = (Element)BpmnXmlUtil.select(userTaskXPath, (Branch)document);
                    if (taskNode == null) continue;
                    NodeLinkType linkType = nodeVO.getLinkType();
                    if (linkType == NodeLinkType.create) {
                        BpmnXmlUtil.addTaskNodeAssignee(taskNode, "${var_apply_employee}");
                        BpmnXmlUtil.addNodeTaskListener(taskNode, "assignment", ASSIGNEE_TASK_LISTENER);
                    } else {
                        BpmnXmlUtil.addNodeTaskListener(taskNode, "create", CREATE_TASK_LISTENER);
                        BpmnXmlUtil.addNodeTaskListener(taskNode, "complete", COMPLATE_TASK_LISTENER);
                    }
                    if (Strings.isNullOrEmpty((String)(listeners = nodeVO.getListeners())) || !CollectionUtil.isNotEmpty(Arrays.asList(listenerClses = StrUtil.split((CharSequence)listeners, (CharSequence)",")))) continue;
                    for (String listenerCls : listenerClses) {
                        try {
                            Class.forName(listenerCls);
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.error("the listener  {}. not found", (Object)listenerCls);
                            throw new ListenerNotFoundException(ProcessAdminCode.LISTENER_NOT_FOUND);
                        }
                        BpmnXmlUtil.addNodeTaskListener(taskNode, "complete", listenerCls);
                    }
                    continue;
                }
                if (StrUtil.equals((CharSequence)"line", (CharSequence)ntype)) {
                    nodeId = nodeVO.getNodeId();
                    String sequenceFlowPath = StrUtil.format((CharSequence)"//bpmn:sequenceFlow[@id='{}']", (Object[])new Object[]{nodeId});
                    Element sequenceFlow = (Element)BpmnXmlUtil.select(sequenceFlowPath, (Branch)document);
                    if (sequenceFlow == null) continue;
                    List<LineConditionVO> conditions = nodeVO.getConditions();
                    BillAction actionType = nodeVO.getActionType();
                    if (actionType == null) continue;
                    switch (actionType) {
                        case refuse: {
                            String expressFormat = "${{}=='{}'}";
                            String express = StrUtil.format((CharSequence)expressFormat, (Object[])new Object[]{"var_action", BillAction.refuse.toString()});
                            BpmnXmlUtil.addNodeExpressElement(sequenceFlow, express);
                            break;
                        }
                        case agree: {
                            String express;
                            String expressFormat;
                            if (CollectionUtil.isNotEmpty(conditions)) {
                                expressFormat = "${lineExpr.invoke({},'{}','{}',{},{},{},{})}";
                                express = StrUtil.format((CharSequence)expressFormat, (Object[])new Object[]{"execution", processId, nodeId, "var_bill_context", "var_approver_employee", "var_formData", "var_action"});
                            } else {
                                expressFormat = "${{}=='{}'}";
                                express = StrUtil.format((CharSequence)expressFormat, (Object[])new Object[]{"var_action", BillAction.agree.toString()});
                            }
                            BpmnXmlUtil.addNodeExpressElement(sequenceFlow, express);
                            break;
                        }
                    }
                    continue;
                }
                if (!StrUtil.equals((CharSequence)"judge", (CharSequence)ntype) || (taskNode = (Element)BpmnXmlUtil.select(parallelGatewayXPath = StrUtil.format((CharSequence)"//bpmn:parallelGateway[@id='{}']", (Object[])new Object[]{nodeId = nodeVO.getNodeId()}), (Branch)document)) == null) continue;
                BpmnXmlUtil.addExecutionListener(taskNode, "take", GATEWAY_TASK_LISTENER);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The process xml is \n{}", (Object)document.asXML());
            }
            return document.asXML();
        }
        catch (DocumentException e) {
            LOGGER.error("parse workflow document xml has error!", (Throwable)e);
            e.printStackTrace();
            return bpmnXml;
        }
    }

    private static void addNodeExpressElement(Element sequenceFlow, String express) {
        Element conditionExpression = sequenceFlow.addElement("conditionExpression");
        conditionExpression.addAttribute("xsi:type", "tFormalExpression");
        conditionExpression.addCDATA(express);
    }

    private static void clearNodes(Document document) {
        List outgoings = (List)BpmnXmlUtil.select("//bpmn:outgoing", (Branch)document);
        for (Element outgoing : outgoings) {
            outgoing.getParent().remove(outgoing);
        }
        List incomings = (List)BpmnXmlUtil.select("//bpmn:incoming", (Branch)document);
        for (Element incoming : incomings) {
            incoming.getParent().remove(incoming);
        }
    }

    private static void addOwnerElement(Element taskNode, String expressionVal) {
        Element potentialOwner = taskNode.addElement("potentialOwner");
        Element resourceAssignment = potentialOwner.addElement("resourceAssignmentExpression");
        Element formalExpression = resourceAssignment.addElement("formalExpression");
        formalExpression.addCDATA(expressionVal);
    }

    private static void addNodeTaskListener(Element node, String event, String className) {
        Element extensionElements = node.element("extensionElements");
        if (extensionElements == null) {
            extensionElements = node.addElement("extensionElements");
        }
        Element taskListener = extensionElements.addElement("activiti:taskListener");
        taskListener.addAttribute("event", event);
        taskListener.addAttribute("class", className);
    }

    private static Element addExecutionListener(Element taskNode, String event, String className) {
        Element extensionElements = taskNode.addElement("extensionElements").addNamespace("activiti", "http://activiti.org/bpmn");
        Element taskListener = extensionElements.addElement("activiti:executionListener");
        taskListener.addAttribute("event", event);
        taskListener.addAttribute("class", className);
        return extensionElements;
    }

    private static void addTaskNodeAssignee(Element taskNode, String variable) {
        if (Strings.isNullOrEmpty((String)variable)) {
            return;
        }
        taskNode.addAttribute("activiti:assignee", variable);
    }

    private static Object select(String expression, Branch contextNode) {
        XPath xp = contextNode.createXPath(expression);
        xp.setNamespaceURIs(NAMESPACECONTEXT);
        return xp.evaluate((Object)contextNode);
    }

    static {
        NAMESPACECONTEXT.put("bpmn", "http://www.omg.org/spec/BPMN/20100524/MODEL");
    }
}

