/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.vo;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jingtong.bpm.logic.util.TextUtil;
import com.jingtong.bpm.logic.vo.ConditionFieldVO;
import com.jingtong.bpm.logic.vo.Select2VO;
import com.jingtong.bpm.logic.vo.TreeDataVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.util.Pair;

public class ConditionVo
implements Serializable {
    private static final long serialVersionUID = -2319373705159780765L;
    private List<TreeDataVO> positions;
    private String relation;
    private ConditionFieldVO field;
    private int type;
    private String value;
    private List<TreeDataVO> users;
    private List<TreeDataVO> organizations;
    private List<Select2VO> projectTypes;
    private List<Select2VO> projectRoles;
    private Select2VO userProject;

    public Pair<String, Map<String, Object>> toExpress(int index, int conditionIndex) {
        String relation = this.getRelation();
        if (StringUtils.equals((CharSequence)relation, (CharSequence)"exclude")) {
            relation = StrUtil.format((CharSequence)"!{}", (Object[])new Object[]{"implication"});
        } else if (StringUtils.equals((CharSequence)relation, (CharSequence)"include")) {
            relation = "implication";
        }
        switch (this.type) {
            case 1: {
                ConditionFieldVO field = this.getField();
                if (field == null) {
                    return null;
                }
                String widgetName = field.getWidgetName();
                String value = this.getValue();
                String format = StringUtils.isNumeric((CharSequence)value) || TextUtil.isDouble(value) ? "var_formData.{}{}{}" : "var_formData.{}{}'{}'";
                if (relation.contains("implication")) {
                    String express = StrUtil.format((CharSequence)"{}(fd_{}_{},var_formData.{})", (Object[])new Object[]{relation, index, conditionIndex, widgetName});
                    HashMap expressParams = Maps.newHashMap();
                    expressParams.put("fd_" + index + "_" + conditionIndex, value.split(","));
                    return Pair.of((Object)express, (Object)expressParams);
                }
                String express = StrUtil.format((CharSequence)format, (Object[])new Object[]{widgetName, relation, value});
                Map expressParams = Collections.emptyMap();
                return Pair.of((Object)express, expressParams);
            }
            case 2: {
                List<TreeDataVO> positions = this.getPositions();
                if (CollectionUtil.isEmpty(positions)) {
                    return null;
                }
                String express = StrUtil.format((CharSequence)"{}(positions_{}_{},{})", (Object[])new Object[]{relation, index, conditionIndex, "ae_position"});
                ArrayList paramsValues = Lists.newArrayList();
                for (TreeDataVO position : positions) {
                    paramsValues.add(String.valueOf(position.getId()));
                }
                HashMap expressParams = Maps.newHashMap();
                expressParams.put("positions_" + index + "_" + conditionIndex, paramsValues);
                return Pair.of((Object)express, (Object)expressParams);
            }
            case 3: {
                List<TreeDataVO> organizations = this.getOrganizations();
                if (CollectionUtil.isEmpty(organizations)) {
                    return null;
                }
                String express = StrUtil.format((CharSequence)"{}(organizations_{}_{},{})", (Object[])new Object[]{relation, index, conditionIndex, "ae_org"});
                ArrayList paramsValues = Lists.newArrayList();
                for (TreeDataVO organization : organizations) {
                    paramsValues.add(String.valueOf(organization.getCode()));
                }
                HashMap expressParams = Maps.newHashMap();
                expressParams.put("organizations_" + index + "_" + conditionIndex, paramsValues);
                return Pair.of((Object)express, (Object)expressParams);
            }
            case 4: {
                if (CollectionUtil.isEmpty(this.users)) {
                    return null;
                }
                String express = StrUtil.format((CharSequence)"{}(users_{}_{},{})", (Object[])new Object[]{relation, index, conditionIndex, "var_apply_employee"});
                ArrayList paramsValues = Lists.newArrayList();
                for (TreeDataVO user : this.users) {
                    paramsValues.add(String.valueOf(user.getId()));
                }
                HashMap expressParams = Maps.newHashMap();
                expressParams.put("users_" + index + "_" + conditionIndex, paramsValues);
                return Pair.of((Object)express, (Object)expressParams);
            }
            case 5: {
                if (CollectionUtil.isEmpty(this.projectTypes)) {
                    return null;
                }
                String varPrjectTypeKey = StrUtil.format((CharSequence)"pt_{}_{}", (Object[])new Object[]{index, conditionIndex});
                String express = StrUtil.format((CharSequence)"{}({},{})", (Object[])new Object[]{relation, varPrjectTypeKey, "var_porjcet_type"});
                ArrayList paramsValues = Lists.newArrayList();
                for (Select2VO select2VO : this.projectTypes) {
                    paramsValues.add(String.valueOf(select2VO.getId()));
                }
                HashMap expressParams = Maps.newHashMap();
                expressParams.put(varPrjectTypeKey, paramsValues);
                return Pair.of((Object)express, (Object)expressParams);
            }
            case 6: {
                if (this.userProject == null) {
                    return null;
                }
                String userProjectKey = StrUtil.format((CharSequence)"up_{}_{}", (Object[])new Object[]{index, conditionIndex});
                String express = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{"var_user_project_role", relation, userProjectKey});
                HashMap expressParam = Maps.newHashMap();
                expressParam.put(userProjectKey, this.userProject.getId());
                return Pair.of((Object)express, (Object)expressParam);
            }
            case 8: {
                if (this.projectRoles == null) {
                    return null;
                }
                String varPrjectRoleKey = StrUtil.format((CharSequence)"pr_{}_{}", (Object[])new Object[]{index, conditionIndex});
                String templateFormProject = "{}({},'{}',{})";
                String express = StrUtil.format((CharSequence)"{}({},'{}',{})", (Object[])new Object[]{"implication", "var_porject", relation, varPrjectRoleKey});
                HashMap expressParams = Maps.newHashMap();
                ArrayList _projectRoles = Lists.newArrayList();
                for (Select2VO roleSelect : this.projectRoles) {
                    _projectRoles.add(String.valueOf(roleSelect.getId()));
                }
                expressParams.put(varPrjectRoleKey, _projectRoles);
                return Pair.of((Object)express, (Object)expressParams);
            }
        }
        return null;
    }

    public List<TreeDataVO> getPositions() {
        return this.positions;
    }

    public String getRelation() {
        return this.relation;
    }

    public ConditionFieldVO getField() {
        return this.field;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public List<TreeDataVO> getUsers() {
        return this.users;
    }

    public List<TreeDataVO> getOrganizations() {
        return this.organizations;
    }

    public List<Select2VO> getProjectTypes() {
        return this.projectTypes;
    }

    public List<Select2VO> getProjectRoles() {
        return this.projectRoles;
    }

    public Select2VO getUserProject() {
        return this.userProject;
    }

    public void setPositions(List<TreeDataVO> positions) {
        this.positions = positions;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public void setField(ConditionFieldVO field) {
        this.field = field;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUsers(List<TreeDataVO> users) {
        this.users = users;
    }

    public void setOrganizations(List<TreeDataVO> organizations) {
        this.organizations = organizations;
    }

    public void setProjectTypes(List<Select2VO> projectTypes) {
        this.projectTypes = projectTypes;
    }

    public void setProjectRoles(List<Select2VO> projectRoles) {
        this.projectRoles = projectRoles;
    }

    public void setUserProject(Select2VO userProject) {
        this.userProject = userProject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionVo)) {
            return false;
        }
        ConditionVo other = (ConditionVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        List<TreeDataVO> this$positions = this.getPositions();
        List<TreeDataVO> other$positions = other.getPositions();
        if (this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        ConditionFieldVO this$field = this.getField();
        ConditionFieldVO other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<TreeDataVO> this$users = this.getUsers();
        List<TreeDataVO> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        List<TreeDataVO> this$organizations = this.getOrganizations();
        List<TreeDataVO> other$organizations = other.getOrganizations();
        if (this$organizations == null ? other$organizations != null : !((Object)this$organizations).equals(other$organizations)) {
            return false;
        }
        List<Select2VO> this$projectTypes = this.getProjectTypes();
        List<Select2VO> other$projectTypes = other.getProjectTypes();
        if (this$projectTypes == null ? other$projectTypes != null : !((Object)this$projectTypes).equals(other$projectTypes)) {
            return false;
        }
        List<Select2VO> this$projectRoles = this.getProjectRoles();
        List<Select2VO> other$projectRoles = other.getProjectRoles();
        if (this$projectRoles == null ? other$projectRoles != null : !((Object)this$projectRoles).equals(other$projectRoles)) {
            return false;
        }
        Select2VO this$userProject = this.getUserProject();
        Select2VO other$userProject = other.getUserProject();
        return !(this$userProject == null ? other$userProject != null : !((Object)this$userProject).equals(other$userProject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        List<TreeDataVO> $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 43 : ((Object)$positions).hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        ConditionFieldVO $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<TreeDataVO> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        List<TreeDataVO> $organizations = this.getOrganizations();
        result = result * 59 + ($organizations == null ? 43 : ((Object)$organizations).hashCode());
        List<Select2VO> $projectTypes = this.getProjectTypes();
        result = result * 59 + ($projectTypes == null ? 43 : ((Object)$projectTypes).hashCode());
        List<Select2VO> $projectRoles = this.getProjectRoles();
        result = result * 59 + ($projectRoles == null ? 43 : ((Object)$projectRoles).hashCode());
        Select2VO $userProject = this.getUserProject();
        result = result * 59 + ($userProject == null ? 43 : ((Object)$userProject).hashCode());
        return result;
    }

    public String toString() {
        return "ConditionVo(positions=" + this.getPositions() + ", relation=" + this.getRelation() + ", field=" + this.getField() + ", type=" + this.getType() + ", value=" + this.getValue() + ", users=" + this.getUsers() + ", organizations=" + this.getOrganizations() + ", projectTypes=" + this.getProjectTypes() + ", projectRoles=" + this.getProjectRoles() + ", userProject=" + this.getUserProject() + ")";
    }
}

