/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.logic.vo;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Lists;
import com.jingtong.bpm.infra.entity.ProcessNodeFormFieldEntity;
import com.jingtong.bpm.logic.constant.BillAction;
import com.jingtong.bpm.logic.constant.NodeLinkType;
import com.jingtong.bpm.logic.vo.LineConditionVO;
import com.jingtong.bpm.logic.vo.NodeApproverVO;
import com.jingtong.bpm.logic.vo.NodeCcVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProcessNodeVO
implements Serializable {
    private static final long serialVersionUID = -8473379548632314058L;
    private String desc;
    private String nodeId;
    private NodeLinkType linkType;
    private BillAction actionType;
    private String ntype;
    private String title;
    private BigDecimal autoNextHours;
    private String autoAgree;
    private String btns;
    private Integer countersignFlag;
    private Integer batchApproval;
    private Integer noApprovalOperation;
    private Integer selectApproval;
    private List<LineConditionVO> conditions;
    private List<NodeApproverVO> approver;
    private List<NodeCcVO> cc;
    private String listeners;
    private Map<String, Integer> permissions;

    public List<ProcessNodeFormFieldEntity> toFormField(long processId) {
        if (CollectionUtil.isEmpty(this.permissions)) {
            return Collections.emptyList();
        }
        ArrayList formFields = Lists.newArrayListWithCapacity((int)this.permissions.size());
        LocalDateTime now = LocalDateTime.now();
        for (String key : this.permissions.keySet()) {
            ProcessNodeFormFieldEntity nodeFormField = new ProcessNodeFormFieldEntity();
            nodeFormField.setFormWidgetName(key);
            nodeFormField.setNodeId(this.nodeId);
            int type = this.permissions.get(key);
            switch (type) {
                case 0: {
                    nodeFormField.setEditFlag(0);
                    nodeFormField.setVisibleFlag(0);
                    break;
                }
                case 1: {
                    nodeFormField.setEditFlag(1);
                    nodeFormField.setVisibleFlag(0);
                    break;
                }
                case 2: {
                    nodeFormField.setEditFlag(0);
                    nodeFormField.setVisibleFlag(1);
                    break;
                }
                case 3: {
                    nodeFormField.setEditFlag(1);
                    nodeFormField.setVisibleFlag(1);
                    break;
                }
                default: {
                    nodeFormField.setEditFlag(0);
                    nodeFormField.setVisibleFlag(0);
                }
            }
            nodeFormField.setUpdateTime(now);
            nodeFormField.setProcessId(processId);
            formFields.add(nodeFormField);
        }
        return formFields;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public NodeLinkType getLinkType() {
        return this.linkType;
    }

    public BillAction getActionType() {
        return this.actionType;
    }

    public String getNtype() {
        return this.ntype;
    }

    public String getTitle() {
        return this.title;
    }

    public BigDecimal getAutoNextHours() {
        return this.autoNextHours;
    }

    public String getAutoAgree() {
        return this.autoAgree;
    }

    public String getBtns() {
        return this.btns;
    }

    public Integer getCountersignFlag() {
        return this.countersignFlag;
    }

    public Integer getBatchApproval() {
        return this.batchApproval;
    }

    public Integer getNoApprovalOperation() {
        return this.noApprovalOperation;
    }

    public Integer getSelectApproval() {
        return this.selectApproval;
    }

    public List<LineConditionVO> getConditions() {
        return this.conditions;
    }

    public List<NodeApproverVO> getApprover() {
        return this.approver;
    }

    public List<NodeCcVO> getCc() {
        return this.cc;
    }

    public String getListeners() {
        return this.listeners;
    }

    public Map<String, Integer> getPermissions() {
        return this.permissions;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setLinkType(NodeLinkType linkType) {
        this.linkType = linkType;
    }

    public void setActionType(BillAction actionType) {
        this.actionType = actionType;
    }

    public void setNtype(String ntype) {
        this.ntype = ntype;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAutoNextHours(BigDecimal autoNextHours) {
        this.autoNextHours = autoNextHours;
    }

    public void setAutoAgree(String autoAgree) {
        this.autoAgree = autoAgree;
    }

    public void setBtns(String btns) {
        this.btns = btns;
    }

    public void setCountersignFlag(Integer countersignFlag) {
        this.countersignFlag = countersignFlag;
    }

    public void setBatchApproval(Integer batchApproval) {
        this.batchApproval = batchApproval;
    }

    public void setNoApprovalOperation(Integer noApprovalOperation) {
        this.noApprovalOperation = noApprovalOperation;
    }

    public void setSelectApproval(Integer selectApproval) {
        this.selectApproval = selectApproval;
    }

    public void setConditions(List<LineConditionVO> conditions) {
        this.conditions = conditions;
    }

    public void setApprover(List<NodeApproverVO> approver) {
        this.approver = approver;
    }

    public void setCc(List<NodeCcVO> cc) {
        this.cc = cc;
    }

    public void setListeners(String listeners) {
        this.listeners = listeners;
    }

    public void setPermissions(Map<String, Integer> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessNodeVO)) {
            return false;
        }
        ProcessNodeVO other = (ProcessNodeVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$countersignFlag = this.getCountersignFlag();
        Integer other$countersignFlag = other.getCountersignFlag();
        if (this$countersignFlag == null ? other$countersignFlag != null : !((Object)this$countersignFlag).equals(other$countersignFlag)) {
            return false;
        }
        Integer this$batchApproval = this.getBatchApproval();
        Integer other$batchApproval = other.getBatchApproval();
        if (this$batchApproval == null ? other$batchApproval != null : !((Object)this$batchApproval).equals(other$batchApproval)) {
            return false;
        }
        Integer this$noApprovalOperation = this.getNoApprovalOperation();
        Integer other$noApprovalOperation = other.getNoApprovalOperation();
        if (this$noApprovalOperation == null ? other$noApprovalOperation != null : !((Object)this$noApprovalOperation).equals(other$noApprovalOperation)) {
            return false;
        }
        Integer this$selectApproval = this.getSelectApproval();
        Integer other$selectApproval = other.getSelectApproval();
        if (this$selectApproval == null ? other$selectApproval != null : !((Object)this$selectApproval).equals(other$selectApproval)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        NodeLinkType this$linkType = this.getLinkType();
        NodeLinkType other$linkType = other.getLinkType();
        if (this$linkType == null ? other$linkType != null : !((Object)((Object)this$linkType)).equals((Object)other$linkType)) {
            return false;
        }
        BillAction this$actionType = this.getActionType();
        BillAction other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        String this$ntype = this.getNtype();
        String other$ntype = other.getNtype();
        if (this$ntype == null ? other$ntype != null : !this$ntype.equals(other$ntype)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        BigDecimal this$autoNextHours = this.getAutoNextHours();
        BigDecimal other$autoNextHours = other.getAutoNextHours();
        if (this$autoNextHours == null ? other$autoNextHours != null : !((Object)this$autoNextHours).equals(other$autoNextHours)) {
            return false;
        }
        String this$autoAgree = this.getAutoAgree();
        String other$autoAgree = other.getAutoAgree();
        if (this$autoAgree == null ? other$autoAgree != null : !this$autoAgree.equals(other$autoAgree)) {
            return false;
        }
        String this$btns = this.getBtns();
        String other$btns = other.getBtns();
        if (this$btns == null ? other$btns != null : !this$btns.equals(other$btns)) {
            return false;
        }
        List<LineConditionVO> this$conditions = this.getConditions();
        List<LineConditionVO> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<NodeApproverVO> this$approver = this.getApprover();
        List<NodeApproverVO> other$approver = other.getApprover();
        if (this$approver == null ? other$approver != null : !((Object)this$approver).equals(other$approver)) {
            return false;
        }
        List<NodeCcVO> this$cc = this.getCc();
        List<NodeCcVO> other$cc = other.getCc();
        if (this$cc == null ? other$cc != null : !((Object)this$cc).equals(other$cc)) {
            return false;
        }
        String this$listeners = this.getListeners();
        String other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !this$listeners.equals(other$listeners)) {
            return false;
        }
        Map<String, Integer> this$permissions = this.getPermissions();
        Map<String, Integer> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessNodeVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $countersignFlag = this.getCountersignFlag();
        result = result * 59 + ($countersignFlag == null ? 43 : ((Object)$countersignFlag).hashCode());
        Integer $batchApproval = this.getBatchApproval();
        result = result * 59 + ($batchApproval == null ? 43 : ((Object)$batchApproval).hashCode());
        Integer $noApprovalOperation = this.getNoApprovalOperation();
        result = result * 59 + ($noApprovalOperation == null ? 43 : ((Object)$noApprovalOperation).hashCode());
        Integer $selectApproval = this.getSelectApproval();
        result = result * 59 + ($selectApproval == null ? 43 : ((Object)$selectApproval).hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        NodeLinkType $linkType = this.getLinkType();
        result = result * 59 + ($linkType == null ? 43 : ((Object)((Object)$linkType)).hashCode());
        BillAction $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        String $ntype = this.getNtype();
        result = result * 59 + ($ntype == null ? 43 : $ntype.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        BigDecimal $autoNextHours = this.getAutoNextHours();
        result = result * 59 + ($autoNextHours == null ? 43 : ((Object)$autoNextHours).hashCode());
        String $autoAgree = this.getAutoAgree();
        result = result * 59 + ($autoAgree == null ? 43 : $autoAgree.hashCode());
        String $btns = this.getBtns();
        result = result * 59 + ($btns == null ? 43 : $btns.hashCode());
        List<LineConditionVO> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<NodeApproverVO> $approver = this.getApprover();
        result = result * 59 + ($approver == null ? 43 : ((Object)$approver).hashCode());
        List<NodeCcVO> $cc = this.getCc();
        result = result * 59 + ($cc == null ? 43 : ((Object)$cc).hashCode());
        String $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : $listeners.hashCode());
        Map<String, Integer> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    public String toString() {
        return "ProcessNodeVO(desc=" + this.getDesc() + ", nodeId=" + this.getNodeId() + ", linkType=" + (Object)((Object)this.getLinkType()) + ", actionType=" + (Object)((Object)this.getActionType()) + ", ntype=" + this.getNtype() + ", title=" + this.getTitle() + ", autoNextHours=" + this.getAutoNextHours() + ", autoAgree=" + this.getAutoAgree() + ", btns=" + this.getBtns() + ", countersignFlag=" + this.getCountersignFlag() + ", batchApproval=" + this.getBatchApproval() + ", noApprovalOperation=" + this.getNoApprovalOperation() + ", selectApproval=" + this.getSelectApproval() + ", conditions=" + this.getConditions() + ", approver=" + this.getApprover() + ", cc=" + this.getCc() + ", listeners=" + this.getListeners() + ", permissions=" + this.getPermissions() + ")";
    }
}

